import UITypes from '../UITypes';
export class OracleUi {
    //#region statics
    static getNewTableColumns() {
        return [
            {
                column_name: 'id',
                title: 'Id',
                dt: 'integer',
                dtx: 'integer',
                ct: 'int(11)',
                nrqd: false,
                rqd: true,
                ck: false,
                pk: true,
                un: false,
                ai: false,
                cdf: null,
                clen: null,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: 'ID',
                uip: '',
                uicn: '',
            },
            {
                column_name: 'title',
                title: 'Title',
                dt: 'TEXT',
                dtx: 'specificType',
                ct: null,
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                cdf: null,
                clen: null,
                np: null,
                ns: null,
                dtxp: '45',
                dtxs: '',
                altered: 1,
                uidt: 'SingleLineText',
                uip: '',
                uicn: '',
            },
            // {
            //  column_name: "created_at",
            //   dt: "timestamp",
            //   dtx: "specificType",
            //   ct: "varchar(45)",
            //   nrqd: true,
            //   rqd: false,
            //   ck: false,
            //   pk: false,
            //   un: false,
            //   ai: false,
            //   cdf: 'CURRENT_TIMESTAMP',
            //   clen: 45,
            //   np: null,
            //   ns: null,
            //   dtxp: '',
            //   dtxs: ''
            // },
            // {
            //  column_name: "updated_at",
            //   dt: "timestamp",
            //   dtx: "specificType",
            //   ct: "varchar(45)",
            //   nrqd: true,
            //   rqd: false,
            //   ck: false,
            //   pk: false,
            //   un: false,
            //   ai: false,
            //   cdf: 'CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP',
            //   clen: 45,
            //   np: null,
            //   ns: null,
            //   dtxp: '',
            //   dtxs: ''
            // }
            {
                column_name: 'nc_order',
                title: 'nc_order',
                dt: 'number',
                dtx: 'specificType',
                ct: 'number(38,19)',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                cdf: null,
                clen: null,
                np: 38,
                ns: 19,
                dtxp: '38,19',
                dtxs: '',
                altered: 1,
                uidt: UITypes.Order,
                uip: '',
                uicn: '',
                system: true,
            },
        ];
    }
    static getNewColumn(suffix) {
        return {
            column_name: 'title' + suffix,
            dt: 'varchar',
            dtx: 'specificType',
            ct: 'varchar(45)',
            nrqd: true,
            rqd: false,
            ck: false,
            pk: false,
            un: false,
            ai: false,
            cdf: null,
            clen: 45,
            np: null,
            ns: null,
            dtxp: '45',
            dtxs: '',
            altered: 1,
            uidt: 'SingleLineText',
            uip: '',
            uicn: '',
        };
    }
    // static getDefaultLengthForDatatype(type) {
    //   switch (type) {
    //     case "int":
    //       return 11;
    //       break;
    //     case "tinyint":
    //       return 1;
    //       break;
    //     case "smallint":
    //       return 5;
    //       break;
    //
    //     case "mediumint":
    //       return 9;
    //       break;
    //     case "bigint":
    //       return 20;
    //       break;
    //     case "bit":
    //       return 64;
    //       break;
    //     case "boolean":
    //       return '';
    //       break;
    //     case "float":
    //       return 12;
    //       break;
    //     case "decimal":
    //       return 10;
    //       break;
    //     case "double":
    //       return 22;
    //       break;
    //     case "serial":
    //       return 20;
    //       break;
    //     case "date":
    //       return '';
    //       break;
    //     case "datetime":
    //     case "timestamp":
    //       return 6;
    //       break;
    //     case "time":
    //       return '';
    //       break;
    //     case "year":
    //       return '';
    //       break;
    //     case "char":
    //       return 255;
    //       break;
    //     case "varchar":
    //       return 45;
    //       break;
    //     case "nchar":
    //       return 255;
    //       break;
    //     case "text":
    //       return '';
    //       break;
    //     case "tinytext":
    //       return '';
    //       break;
    //     case "mediumtext":
    //       return '';
    //       break;
    //     case "longtext":
    //       break;
    //       return ''
    //     case "binary":
    //       return 255;
    //       break;
    //     case "varbinary":
    //       return 65500;
    //       break;
    //     case "blob":
    //       return '';
    //       break;
    //     case "tinyblob":
    //       return '';
    //       break;
    //     case "mediumblob":
    //       return '';
    //       break;
    //     case "longblob":
    //       return '';
    //       break;
    //     case "enum":
    //       return '\'a\',\'b\'';
    //       break;
    //     case "set":
    //       return '\'a\',\'b\'';
    //       break;
    //     case "geometry":
    //       return '';
    //     case "point":
    //       return '';
    //     case "linestring":
    //       return '';
    //     case "polygon":
    //       return '';
    //     case "multipoint":
    //       return '';
    //     case "multilinestring":
    //       return '';
    //     case "multipolygon":
    //       return '';
    //     case "json":
    //       return ''
    //       break;
    //
    //   }
    //
    // }
    static getDefaultLengthForDatatype(type) {
        switch (type) {
            default:
                return '';
        }
    }
    static getDefaultLengthIsDisabled(type) {
        switch (type) {
            case 'integer':
                return true;
            case 'bfile':
            case 'binary rowid':
            case 'binary double':
            case 'binary_float':
            case 'blob':
            case 'canoical':
            case 'cfile':
            case 'char':
            case 'clob':
            case 'content pointer':
            case 'contigous array':
            case 'date':
            case 'decimal':
            case 'double precision':
            case 'float':
            case 'interval day to second':
            case 'interval year to month':
            case 'lob pointer':
            case 'long':
            case 'long raw':
            case 'named collection':
            case 'named object':
            case 'nchar':
            case 'nclob':
            case 'number':
            case 'nvarchar2':
            case 'octet':
            case 'oid':
            case 'pointer':
            case 'raw':
            case 'real':
            case 'ref':
            case 'ref cursor':
            case 'rowid':
            case 'signed binary integer':
            case 'smallint':
            case 'table':
            case 'time':
            case 'time with tz':
            case 'timestamp':
            case 'timestamp with local time zone':
            case 'timestamp with local tz':
            case 'timestamp with timezone':
            case 'timestamp with tz':
            case 'unsigned binary integer':
            case 'urowid':
            case 'varchar':
            case 'varchar2':
            case 'varray':
            case 'varying array':
                return false;
        }
    }
    static getDefaultValueForDatatype(type) {
        switch (type) {
            default:
                return '';
        }
    }
    static getDefaultScaleForDatatype(type) {
        switch (type) {
            case 'integer':
            case 'bfile':
            case 'binary rowid':
            case 'binary double':
            case 'binary_float':
            case 'blob':
            case 'canoical':
            case 'cfile':
            case 'char':
            case 'clob':
            case 'content pointer':
            case 'contigous array':
            case 'date':
            case 'decimal':
            case 'double precision':
            case 'float':
            case 'interval day to second':
            case 'interval year to month':
            case 'lob pointer':
            case 'long':
            case 'long raw':
            case 'named collection':
            case 'named object':
            case 'nchar':
            case 'nclob':
            case 'number':
            case 'nvarchar2':
            case 'octet':
            case 'oid':
            case 'pointer':
            case 'raw':
            case 'real':
            case 'ref':
            case 'ref cursor':
            case 'rowid':
            case 'signed binary integer':
            case 'smallint':
            case 'table':
            case 'time':
            case 'time with tz':
            case 'timestamp':
            case 'timestamp with local time zone':
            case 'timestamp with local tz':
            case 'timestamp with timezone':
            case 'timestamp with tz':
            case 'unsigned binary integer':
            case 'urowid':
            case 'varchar':
            case 'varchar2':
            case 'varray':
            case 'varying array':
                return ' ';
        }
    }
    static colPropAIDisabled(col, columns) {
        // console.log(col);
        if (col.dt === 'int4' ||
            col.dt === 'integer' ||
            col.dt === 'bigint' ||
            col.dt === 'smallint') {
            for (let i = 0; i < columns.length; ++i) {
                if (columns[i].cn !== col.cn && columns[i].ai) {
                    return true;
                }
            }
            return false;
        }
        else {
            return true;
        }
    }
    static colPropUNDisabled(_col) {
        // console.log(col);
        return true;
        // if (col.dt === 'int' ||
        //   col.dt === 'tinyint' ||
        //   col.dt === 'smallint' ||
        //   col.dt === 'mediumint' ||
        //   col.dt === 'bigint') {
        //   return false;
        // } else {
        //   return true;
        // }
    }
    static onCheckboxChangeAI(col) {
        console.log(col);
        if (col.dt === 'int' ||
            col.dt === 'bigint' ||
            col.dt === 'smallint' ||
            col.dt === 'tinyint') {
            col.altered = col.altered || 2;
        }
        // if (!col.ai) {
        //   col.dtx = 'specificType'
        // } else {
        //   col.dtx = ''
        // }
    }
    static showScale(_columnObj) {
        return false;
    }
    static removeUnsigned(columns) {
        for (let i = 0; i < columns.length; ++i) {
            if (columns[i].altered === 1 &&
                !(columns[i].dt === 'int' ||
                    columns[i].dt === 'bigint' ||
                    columns[i].dt === 'tinyint' ||
                    columns[i].dt === 'smallint' ||
                    columns[i].dt === 'mediumint')) {
                columns[i].un = false;
                console.log('>> resetting unsigned value', columns[i].cn);
            }
            console.log(columns[i].cn);
        }
    }
    static columnEditable(colObj) {
        return colObj.tn !== '_evolutions' || colObj.tn !== 'nc_evolutions';
    }
    static extractFunctionName(query) {
        const reg = /^\s*CREATE\s+(?:OR\s+REPLACE\s*)?\s*FUNCTION\s+(?:[\w\d_]+\.)?([\w_\d]+)/i;
        const match = query.match(reg);
        return match && match[1];
    }
    static extractProcedureName(query) {
        const reg = /^\s*CREATE\s+(?:OR\s+REPLACE\s*)?\s*PROCEDURE\s+(?:[\w\d_]+\.)?([\w_\d]+)/i;
        const match = query.match(reg);
        return match && match[1];
    }
    static splitQueries(query) {
        /***
         * we are splitting based on semicolon
         * there are mechanism to escape semicolon within single/double quotes(string)
         */
        return query.match(/\b("[^"]*;[^"]*"|'[^']*;[^']*'|[^;])*;/g);
    }
    static onCheckboxChangeAU(col) {
        console.log(col);
        // if (1) {
        col.altered = col.altered || 2;
        // }
        // if (!col.ai) {
        //   col.dtx = 'specificType'
        // } else {
        //   col.dtx = ''
        // }
    }
    /**
     * if sql statement is SELECT - it limits to a number
     * @param args
     * @returns {string|*}
     */
    sanitiseQuery(args) {
        let q = args.query.trim().split(';');
        if (q[0].startsWith('Select')) {
            q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
        }
        else if (q[0].startsWith('select')) {
            q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
        }
        else if (q[0].startsWith('SELECT')) {
            q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
        }
        else {
            return args.query;
        }
        return q;
    }
    getColumnsFromJson(json, tn) {
        const columns = [];
        try {
            if (typeof json === 'object' && !Array.isArray(json)) {
                const keys = Object.keys(json);
                for (let i = 0; i < keys.length; ++i) {
                    switch (typeof json[keys[i]]) {
                        case 'number':
                            if (Number.isInteger(json[keys[i]])) {
                                columns.push({
                                    dp: null,
                                    tn,
                                    column_name: keys[i],
                                    cno: keys[i],
                                    dt: 'int',
                                    np: 10,
                                    ns: 0,
                                    clen: null,
                                    cop: 1,
                                    pk: false,
                                    nrqd: false,
                                    rqd: false,
                                    un: false,
                                    ct: 'int(11) unsigned',
                                    ai: false,
                                    unique: false,
                                    cdf: null,
                                    cc: '',
                                    csn: null,
                                    dtx: 'specificType',
                                    dtxp: '11',
                                    dtxs: 0,
                                    altered: 1,
                                });
                            }
                            else {
                                columns.push({
                                    dp: null,
                                    tn,
                                    column_name: keys[i],
                                    cno: keys[i],
                                    dt: 'float',
                                    np: 10,
                                    ns: 2,
                                    clen: null,
                                    cop: 1,
                                    pk: false,
                                    nrqd: false,
                                    rqd: false,
                                    un: false,
                                    ct: 'int(11) unsigned',
                                    ai: false,
                                    unique: false,
                                    cdf: null,
                                    cc: '',
                                    csn: null,
                                    dtx: 'specificType',
                                    dtxp: '11',
                                    dtxs: 2,
                                    altered: 1,
                                });
                            }
                            break;
                        case 'string':
                            if (json[keys[i]].length <= 255) {
                                columns.push({
                                    dp: null,
                                    tn,
                                    column_name: keys[i],
                                    cno: keys[i],
                                    dt: 'varchar',
                                    np: 45,
                                    ns: 0,
                                    clen: null,
                                    cop: 1,
                                    pk: false,
                                    nrqd: false,
                                    rqd: false,
                                    un: false,
                                    ct: 'int(11) unsigned',
                                    ai: false,
                                    unique: false,
                                    cdf: null,
                                    cc: '',
                                    csn: null,
                                    dtx: 'specificType',
                                    dtxp: '45',
                                    dtxs: 0,
                                    altered: 1,
                                });
                            }
                            else {
                                columns.push({
                                    dp: null,
                                    tn,
                                    column_name: keys[i],
                                    cno: keys[i],
                                    dt: 'text',
                                    np: null,
                                    ns: 0,
                                    clen: null,
                                    cop: 1,
                                    pk: false,
                                    nrqd: false,
                                    rqd: false,
                                    un: false,
                                    ct: 'int(11) unsigned',
                                    ai: false,
                                    unique: false,
                                    cdf: null,
                                    cc: '',
                                    csn: null,
                                    dtx: 'specificType',
                                    dtxp: null,
                                    dtxs: 0,
                                    altered: 1,
                                });
                            }
                            break;
                        case 'boolean':
                            columns.push({
                                dp: null,
                                tn,
                                column_name: keys[i],
                                cno: keys[i],
                                dt: 'boolean',
                                np: 3,
                                ns: 0,
                                clen: null,
                                cop: 1,
                                pk: false,
                                nrqd: false,
                                rqd: false,
                                un: false,
                                ct: 'int(11) unsigned',
                                ai: false,
                                unique: false,
                                cdf: null,
                                cc: '',
                                csn: null,
                                dtx: 'specificType',
                                dtxp: '1',
                                dtxs: 0,
                                altered: 1,
                            });
                            break;
                        case 'object':
                            columns.push({
                                dp: null,
                                tn,
                                column_name: keys[i],
                                cno: keys[i],
                                dt: 'json',
                                np: 3,
                                ns: 0,
                                clen: null,
                                cop: 1,
                                pk: false,
                                nrqd: false,
                                rqd: false,
                                un: false,
                                ct: 'int(11) unsigned',
                                ai: false,
                                unique: false,
                                cdf: null,
                                cc: '',
                                csn: null,
                                dtx: 'specificType',
                                dtxp: null,
                                dtxs: 0,
                                altered: 1,
                            });
                            break;
                        default:
                            break;
                    }
                }
            }
        }
        catch (e) {
            console.log('Error in getColumnsFromJson', e);
        }
        return columns;
    }
    static colPropAuDisabled(_col) {
        return true;
    }
    static getAbstractType(col) {
        var _a;
        switch ((_a = col.dt) === null || _a === void 0 ? void 0 : _a.toLowerCase()) {
            case 'integer':
                return 'integer';
            case 'bfile':
            case 'binary rowid':
            case 'binary double':
            case 'binary_float':
                return 'string';
            case 'blob':
                return 'blob';
            case 'canoical':
            case 'cfile':
            case 'char':
            case 'clob':
            case 'content pointer':
            case 'contigous array':
                return 'string';
            case 'date':
                return 'date';
            case 'decimal':
            case 'double precision':
            case 'float':
                return 'float';
            case 'interval day to second':
            case 'interval year to month':
                return 'string';
            case 'lob pointer':
                return 'string';
            case 'long':
                return 'integer';
            case 'long raw':
                return 'string';
            case 'named collection':
            case 'named object':
            case 'nchar':
            case 'nclob':
                return 'string';
            case 'nvarchar2':
            case 'octet':
            case 'oid':
            case 'pointer':
            case 'raw':
                return 'string';
            case 'real':
            case 'number':
                return 'float';
            case 'ref':
            case 'ref cursor':
            case 'rowid':
            case 'signed binary integer':
                return 'string';
            case 'smallint':
                return 'integer';
            case 'table':
                return 'string';
            case 'time':
            case 'time with tz':
                return 'time';
            case 'timestamp':
            case 'timestamp with local time zone':
            case 'timestamp with local tz':
            case 'timestamp with timezone':
            case 'timestamp with tz':
                return 'datetime';
            case 'unsigned binary integer':
            case 'urowid':
            case 'varchar':
            case 'varchar2':
                return 'string';
            case 'varray':
            case 'varying array':
                return 'string';
        }
        return 'string';
    }
    static getUIType(col) {
        switch (this.getAbstractType(col)) {
            case 'integer':
                return 'Number';
            case 'boolean':
                return 'Checkbox';
            case 'float':
                return 'Decimal';
            case 'date':
                return 'Date';
            case 'datetime':
                return 'CreatedTime';
            case 'time':
                return 'Time';
            case 'year':
                return 'Year';
            case 'string':
                return 'SingleLineText';
            case 'text':
                return 'LongText';
            case 'blob':
                return 'Attachment';
            case 'enum':
                return 'SingleSelect';
            case 'set':
                return 'MultiSelect';
            case 'json':
                return 'LongText';
        }
    }
    static getDataTypeForUiType(col, idType) {
        const colProp = {};
        switch (col.uidt) {
            case 'ID':
                {
                    const isAutoIncId = idType === 'AI';
                    const isAutoGenId = idType === 'AG';
                    colProp.dt = isAutoGenId ? 'varchar' : 'integer';
                    colProp.pk = true;
                    colProp.un = isAutoIncId;
                    colProp.ai = isAutoIncId;
                    colProp.rqd = true;
                    colProp.meta = isAutoGenId ? { ag: 'nc' } : undefined;
                }
                break;
            case 'ForeignKey':
                colProp.dt = 'varchar';
                break;
            case 'SingleLineText':
                colProp.dt = 'clob';
                break;
            case 'LongText':
                colProp.dt = 'clob';
                break;
            case 'Attachment':
                colProp.dt = 'clob';
                break;
            case 'GeoData':
                colProp.dt = 'varchar';
                break;
            case 'Checkbox':
                colProp.dt = 'tinyint';
                colProp.dtxp = 1;
                colProp.cdf = '0';
                break;
            case 'MultiSelect':
                colProp.dt = 'varchar2';
                break;
            case 'SingleSelect':
                colProp.dt = 'varchar2';
                break;
            case 'Collaborator':
                colProp.dt = 'varchar';
                break;
            case 'Date':
                colProp.dt = 'varchar';
                break;
            case 'Year':
                colProp.dt = 'year';
                break;
            case 'Time':
                colProp.dt = 'time';
                break;
            case 'PhoneNumber':
                colProp.dt = 'varchar';
                colProp.validate = {
                    func: ['isMobilePhone'],
                    args: [''],
                    msg: ['Validation failed : isMobilePhone'],
                };
                break;
            case 'Email':
                colProp.dt = 'varchar';
                colProp.validate = {
                    func: ['isEmail'],
                    args: [''],
                    msg: ['Validation failed : isEmail'],
                };
                break;
            case 'URL':
                colProp.dt = 'clob';
                colProp.validate = {
                    func: ['isURL'],
                    args: [''],
                    msg: ['Validation failed : isURL'],
                };
                break;
            case 'Number':
                colProp.dt = 'integer';
                break;
            case 'Decimal':
                colProp.dt = 'decimal';
                break;
            case 'Currency':
                colProp.dt = 'decimal';
                colProp.validate = {
                    func: ['isCurrency'],
                    args: [''],
                    msg: ['Validation failed : isCurrency'],
                };
                break;
            case 'Percent':
                colProp.dt = 'double';
                break;
            case 'Duration':
                colProp.dt = 'integer';
                break;
            case 'Rating':
                colProp.dt = 'integer';
                colProp.cdf = '0';
                break;
            case 'Formula':
                colProp.dt = 'varchar';
                break;
            case 'Rollup':
                colProp.dt = 'varchar';
                break;
            case 'Count':
                colProp.dt = 'integer';
                break;
            case 'Lookup':
                colProp.dt = 'varchar';
                break;
            case 'DateTime':
                colProp.dt = 'timestamp';
                break;
            case 'CreatedTime':
                colProp.dt = 'timestamp';
                break;
            case 'LastModifiedTime':
                colProp.dt = 'timestamp';
                break;
            case 'AutoNumber':
                colProp.dt = 'integer';
                break;
            case 'Barcode':
                colProp.dt = 'varchar';
                break;
            case 'Button':
                colProp.dt = 'varchar';
                break;
            default:
                colProp.dt = 'varchar';
                break;
        }
        return colProp;
    }
    static getUnsupportedFnList() {
        return [
            'XOR',
            'REGEX_MATCH',
            'REGEX_EXTRACT',
            'REGEX_REPLACE',
            'VALUE',
            'COUNTA',
            'COUNT',
            'ROUNDDOWN',
            'ROUNDUP',
            'DATESTR',
            'ARRAYSORT',
            'ARRAYUNIQUE',
            'ARRAYSLICE',
            'ARRAYCOMPACT',
        ];
    }
    static getCurrentDateDefault(_col) {
        return null;
    }
    static isEqual(dataType1, dataType2) {
        if (dataType1 === dataType2)
            return true;
        const abstractType1 = this.getAbstractType({ dt: dataType1 });
        const abstractType2 = this.getAbstractType({ dt: dataType2 });
        if (abstractType1 &&
            abstractType1 === abstractType2 &&
            ['integer', 'float'].includes(abstractType1))
            return true;
        return false;
    }
    //#endregion statics
    //#region methods
    getNewTableColumns() {
        return OracleUi.getNewTableColumns();
    }
    getNewColumn(suffix) {
        return OracleUi.getNewColumn(suffix);
    }
    getDefaultLengthForDatatype(type) {
        return OracleUi.getDefaultLengthForDatatype(type);
    }
    getDefaultLengthIsDisabled(type) {
        return OracleUi.getDefaultLengthIsDisabled(type);
    }
    getDefaultValueForDatatype(type) {
        return OracleUi.getDefaultValueForDatatype(type);
    }
    getDefaultScaleForDatatype(type) {
        return OracleUi.getDefaultScaleForDatatype(type);
    }
    colPropAIDisabled(col, columns) {
        return OracleUi.colPropAIDisabled(col, columns);
    }
    colPropUNDisabled(col) {
        return OracleUi.colPropUNDisabled(col);
    }
    onCheckboxChangeAI(col) {
        return OracleUi.onCheckboxChangeAI(col);
    }
    showScale(columnObj) {
        return OracleUi.showScale(columnObj);
    }
    removeUnsigned(columns) {
        return OracleUi.removeUnsigned(columns);
    }
    columnEditable(colObj) {
        return OracleUi.columnEditable(colObj);
    }
    onCheckboxChangeAU(col) {
        return OracleUi.onCheckboxChangeAU(col);
    }
    colPropAuDisabled(col) {
        return OracleUi.colPropAuDisabled(col);
    }
    getAbstractType(col) {
        return OracleUi.getAbstractType(col);
    }
    getUIType(col) {
        return OracleUi.getUIType(col);
    }
    getDataTypeForUiType(col, idType) {
        return OracleUi.getDataTypeForUiType(col, idType);
    }
    getDataTypeListForUiType(_col, _idType) {
        throw new Error('Not implemented');
    }
    getUnsupportedFnList() {
        return OracleUi.getUnsupportedFnList();
    }
    getCurrentDateDefault(_col) {
        return OracleUi.getCurrentDateDefault(_col);
    }
    isEqual(dataType1, dataType2) {
        return OracleUi.isEqual(dataType1, dataType2);
    }
    adjustLengthAndScale(_newColumn, _oldColumn) { }
    isParsedJsonReturnType(_col) {
        return false;
    }
    get tableNameLengthLimit() {
        return 255;
    }
}
// module.exports = PgUiHelp;
//# sourceMappingURL=data:application/json;base64,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