import UITypes from '../UITypes';
const dbTypes = [
    'int',
    'integer',
    'bigint',
    'bigserial',
    'char',
    'int2',
    'int4',
    'int8',
    'int4range',
    'int8range',
    'serial',
    'serial2',
    'serial8',
    'character',
    'bit',
    'bool',
    'boolean',
    'date',
    'double precision',
    'event_trigger',
    'fdw_handler',
    'float4',
    'float8',
    'uuid',
    'smallint',
    'smallserial',
    'character varying',
    'text',
    'real',
    'time',
    'time without time zone',
    'timestamp',
    'timestamp without time zone',
    'timestamptz',
    'timestamp with time zone',
    'timetz',
    'time with time zone',
    'daterange',
    'json',
    'jsonb',
    'gtsvector',
    'index_am_handler',
    'anyenum',
    'anynonarray',
    'anyrange',
    'box',
    'bpchar',
    'bytea',
    'cid',
    'cidr',
    'circle',
    'cstring',
    'inet',
    'internal',
    'interval',
    'language_handler',
    'line',
    'lsec',
    'macaddr',
    'money',
    'name',
    'numeric',
    'numrange',
    'oid',
    'opaque',
    'path',
    'pg_ddl_command',
    'pg_lsn',
    'pg_node_tree',
    'point',
    'polygon',
    'record',
    'refcursor',
    'regclass',
    'regconfig',
    'regdictionary',
    'regnamespace',
    'regoper',
    'regoperator',
    'regproc',
    'regpreocedure',
    'regrole',
    'regtype',
    'reltime',
    'smgr',
    'tid',
    'tinterval',
    'trigger',
    'tsm_handler',
    'tsquery',
    'tsrange',
    'tstzrange',
    'tsvector',
    'txid_snapshot',
    'unknown',
    'void',
    'xid',
    'xml',
];
export class PgUi {
    //#region statics
    static getNewTableColumns() {
        return [
            {
                column_name: 'id',
                title: 'Id',
                dt: 'int4',
                dtx: 'integer',
                ct: 'int(11)',
                nrqd: false,
                rqd: true,
                ck: false,
                pk: true,
                un: false,
                ai: true,
                cdf: null,
                clen: null,
                np: 11,
                ns: 0,
                dtxp: '11',
                dtxs: '',
                altered: 1,
                uidt: 'ID',
                uip: '',
                uicn: '',
            },
            {
                column_name: 'title',
                title: 'Title',
                dt: 'TEXT',
                dtx: 'specificType',
                ct: null,
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                cdf: null,
                clen: null,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: 'SingleLineText',
                uip: '',
                uicn: '',
            },
            {
                column_name: 'created_at',
                title: 'CreatedAt',
                dt: 'timestamp',
                dtx: 'specificType',
                ct: 'timestamp',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: UITypes.CreatedTime,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'updated_at',
                title: 'UpdatedAt',
                dt: 'timestamp',
                dtx: 'specificType',
                ct: 'timestamp',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: UITypes.LastModifiedTime,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'created_by',
                title: 'nc_created_by',
                dt: 'varchar',
                dtx: 'specificType',
                ct: 'varchar(45)',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '45',
                dtxs: '',
                altered: 1,
                uidt: UITypes.CreatedBy,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'updated_by',
                title: 'nc_updated_by',
                dt: 'varchar',
                dtx: 'specificType',
                ct: 'varchar(45)',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '45',
                dtxs: '',
                altered: 1,
                uidt: UITypes.LastModifiedBy,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'nc_order',
                title: 'nc_order',
                dt: 'numeric',
                dtx: 'specificType',
                ct: 'numeric(40,20)',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                cdf: null,
                clen: null,
                np: 40,
                ns: 20,
                dtxp: '40,20',
                dtxs: '',
                altered: 1,
                uidt: UITypes.Order,
                uip: '',
                uicn: '',
                system: true,
            },
        ];
    }
    static getNewColumn(suffix) {
        return {
            column_name: 'title' + suffix,
            dt: 'TEXT',
            dtx: 'specificType',
            ct: null,
            nrqd: true,
            rqd: false,
            ck: false,
            pk: false,
            un: false,
            ai: false,
            cdf: null,
            clen: null,
            np: null,
            ns: null,
            dtxp: '',
            dtxs: '',
            altered: 1,
            uidt: 'SingleLineText',
            uip: '',
            uicn: '',
        };
    }
    // static getDefaultLengthForDatatype(type) {
    //   switch (type) {
    //     case "int":
    //       return 11;
    //       break;
    //     case "tinyint":
    //       return 1;
    //       break;
    //     case "smallint":
    //       return 5;
    //       break;
    //
    //     case "mediumint":
    //       return 9;
    //       break;
    //     case "bigint":
    //       return 20;
    //       break;
    //     case "bit":
    //       return 64;
    //       break;
    //     case "boolean":
    //       return '';
    //       break;
    //     case "float":
    //       return 12;
    //       break;
    //     case "decimal":
    //       return 10;
    //       break;
    //     case "double":
    //       return 22;
    //       break;
    //     case "serial":
    //       return 20;
    //       break;
    //     case "date":
    //       return '';
    //       break;
    //     case "datetime":
    //     case "timestamp":
    //       return 6;
    //       break;
    //     case "time":
    //       return '';
    //       break;
    //     case "year":
    //       return '';
    //       break;
    //     case "char":
    //       return 255;
    //       break;
    //     case "varchar":
    //       return 45;
    //       break;
    //     case "nchar":
    //       return 255;
    //       break;
    //     case "text":
    //       return '';
    //       break;
    //     case "tinytext":
    //       return '';
    //       break;
    //     case "mediumtext":
    //       return '';
    //       break;
    //     case "longtext":
    //       return ''
    //       break;
    //     case "binary":
    //       return 255;
    //       break;
    //     case "varbinary":
    //       return 65500;
    //       break;
    //     case "blob":
    //       return '';
    //       break;
    //     case "tinyblob":
    //       return '';
    //       break;
    //     case "mediumblob":
    //       return '';
    //       break;
    //     case "longblob":
    //       return '';
    //       break;
    //     case "enum":
    //       return '\'a\',\'b\'';
    //       break;
    //     case "set":
    //       return '\'a\',\'b\'';
    //       break;
    //     case "geometry":
    //       return '';
    //     case "point":
    //       return '';
    //     case "linestring":
    //       return '';
    //     case "polygon":
    //       return '';
    //     case "multipoint":
    //       return '';
    //     case "multilinestring":
    //       return '';
    //     case "multipolygon":
    //       return '';
    //     case "json":
    //       return ''
    //       break;
    //
    //   }
    //
    // }
    static getDefaultLengthForDatatype(type) {
        switch (type) {
            case 'int':
                return '';
            case 'tinyint':
                return '';
            case 'smallint':
                return '';
            case 'mediumint':
                return '';
            case 'bigint':
                return '';
            case 'bit':
                return '';
            case 'boolean':
                return '';
            case 'float':
                return '';
            case 'decimal':
                return '';
            case 'double':
                return '';
            case 'serial':
                return '';
            case 'date':
                return '';
            case 'datetime':
            case 'timestamp':
                return '';
            case 'time':
                return '';
            case 'year':
                return '';
            case 'char':
                return '';
            case 'varchar':
                return '';
            case 'nchar':
                return '';
            case 'text':
                return '';
            case 'tinytext':
                return '';
            case 'mediumtext':
                return '';
            case 'longtext':
                return '';
            case 'binary':
                return '';
            case 'varbinary':
                return '';
            case 'blob':
                return '';
            case 'tinyblob':
                return '';
            case 'mediumblob':
                return '';
            case 'longblob':
                return '';
            case 'enum':
                return '';
            case 'set':
                return '';
            case 'geometry':
                return '';
            case 'point':
                return '';
            case 'linestring':
                return '';
            case 'polygon':
                return '';
            case 'multipoint':
                return '';
            case 'multilinestring':
                return '';
            case 'multipolygon':
                return '';
            case 'json':
                return '';
        }
    }
    static getDefaultLengthIsDisabled(type) {
        switch (type) {
            case 'anyenum':
            case 'anynonarray':
            case 'anyrange':
            case 'bigint':
            case 'bigserial':
            case 'bit':
            case 'bool':
            case 'box':
            case 'bpchar':
            case 'bytea':
            case 'char':
            case 'character':
            case 'cid':
            case 'cidr':
            case 'circle':
            case 'cstring':
            case 'date':
            case 'daterange':
            case 'double precision':
            case 'event_trigger':
            case 'fdw_handler':
            case 'float4':
            case 'float8':
            case 'gtsvector':
            case 'index_am_handler':
            case 'inet':
            case 'int':
            case 'int2':
            case 'int4':
            case 'int8':
            case 'int4range':
            case 'int8range':
            case 'integer':
            case 'internal':
            case 'interval':
            case 'jsonb':
            case 'language_handler':
            case 'line':
            case 'lsec':
            case 'macaddr':
            case 'money':
            case 'name':
            case 'numeric':
            case 'numrange':
            case 'oid':
            case 'opaque':
            case 'path':
            case 'pg_ddl_command':
            case 'pg_lsn':
            case 'pg_node_tree':
            case 'real':
            case 'record':
            case 'refcursor':
            case 'regclass':
            case 'regconfig':
            case 'regdictionary':
            case 'regnamespace':
            case 'regoper':
            case 'regoperator':
            case 'regproc':
            case 'regpreocedure':
            case 'regrole':
            case 'regtype':
            case 'reltime':
            case 'serial':
            case 'serial2':
            case 'serial8':
            case 'smallint':
            case 'smallserial':
            case 'smgr':
            case 'text':
            case 'tid':
            case 'time':
            case 'time without time zone':
            case 'timestamp':
            case 'timestamp without time zone':
            case 'timestamptz':
            case 'timestamp with time zone':
            case 'timetz':
            case 'time with time zone':
            case 'tinterval':
            case 'trigger':
            case 'tsm_handler':
            case 'tsquery':
            case 'tsrange':
            case 'tstzrange':
            case 'tsvector':
            case 'txid_snapshot':
            case 'unknown':
            case 'void':
            case 'xid':
            case 'xml':
            case 'character varying':
            case 'tinyint':
            case 'mediumint':
            case 'float':
            case 'decimal':
            case 'double':
            case 'boolean':
            case 'datetime':
            case 'uuid':
            case 'year':
            case 'varchar':
            case 'nchar':
            case 'tinytext':
            case 'mediumtext':
            case 'longtext':
            case 'binary':
            case 'varbinary':
            case 'blob':
            case 'tinyblob':
            case 'mediumblob':
            case 'longblob':
            case 'enum':
            case 'set':
            case 'geometry':
            case 'point':
            case 'linestring':
            case 'polygon':
            case 'multipoint':
            case 'multilinestring':
            case 'multipolygon':
            case 'json':
                return true;
        }
    }
    static getDefaultValueForDatatype(type) {
        switch (type) {
            case 'anyenum':
                return 'eg: ';
            case 'anynonarray':
                return 'eg: ';
            case 'anyrange':
                return 'eg: ';
            case 'bigint':
                return 'eg: ';
            case 'bigserial':
                return 'eg: ';
            case 'bit':
                return 'eg: ';
            case 'bool':
                return 'eg: ';
            case 'box':
                return 'eg: ';
            case 'bpchar':
                return 'eg: ';
            case 'bytea':
                return 'eg: ';
            case 'char':
                return 'eg: ';
            case 'character':
                return "eg: 'sample'";
            case 'cid':
                return 'eg: ';
            case 'cidr':
                return 'eg: ';
            case 'circle':
                return 'eg: ';
            case 'cstring':
                return 'eg: ';
            case 'date':
                return "eg: '2020-09-09'";
            case 'daterange':
                return 'eg: ';
            case 'double precision':
                return 'eg: 1.2';
            case 'event_trigger':
                return 'eg: ';
            case 'fdw_handler':
                return 'eg: ';
            case 'float4':
                return 'eg: 1.2';
            case 'float8':
                return 'eg: 1.2';
            case 'gtsvector':
                return 'eg: ';
            case 'index_am_handler':
                return 'eg: ';
            case 'inet':
                return 'eg: ';
            case 'int':
                return 'eg: ';
            case 'int2':
                return 'eg: ';
            case 'int4':
                return 'eg: ';
            case 'int8':
                return 'eg: ';
            case 'int4range':
                return 'eg: ';
            case 'int8range':
                return 'eg: ';
            case 'integer':
                return 'eg: ';
            case 'internal':
                return 'eg: ';
            case 'interval':
                return 'eg: ';
            case 'json':
                return 'eg: ';
            case 'jsonb':
                return 'eg: ';
            case 'language_handler':
                return 'eg: ';
            case 'line':
                return 'eg: ';
            case 'lsec':
                return 'eg: ';
            case 'macaddr':
                return 'eg: ';
            case 'money':
                return 'eg: ';
            case 'name':
                return 'eg: ';
            case 'numeric':
                return 'eg: ';
            case 'numrange':
                return 'eg: ';
            case 'oid':
                return 'eg: ';
            case 'opaque':
                return 'eg: ';
            case 'path':
                return 'eg: ';
            case 'pg_ddl_command':
                return 'eg: ';
            case 'pg_lsn':
                return 'eg: ';
            case 'pg_node_tree':
                return 'eg: ';
            case 'point':
                return 'eg: ';
            case 'polygon':
                return 'eg: ';
            case 'real':
                return 'eg: 1.2';
            case 'record':
                return 'eg: ';
            case 'refcursor':
                return 'eg: ';
            case 'regclass':
                return 'eg: ';
            case 'regconfig':
                return 'eg: ';
            case 'regdictionary':
                return 'eg: ';
            case 'regnamespace':
                return 'eg: ';
            case 'regoper':
                return 'eg: ';
            case 'regoperator':
                return 'eg: ';
            case 'regproc':
                return 'eg: ';
            case 'regpreocedure':
                return 'eg: ';
            case 'regrole':
                return 'eg: ';
            case 'regtype':
                return 'eg: ';
            case 'reltime':
                return 'eg: ';
            case 'serial':
                return 'eg: ';
            case 'serial2':
                return 'eg: ';
            case 'serial8':
                return 'eg: ';
            case 'smallint':
                return 'eg: ';
            case 'smallserial':
                return 'eg: ';
            case 'smgr':
                return 'eg: ';
            case 'text':
                return "eg: 'sample text'";
            case 'tid':
                return 'eg: ';
            case 'time':
                return "eg: now()\n\n'04:05:06.789'";
            case 'time without time zone':
                return "eg: now()\n\n'04:05:06.789'";
            case 'timestamp':
                return "eg: now()\n\n'2016-06-22 19:10:25-07'";
            case 'timestamp without time zone':
                return "eg: now()\n\n'2016-06-22 19:10:25-07'";
            case 'timestamptz':
                return "eg: timezone('America/New_York','2016-06-01 00:00')\n\nnow()\n\n'2016-06-22 19:10:25-07'";
            case 'timestamp with time zone':
                return "eg: now()\n\n'2016-06-22 19:10:25-07'";
            case 'timetz':
                return 'eg: now()';
            case 'time with time zone':
                return 'eg: now()';
            case 'tinterval':
                return 'eg: ';
            case 'trigger':
                return 'eg: ';
            case 'tsm_handler':
                return 'eg: ';
            case 'tsquery':
                return 'eg: ';
            case 'tsrange':
                return 'eg: ';
            case 'tstzrange':
                return 'eg: ';
            case 'tsvector':
                return 'eg: ';
            case 'txid_snapshot':
                return 'eg: ';
            case 'unknown':
                return 'eg: ';
            case 'void':
                return 'eg: ';
            case 'xid':
                return 'eg: ';
            case 'xml':
                return 'eg: ';
            case 'character varying':
                return "eg: 'sample text'";
            case 'tinyint':
                return 'eg: ';
            case 'mediumint':
                return 'eg: ';
            case 'float':
                return 'eg: ';
            case 'decimal':
                return 'eg: ';
            case 'double':
                return 'eg: 1.2';
            case 'boolean':
                return 'eg: true\n\nfalse';
            case 'datetime':
                return 'eg: ';
            case 'uuid':
                return 'eg: ';
            case 'year':
                return 'eg: ';
            case 'varchar':
                return 'eg: ';
            case 'nchar':
                return 'eg: ';
            case 'tinytext':
                return 'eg: ';
            case 'mediumtext':
                return 'eg: ';
            case 'longtext':
                return 'eg: ';
            case 'binary':
                return 'eg: ';
            case 'varbinary':
                return 'eg: ';
            case 'blob':
                return 'eg: ';
            case 'tinyblob':
                return 'eg: ';
            case 'mediumblob':
                return 'eg: ';
            case 'longblob':
                return 'eg: ';
            case 'enum':
                return 'eg: ';
            case 'set':
                return 'eg: ';
            case 'geometry':
                return 'eg: ';
            case 'linestring':
                return 'eg: ';
            case 'multipoint':
                return 'eg: ';
            case 'multilinestring':
                return 'eg: ';
            case 'multipolygon':
                return 'eg: ';
        }
    }
    static getDefaultScaleForDatatype(type) {
        switch (type) {
            case 'int':
                return ' ';
            case 'tinyint':
                return ' ';
            case 'smallint':
                return ' ';
            case 'mediumint':
                return ' ';
            case 'bigint':
                return ' ';
            case 'bit':
                return ' ';
            case 'boolean':
                return ' ';
            case 'float':
                return '2';
            case 'decimal':
                return '2';
            case 'double':
                return '2';
            case 'serial':
                return ' ';
            case 'date':
            case 'datetime':
            case 'timestamp':
                return ' ';
            case 'time':
                return ' ';
            case 'year':
                return ' ';
            case 'char':
                return ' ';
            case 'varchar':
                return ' ';
            case 'nchar':
                return ' ';
            case 'text':
                return ' ';
            case 'tinytext':
                return ' ';
            case 'mediumtext':
                return ' ';
            case 'longtext':
                return ' ';
            case 'binary':
                return ' ';
            case 'varbinary':
                return ' ';
            case 'blob':
                return ' ';
            case 'tinyblob':
                return ' ';
            case 'mediumblob':
                return ' ';
            case 'longblob':
                return ' ';
            case 'enum':
                return ' ';
            case 'set':
                return ' ';
            case 'geometry':
                return ' ';
            case 'point':
                return ' ';
            case 'linestring':
                return ' ';
            case 'polygon':
                return ' ';
            case 'multipoint':
                return ' ';
            case 'multilinestring':
                return ' ';
            case 'multipolygon':
                return ' ';
            case 'json':
                return ' ';
        }
    }
    static colPropAIDisabled(col, columns) {
        // console.log(col);
        if (col.dt === 'int4' ||
            col.dt === 'integer' ||
            col.dt === 'bigint' ||
            col.dt === 'smallint') {
            for (let i = 0; i < columns.length; ++i) {
                if (columns[i].cn !== col.cn && columns[i].ai) {
                    return true;
                }
            }
            return false;
        }
        else {
            return true;
        }
    }
    static colPropUNDisabled(_col) {
        // console.log(col);
        return true;
        // if (col.dt === 'int' ||
        //   col.dt === 'tinyint' ||
        //   col.dt === 'smallint' ||
        //   col.dt === 'mediumint' ||
        //   col.dt === 'bigint') {
        //   return false;
        // } else {
        //   return true;
        // }
    }
    static onCheckboxChangeAI(col) {
        console.log(col);
        if (col.dt === 'int' ||
            col.dt === 'bigint' ||
            col.dt === 'smallint' ||
            col.dt === 'tinyint') {
            col.altered = col.altered || 2;
        }
        // if (!col.ai) {
        //   col.dtx = 'specificType'
        // } else {
        //   col.dtx = ''
        // }
    }
    static onCheckboxChangeAU(col) {
        console.log(col);
        // if (1) {
        col.altered = col.altered || 2;
        // }
        if (col.au) {
            col.cdf = 'now()';
        }
        // if (!col.ai) {
        //   col.dtx = 'specificType'
        // } else {
        //   col.dtx = ''
        // }
    }
    static showScale(_columnObj) {
        return false;
    }
    static removeUnsigned(columns) {
        for (let i = 0; i < columns.length; ++i) {
            if (columns[i].altered === 1 &&
                !(columns[i].dt === 'int' ||
                    columns[i].dt === 'bigint' ||
                    columns[i].dt === 'tinyint' ||
                    columns[i].dt === 'smallint' ||
                    columns[i].dt === 'mediumint')) {
                columns[i].un = false;
                console.log('>> resetting unsigned value', columns[i].cn);
            }
            console.log(columns[i].cn);
        }
    }
    static columnEditable(colObj) {
        return colObj.tn !== '_evolutions' || colObj.tn !== 'nc_evolutions';
    }
    /*
  
    static extractFunctionName(query) {
      const reg =
        /^\s*CREATE\s+(?:OR\s+REPLACE\s*)?\s*FUNCTION\s+(?:[\w\d_]+\.)?([\w_\d]+)/i;
      const match = query.match(reg);
      return match && match[1];
    }
  
    static extractProcedureName(query) {
      const reg =
        /^\s*CREATE\s+(?:OR\s+REPLACE\s*)?\s*PROCEDURE\s+(?:[\w\d_]+\.)?([\w_\d]+)/i;
      const match = query.match(reg);
      return match && match[1];
    }
  
    static handleRawOutput(result, headers) {
      if (['DELETE', 'INSERT', 'UPDATE'].includes(result.command.toUpperCase())) {
        headers.push({ text: 'Row count', value: 'rowCount', sortable: false });
        result = [
          {
            rowCount: result.rowCount,
          },
        ];
      } else {
        result = result.rows;
        if (Array.isArray(result) && result[0]) {
          const keys = Object.keys(result[0]);
          // set headers before settings result
          for (let i = 0; i < keys.length; i++) {
            const text = keys[i];
            headers.push({ text, value: text, sortable: false });
          }
        }
      }
      return result;
    }
  
    static splitQueries(query) {
      /!***
       * we are splitting based on semicolon
       * there are mechanism to escape semicolon within single/double quotes(string)
       *!/
      return query.match(/\b("[^"]*;[^"]*"|'[^']*;[^']*'|[^;])*;/g);
    }
  
    /!**
     * if sql statement is SELECT - it limits to a number
     * @param args
     * @returns {string|*}
     *!/
    sanitiseQuery(args) {
      let q = args.query.trim().split(';');
  
      if (q[0].startsWith('Select')) {
        q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
      } else if (q[0].startsWith('select')) {
        q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
      } else if (q[0].startsWith('SELECT')) {
        q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
      } else {
        return args.query;
      }
  
      return q;
    }
  
    static getColumnsFromJson(json, tn) {
      const columns = [];
  
      try {
        if (typeof json === 'object' && !Array.isArray(json)) {
          const keys = Object.keys(json);
          for (let i = 0; i < keys.length; ++i) {
            const column = {
              dp: null,
              tn,
              column_name: keys[i],
              cno: keys[i],
              np: 10,
              ns: 0,
              clen: null,
              cop: 1,
              pk: false,
              nrqd: false,
              rqd: false,
              un: false,
              ct: 'int(11) unsigned',
              ai: false,
              unique: false,
              cdf: null,
              cc: '',
              csn: null,
              dtx: 'specificType',
              dtxp: null,
              dtxs: 0,
              altered: 1,
            };
  
            switch (typeof json[keys[i]]) {
              case 'number':
                if (Number.isInteger(json[keys[i]])) {
                  if (PgUi.isValidTimestamp(keys[i], json[keys[i]])) {
                    Object.assign(column, {
                      dt: 'timestamp',
                    });
                  } else {
                    Object.assign(column, {
                      dt: 'int',
                      np: 10,
                      ns: 0,
                    });
                  }
                } else {
                  Object.assign(column, {
                    dt: 'float4',
                    np: null,
                    ns: null,
                    dtxp: null,
                    dtxs: null,
                  });
                }
                break;
              case 'string':
                if (PgUi.isValidDate(json[keys[i]])) {
                  Object.assign(column, {
                    dt: 'date',
                  });
                } else if (json[keys[i]].length <= 255) {
                  Object.assign(column, {
                    dt: 'character varying',
                    np: null,
                    ns: 0,
                    dtxp: null,
                  });
                } else {
                  Object.assign(column, {
                    dt: 'text',
                  });
                }
                break;
              case 'boolean':
                Object.assign(column, {
                  dt: 'boolean',
                  np: 3,
                  ns: 0,
                });
                break;
              case 'object':
                Object.assign(column, {
                  dt: 'json',
                  np: 3,
                  ns: 0,
                });
                break;
              default:
                break;
            }
            columns.push(column);
          }
        }
      } catch (e) {
        console.log('Error in getColumnsFromJson', e);
      }
  
      return columns;
    }
  
    static isValidTimestamp(key, value) {
      if (typeof value !== 'number') {
        return false;
      }
      return new Date(value).getTime() > 0 && /(?:_|(?=A))[aA]t$/.test(key);
    }
  
    static isValidDate(value) {
      return new Date(value).getTime() > 0;
    }
  */
    static colPropAuDisabled(col) {
        if (col.altered !== 1) {
            return true;
        }
        switch (col.dt) {
            case 'time':
            case 'time without time zone':
            case 'timestamp':
            case 'timestamp without time zone':
            case 'timestamptz':
            case 'timestamp with time zone':
            case 'timetz':
            case 'time with time zone':
                return false;
            default:
                return true;
        }
    }
    static getAbstractType(col) {
        var _a;
        switch ((_a = col.dt) === null || _a === void 0 ? void 0 : _a.toLowerCase()) {
            case 'anyenum':
                return 'enum';
            case 'anynonarray':
            case 'anyrange':
                return 'string';
            case 'bit':
                return 'integer';
            case 'bool':
                return 'boolean';
            case 'box':
            case 'bpchar':
            case 'bytea':
            case 'char':
            case 'character':
                return 'string';
            case 'cid':
            case 'cidr':
            case 'circle':
            case 'cstring':
                return 'string';
            case 'date':
                return 'date';
            case 'daterange':
                return 'string';
            case 'event_trigger':
            case 'fdw_handler':
                return 'string';
            case 'double precision':
            case 'float4':
            case 'float8':
                return 'float';
            case 'gtsvector':
            case 'index_am_handler':
            case 'inet':
                return 'string';
            case 'int':
            case 'int2':
            case 'int4':
            case 'int8':
            case 'integer':
            case 'bigint':
            case 'bigserial':
                return 'integer';
            case 'int4range':
            case 'int8range':
            case 'internal':
            case 'interval':
                return 'string';
            case 'language_handler':
            case 'line':
            case 'lsec':
            case 'macaddr':
            case 'money':
            case 'name':
            case 'numeric':
            case 'numrange':
            case 'oid':
            case 'opaque':
            case 'path':
            case 'pg_ddl_command':
            case 'pg_lsn':
            case 'pg_node_tree':
            case 'point':
            case 'polygon':
                return 'string';
            case 'real':
                return 'float';
            case 'record':
            case 'refcursor':
            case 'regclass':
            case 'regconfig':
            case 'regdictionary':
            case 'regnamespace':
            case 'regoper':
            case 'regoperator':
            case 'regproc':
            case 'regpreocedure':
            case 'regrole':
            case 'regtype':
            case 'reltime':
                return 'string';
            case 'serial':
            case 'serial2':
            case 'serial8':
            case 'smallint':
            case 'smallserial':
                return 'integer';
            case 'smgr':
                return 'string';
            case 'text':
                return 'text';
            case 'tid':
                return 'string';
            case 'time':
            case 'time without time zone':
                return 'time';
            case 'timestamp':
            case 'timestamp without time zone':
            case 'timestamptz':
            case 'timestamp with time zone':
                return 'datetime';
            case 'timetz':
            case 'time with time zone':
                return 'time';
            case 'tinterval':
            case 'trigger':
            case 'tsm_handler':
            case 'tsquery':
            case 'tsrange':
            case 'tstzrange':
            case 'tsvector':
            case 'txid_snapshot':
            case 'unknown':
            case 'void':
            case 'xid':
            case 'character varying':
            case 'xml':
                return 'string';
            case 'tinyint':
            case 'mediumint':
                return 'integer';
            case 'float':
            case 'decimal':
            case 'double':
                return 'float';
            case 'boolean':
                return 'boolean';
            case 'datetime':
                return 'datetime';
            case 'uuid':
            case 'year':
            case 'varchar':
            case 'nchar':
                return 'string';
            case 'tinytext':
            case 'mediumtext':
            case 'longtext':
                return 'text';
            case 'binary':
            case 'varbinary':
                return 'string';
            case 'blob':
            case 'tinyblob':
            case 'mediumblob':
            case 'longblob':
                return 'blob';
            case 'enum':
                return 'enum';
            case 'set':
                return 'set';
            case 'geometry':
            case 'linestring':
            case 'multipoint':
            case 'multilinestring':
            case 'multipolygon':
                return 'string';
            case 'json':
            case 'jsonb':
                return 'json';
        }
        return 'string';
    }
    static getUIType(col) {
        switch (this.getAbstractType(col)) {
            case 'integer':
                return 'Number';
            case 'boolean':
                return 'Checkbox';
            case 'float':
                return 'Decimal';
            case 'date':
                return 'Date';
            case 'datetime':
                return 'CreatedTime';
            case 'time':
                return 'Time';
            case 'year':
                return 'Year';
            case 'string':
                return 'SingleLineText';
            case 'text':
                return 'LongText';
            case 'blob':
                return 'Attachment';
            case 'enum':
                return 'SingleSelect';
            case 'set':
                return 'MultiSelect';
            case 'json':
                return 'LongText';
        }
    }
    static getDataTypeForUiType(col, idType) {
        const colProp = {};
        switch (col.uidt) {
            case 'ID':
                {
                    const isAutoIncId = idType === 'AI';
                    const isAutoGenId = idType === 'AG';
                    colProp.dt = isAutoGenId ? 'character varying' : 'int4';
                    colProp.pk = true;
                    colProp.un = isAutoIncId;
                    colProp.ai = isAutoIncId;
                    colProp.rqd = true;
                    colProp.meta = isAutoGenId ? { ag: 'nc' } : undefined;
                }
                break;
            case 'ForeignKey':
                colProp.dt = 'character varying';
                break;
            case 'SingleLineText':
                colProp.dt = 'text';
                break;
            case 'LongText':
                colProp.dt = 'text';
                break;
            case 'Attachment':
                colProp.dt = 'text';
                break;
            case 'GeoData':
                colProp.dt = 'text';
                break;
            case 'Checkbox':
                colProp.dt = 'bool';
                colProp.cdf = 'false';
                break;
            case 'MultiSelect':
                colProp.dt = 'text';
                break;
            case 'SingleSelect':
                colProp.dt = 'text';
                break;
            case 'Collaborator':
                colProp.dt = 'character varying';
                break;
            case 'Date':
                colProp.dt = 'date';
                break;
            case 'Year':
                colProp.dt = 'int';
                break;
            case 'Time':
                colProp.dt = 'time';
                break;
            case 'PhoneNumber':
                colProp.dt = 'character varying';
                colProp.validate = {
                    func: ['isMobilePhone'],
                    args: [''],
                    msg: ['Validation failed : isMobilePhone'],
                };
                break;
            case 'Email':
                colProp.dt = 'character varying';
                colProp.validate = {
                    func: ['isEmail'],
                    args: [''],
                    msg: ['Validation failed : isEmail'],
                };
                break;
            case 'URL':
                colProp.dt = 'text';
                colProp.validate = {
                    func: ['isURL'],
                    args: [''],
                    msg: ['Validation failed : isURL'],
                };
                break;
            case 'Number':
                colProp.dt = 'bigint';
                break;
            case 'Decimal':
                colProp.dt = 'decimal';
                break;
            case 'Currency':
                colProp.dt = 'decimal';
                colProp.validate = {
                    func: ['isCurrency'],
                    args: [''],
                    msg: ['Validation failed : isCurrency'],
                };
                break;
            case 'Percent':
                colProp.dt = 'double precision';
                break;
            case 'Duration':
                colProp.dt = 'decimal';
                break;
            case 'Rating':
                colProp.dt = 'smallint';
                colProp.cdf = '0';
                break;
            case 'Formula':
                colProp.dt = 'character varying';
                break;
            case 'Rollup':
                colProp.dt = 'character varying';
                break;
            case 'Count':
                colProp.dt = 'int8';
                break;
            case 'Lookup':
                colProp.dt = 'character varying';
                break;
            case 'DateTime':
                colProp.dt = 'timestamp';
                break;
            case 'CreatedTime':
                colProp.dt = 'timestamp';
                break;
            case 'LastModifiedTime':
                colProp.dt = 'timestamp';
                break;
            case 'AutoNumber':
                colProp.dt = 'int';
                break;
            case 'Barcode':
                colProp.dt = 'character varying';
                break;
            case 'Button':
                colProp.dt = 'character varying';
                break;
            case 'JSON':
                colProp.dt = 'json';
                break;
            case 'Meta':
                colProp.dt = 'jsonb';
                break;
            case 'Order':
                colProp.dt = 'numeric';
                break;
            default:
                colProp.dt = 'character varying';
                break;
        }
        return colProp;
    }
    static getDataTypeListForUiType(col, idType) {
        switch (col.uidt) {
            case 'ID':
                if (idType === 'AG') {
                    return ['char', 'character', 'character varying'];
                }
                else if (idType === 'AI') {
                    return [
                        'int',
                        'integer',
                        'bigint',
                        'bigserial',
                        'int2',
                        'int4',
                        'int8',
                        'serial',
                        'serial2',
                        'serial8',
                        'smallint',
                        'smallserial',
                    ];
                }
                else {
                    return dbTypes;
                }
            case 'ForeignKey':
                return dbTypes;
            case 'SingleLineText':
            case 'LongText':
            case 'Collaborator':
            case 'GeoData':
                return ['text', 'character varying', 'char', 'character'];
            case 'Attachment':
                return ['json', 'text', 'char', 'character', 'character varying'];
            case 'JSON':
                return ['json', 'jsonb', 'text'];
            case 'Checkbox':
                return [
                    'bit',
                    'bool',
                    'int2',
                    'int4',
                    'int8',
                    'boolean',
                    'smallint',
                    'int',
                    'integer',
                    'bigint',
                    'bigserial',
                    'char',
                    'int4range',
                    'int8range',
                    'serial',
                    'serial2',
                    'serial8',
                ];
            case 'MultiSelect':
                return ['text'];
            case 'SingleSelect':
                return ['text'];
            case 'Year':
                return ['int'];
            case 'Time':
                return [
                    'time',
                    'time without time zone',
                    'timestamp',
                    'timestamp without time zone',
                    'timestamptz',
                    'timestamp with time zone',
                    'timetz',
                    'time with time zone',
                ];
            case 'PhoneNumber':
            case 'Email':
                return ['character varying'];
            case 'URL':
                return ['text', 'character varying'];
            case 'Number':
                return [
                    'int',
                    'integer',
                    'bigint',
                    'bigserial',
                    'int2',
                    'int4',
                    'int8',
                    'serial',
                    'serial2',
                    'serial8',
                    'double precision',
                    'float4',
                    'float8',
                    'smallint',
                    'smallserial',
                    'numeric',
                ];
            case 'Decimal':
                return ['double precision', 'float4', 'float8', 'numeric'];
            case 'Currency':
                return [
                    'int',
                    'integer',
                    'bigint',
                    'bigserial',
                    'int2',
                    'int4',
                    'int8',
                    'serial',
                    'serial2',
                    'serial8',
                    'double precision',
                    'money',
                    'float4',
                    'float8',
                    'numeric',
                ];
            case 'Percent':
                return [
                    'int',
                    'integer',
                    'bigint',
                    'bigserial',
                    'int2',
                    'int4',
                    'int8',
                    'serial',
                    'serial2',
                    'serial8',
                    'double precision',
                    'float4',
                    'float8',
                    'smallint',
                    'smallserial',
                    'numeric',
                ];
            case 'Duration':
                return [
                    'int',
                    'integer',
                    'bigint',
                    'bigserial',
                    'int2',
                    'int4',
                    'int8',
                    'serial',
                    'serial2',
                    'serial8',
                    'double precision',
                    'float4',
                    'float8',
                    'smallint',
                    'smallserial',
                    'numeric',
                ];
            case 'Rating':
                return [
                    'int',
                    'integer',
                    'bigint',
                    'bigserial',
                    'int2',
                    'int4',
                    'int8',
                    'serial',
                    'serial2',
                    'serial8',
                    'double precision',
                    'float4',
                    'float8',
                    'smallint',
                    'smallserial',
                    'numeric',
                ];
            case 'Formula':
            case 'Button':
                return ['text', 'character varying'];
            case 'Rollup':
                return ['character varying'];
            case 'Count':
                return [
                    'int',
                    'integer',
                    'bigint',
                    'bigserial',
                    'int2',
                    'int4',
                    'int8',
                    'serial',
                    'serial2',
                    'serial8',
                    'smallint',
                    'smallserial',
                ];
            case 'Lookup':
                return ['character varying'];
            case 'Date':
                return [
                    'date',
                    'timestamp',
                    'timestamp without time zone',
                    'timestamptz',
                    'timestamp with time zone',
                ];
            case 'DateTime':
            case 'CreatedTime':
            case 'LastModifiedTime':
                return [
                    'timestamp',
                    'timestamp without time zone',
                    'timestamptz',
                    'timestamp with time zone',
                ];
            case 'User':
            case 'CreatedBy':
            case 'LastModifiedBy':
                return ['character varying'];
            case 'AutoNumber':
                return [
                    'int',
                    'integer',
                    'bigint',
                    'bigserial',
                    'int2',
                    'int4',
                    'int8',
                    'serial',
                    'serial2',
                    'serial8',
                    'smallint',
                    'smallserial',
                ];
            case 'Order':
                return ['numeric'];
            case 'Barcode':
                return ['character varying'];
            case 'Geometry':
                return [
                    'polygon',
                    'point',
                    'circle',
                    'box',
                    'line',
                    'lseg',
                    'path',
                    'circle',
                ];
            default:
                return dbTypes;
        }
    }
    static getUnsupportedFnList() {
        return [];
    }
    static getCurrentDateDefault(col) {
        if (col.uidt === UITypes.DateTime || col.uidt === UITypes.Date) {
            return 'NOW()';
        }
        return null;
    }
    static isEqual(dataType1, dataType2) {
        if ((dataType1 === null || dataType1 === void 0 ? void 0 : dataType1.toLowerCase()) === (dataType2 === null || dataType2 === void 0 ? void 0 : dataType2.toLowerCase()))
            return true;
        const abstractType1 = this.getAbstractType({ dt: dataType1 });
        const abstractType2 = this.getAbstractType({ dt: dataType2 });
        if (abstractType1 &&
            abstractType1 === abstractType2 &&
            ['integer', 'float'].includes(abstractType1))
            return true;
        return false;
    }
    //#endregion statics
    //#region methods
    getNewTableColumns() {
        return PgUi.getNewTableColumns();
    }
    getNewColumn(suffix) {
        return PgUi.getNewColumn(suffix);
    }
    getDefaultLengthForDatatype(type) {
        return PgUi.getDefaultLengthForDatatype(type);
    }
    getDefaultLengthIsDisabled(type) {
        return PgUi.getDefaultLengthIsDisabled(type);
    }
    getDefaultValueForDatatype(type) {
        return PgUi.getDefaultValueForDatatype(type);
    }
    getDefaultScaleForDatatype(type) {
        return PgUi.getDefaultScaleForDatatype(type);
    }
    colPropAIDisabled(col, columns) {
        return PgUi.colPropAIDisabled(col, columns);
    }
    colPropUNDisabled(col) {
        return PgUi.colPropUNDisabled(col);
    }
    onCheckboxChangeAI(col) {
        return PgUi.onCheckboxChangeAI(col);
    }
    showScale(columnObj) {
        return PgUi.showScale(columnObj);
    }
    removeUnsigned(columns) {
        return PgUi.removeUnsigned(columns);
    }
    columnEditable(colObj) {
        return PgUi.columnEditable(colObj);
    }
    onCheckboxChangeAU(col) {
        return PgUi.onCheckboxChangeAU(col);
    }
    colPropAuDisabled(col) {
        return PgUi.colPropAuDisabled(col);
    }
    getAbstractType(col) {
        return PgUi.getAbstractType(col);
    }
    getUIType(col) {
        return PgUi.getUIType(col);
    }
    getDataTypeForUiType(col, idType) {
        return PgUi.getDataTypeForUiType(col, idType);
    }
    getDataTypeListForUiType(col, idType) {
        return PgUi.getDataTypeListForUiType(col, idType);
    }
    getUnsupportedFnList() {
        return PgUi.getUnsupportedFnList();
    }
    getCurrentDateDefault(_col) {
        return PgUi.getCurrentDateDefault(_col);
    }
    isEqual(dataType1, dataType2) {
        return PgUi.isEqual(dataType1, dataType2);
    }
    adjustLengthAndScale(_newColumn, _oldColumn) { }
    isParsedJsonReturnType(col) {
        var _a;
        return ['json', 'jsond'].includes((_a = col.dt) === null || _a === void 0 ? void 0 : _a.toLowerCase());
    }
    get tableNameLengthLimit() {
        return 63;
    }
}
// module.exports = PgUiHelp;
//# sourceMappingURL=data:application/json;base64,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