import UITypes from '../UITypes';
const dbTypes = [
    'NUMBER',
    'DECIMAL',
    'NUMERIC',
    'INT',
    'INTEGER',
    'BIGINT',
    'SMALLINT',
    'TINYINT',
    'BYTEINT',
    'FLOAT',
    'FLOAT4',
    'FLOAT8',
    'DOUBLE',
    'DOUBLE PRECISION',
    'REAL',
    'VARCHAR',
    'CHAR',
    'CHARACTER',
    'STRING',
    'TEXT',
    'BINARY',
    'VARBINARY',
    'BOOLEAN',
    'DATE',
    'DATETIME',
    'TIME',
    'TIMESTAMP',
    'TIMESTAMP_LTZ',
    'TIMESTAMP_NTZ',
    'TIMESTAMP_TZ',
    'VARIANT',
    'OBJECT',
    'ARRAY',
    'GEOGRAPHY',
];
export class SnowflakeUi {
    //#region statics
    static getNewTableColumns() {
        return [
            {
                column_name: 'id',
                title: 'Id',
                dt: 'int',
                dtx: 'integer',
                ct: 'int(11)',
                nrqd: false,
                rqd: true,
                ck: false,
                pk: true,
                un: false,
                ai: true,
                cdf: null,
                clen: null,
                np: 11,
                ns: 0,
                dtxp: '11',
                dtxs: '',
                altered: 1,
                uidt: 'ID',
                uip: '',
                uicn: '',
            },
            {
                column_name: 'title',
                title: 'Title',
                dt: 'TEXT',
                dtx: 'specificType',
                ct: null,
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                cdf: null,
                clen: null,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: 'SingleLineText',
                uip: '',
                uicn: '',
            },
            {
                column_name: 'created_at',
                title: 'CreatedAt',
                dt: 'timestamp',
                dtx: 'specificType',
                ct: 'timestamp',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: UITypes.CreatedTime,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'updated_at',
                title: 'UpdatedAt',
                dt: 'timestamp',
                dtx: 'specificType',
                ct: 'timestamp',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: UITypes.LastModifiedTime,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'created_by',
                title: 'nc_created_by',
                dt: 'varchar',
                dtx: 'specificType',
                ct: 'varchar(45)',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '45',
                dtxs: '',
                altered: 1,
                uidt: UITypes.CreatedBy,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'updated_by',
                title: 'nc_updated_by',
                dt: 'varchar',
                dtx: 'specificType',
                ct: 'varchar(45)',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '45',
                dtxs: '',
                altered: 1,
                uidt: UITypes.LastModifiedBy,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'nc_order',
                title: 'nc_order',
                dt: 'number',
                dtx: 'specificType',
                ct: 'number(38,18)',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                cdf: null,
                clen: null,
                np: 38,
                ns: 18,
                dtxp: '38,18',
                dtxs: '',
                altered: 1,
                uidt: UITypes.Order,
                uip: '',
                uicn: '',
                system: true,
            },
        ];
    }
    static getNewColumn(suffix) {
        return {
            column_name: 'title' + suffix,
            dt: 'TEXT',
            dtx: 'specificType',
            ct: null,
            nrqd: true,
            rqd: false,
            ck: false,
            pk: false,
            un: false,
            ai: false,
            cdf: null,
            clen: null,
            np: null,
            ns: null,
            dtxp: '',
            dtxs: '',
            altered: 1,
            uidt: 'SingleLineText',
            uip: '',
            uicn: '',
        };
    }
    static getDefaultLengthForDatatype(type) {
        switch (type) {
            case 'VARCHAR':
            case 'CHAR':
            case 'CHARACTER':
            case 'STRING':
                return 255;
            case 'NUMBER':
            case 'DECIMAL':
            case 'NUMERIC':
            case 'INT':
            case 'INTEGER':
            case 'BIGINT':
            case 'SMALLINT':
            case 'TINYINT':
            case 'BYTEINT':
            case 'FLOAT':
            case 'FLOAT4':
            case 'FLOAT8':
            case 'DOUBLE':
            case 'DOUBLE PRECISION':
            case 'REAL':
                return 38;
        }
    }
    static getDefaultLengthIsDisabled(type) {
        switch (type) {
            case 'VARCHAR':
            case 'CHAR':
            case 'CHARACTER':
            case 'STRING':
            case 'NUMBER':
            case 'DECIMAL':
            case 'NUMERIC':
            case 'INT':
            case 'INTEGER':
            case 'BIGINT':
            case 'SMALLINT':
            case 'TINYINT':
            case 'BYTEINT':
            case 'FLOAT':
            case 'FLOAT4':
            case 'FLOAT8':
            case 'DOUBLE':
            case 'DOUBLE PRECISION':
            case 'REAL':
                return false;
            case 'TEXT':
            case 'BINARY':
            case 'VARBINARY':
            case 'BOOLEAN':
            case 'DATE':
            case 'DATETIME':
            case 'TIME':
            case 'TIMESTAMP':
            case 'TIMESTAMP_LTZ':
            case 'TIMESTAMP_NTZ':
            case 'TIMESTAMP_TZ':
            case 'VARIANT':
            case 'OBJECT':
            case 'ARRAY':
            case 'GEOGRAPHY':
                return true;
        }
    }
    static getDefaultValueForDatatype(type) {
        switch (type) {
            default:
                return 'eg: ';
        }
    }
    static getDefaultScaleForDatatype(type) {
        switch (type) {
            case 'NUMBER':
            case 'DECIMAL':
            case 'NUMERIC':
            case 'INT':
            case 'INTEGER':
            case 'BIGINT':
            case 'SMALLINT':
            case 'TINYINT':
            case 'BYTEINT':
            case 'FLOAT':
            case 'FLOAT4':
            case 'FLOAT8':
            case 'DOUBLE':
            case 'DOUBLE PRECISION':
            case 'REAL':
            case 'VARCHAR':
            case 'CHAR':
            case 'CHARACTER':
            case 'STRING':
            case 'TEXT':
            case 'BINARY':
            case 'VARBINARY':
            case 'BOOLEAN':
            case 'DATE':
            case 'DATETIME':
            case 'TIME':
            case 'TIMESTAMP':
            case 'TIMESTAMP_LTZ':
            case 'TIMESTAMP_NTZ':
            case 'TIMESTAMP_TZ':
            case 'VARIANT':
            case 'OBJECT':
            case 'ARRAY':
            case 'GEOGRAPHY':
                return ' ';
        }
    }
    static colPropAIDisabled(col, columns) {
        // console.log(col);
        if (col.dt === 'NUMBER' ||
            col.dt === 'DECIMAL' ||
            col.dt === 'NUMERIC' ||
            col.dt === 'INT' ||
            col.dt === 'INTEGER' ||
            col.dt === 'BIGINT' ||
            col.dt === 'SMALLINT') {
            for (let i = 0; i < columns.length; ++i) {
                if (columns[i].cn !== col.cn && columns[i].ai) {
                    return true;
                }
            }
            return false;
        }
        else {
            return true;
        }
    }
    static colPropUNDisabled(_col) {
        // console.log(col);
        return true;
        // if (col.dt === 'int' ||
        //   col.dt === 'tinyint' ||
        //   col.dt === 'smallint' ||
        //   col.dt === 'mediumint' ||
        //   col.dt === 'bigint') {
        //   return false;
        // } else {
        //   return true;
        // }
    }
    static onCheckboxChangeAI(col) {
        console.log(col);
        if (col.dt === 'NUMBER' ||
            col.dt === 'DECIMAL' ||
            col.dt === 'NUMERIC' ||
            col.dt === 'INT' ||
            col.dt === 'INTEGER' ||
            col.dt === 'BIGINT' ||
            col.dt === 'SMALLINT') {
            col.altered = col.altered || 2;
        }
        // if (!col.ai) {
        //   col.dtx = 'specificType'
        // } else {
        //   col.dtx = ''
        // }
    }
    static onCheckboxChangeAU(col) {
        console.log(col);
        // if (1) {
        col.altered = col.altered || 2;
        // }
        if (col.au) {
            col.cdf = 'current_timestamp()';
        }
        // if (!col.ai) {
        //   col.dtx = 'specificType'
        // } else {
        //   col.dtx = ''
        // }
    }
    static showScale(_columnObj) {
        return false;
    }
    static removeUnsigned(columns) {
        for (let i = 0; i < columns.length; ++i) {
            if (columns[i].altered === 1 &&
                !(columns[i].dt === 'INT' ||
                    columns[i].dt === 'BIGINT' ||
                    columns[i].dt === 'SMALLINT' ||
                    columns[i].dt === 'TINYINT')) {
                columns[i].un = false;
                console.log('>> resetting unsigned value', columns[i].cn);
            }
            console.log(columns[i].cn);
        }
    }
    static columnEditable(colObj) {
        return colObj.tn !== '_evolutions' || colObj.tn !== 'nc_evolutions';
    }
    /*
  
    static extractFunctionName(query) {
      const reg =
        /^\s*CREATE\s+(?:OR\s+REPLACE\s*)?\s*FUNCTION\s+(?:[\w\d_]+\.)?([\w_\d]+)/i;
      const match = query.match(reg);
      return match && match[1];
    }
  
    static extractProcedureName(query) {
      const reg =
        /^\s*CREATE\s+(?:OR\s+REPLACE\s*)?\s*PROCEDURE\s+(?:[\w\d_]+\.)?([\w_\d]+)/i;
      const match = query.match(reg);
      return match && match[1];
    }
  
    static handleRawOutput(result, headers) {
      if (['DELETE', 'INSERT', 'UPDATE'].includes(result.command.toUpperCase())) {
        headers.push({ text: 'Row count', value: 'rowCount', sortable: false });
        result = [
          {
            rowCount: result.rowCount,
          },
        ];
      } else {
        result = result.rows;
        if (Array.isArray(result) && result[0]) {
          const keys = Object.keys(result[0]);
          // set headers before settings result
          for (let i = 0; i < keys.length; i++) {
            const text = keys[i];
            headers.push({ text, value: text, sortable: false });
          }
        }
      }
      return result;
    }
  
    static splitQueries(query) {
      /!***
       * we are splitting based on semicolon
       * there are mechanism to escape semicolon within single/double quotes(string)
       *!/
      return query.match(/\b("[^"]*;[^"]*"|'[^']*;[^']*'|[^;])*;/g);
    }
  
    /!**
     * if sql statement is SELECT - it limits to a number
     * @param args
     * @returns {string|*}
     *!/
    sanitiseQuery(args) {
      let q = args.query.trim().split(';');
  
      if (q[0].startsWith('Select')) {
        q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
      } else if (q[0].startsWith('select')) {
        q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
      } else if (q[0].startsWith('SELECT')) {
        q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
      } else {
        return args.query;
      }
  
      return q;
    }
  
    static getColumnsFromJson(json, tn) {
      const columns = [];
  
      try {
        if (typeof json === 'object' && !Array.isArray(json)) {
          const keys = Object.keys(json);
          for (let i = 0; i < keys.length; ++i) {
            const column = {
              dp: null,
              tn,
              column_name: keys[i],
              cno: keys[i],
              np: 10,
              ns: 0,
              clen: null,
              cop: 1,
              pk: false,
              nrqd: false,
              rqd: false,
              un: false,
              ct: 'int(11) unsigned',
              ai: false,
              unique: false,
              cdf: null,
              cc: '',
              csn: null,
              dtx: 'specificType',
              dtxp: null,
              dtxs: 0,
              altered: 1,
            };
  
            switch (typeof json[keys[i]]) {
              case 'number':
                if (Number.isInteger(json[keys[i]])) {
                  if (SnowflakeUi.isValidTimestamp(keys[i], json[keys[i]])) {
                    Object.assign(column, {
                      dt: 'timestamp',
                    });
                  } else {
                    Object.assign(column, {
                      dt: 'int',
                      np: 10,
                      ns: 0,
                    });
                  }
                } else {
                  Object.assign(column, {
                    dt: 'float4',
                    np: null,
                    ns: null,
                    dtxp: null,
                    dtxs: null,
                  });
                }
                break;
              case 'string':
                if (SnowflakeUi.isValidDate(json[keys[i]])) {
                  Object.assign(column, {
                    dt: 'date',
                  });
                } else if (json[keys[i]].length <= 255) {
                  Object.assign(column, {
                    dt: 'VARCHAR',
                    np: null,
                    ns: 0,
                    dtxp: null,
                  });
                } else {
                  Object.assign(column, {
                    dt: 'text',
                  });
                }
                break;
              case 'boolean':
                Object.assign(column, {
                  dt: 'boolean',
                  np: 3,
                  ns: 0,
                });
                break;
              case 'object':
                Object.assign(column, {
                  dt: 'json',
                  np: 3,
                  ns: 0,
                });
                break;
              default:
                break;
            }
            columns.push(column);
          }
        }
      } catch (e) {
        console.log('Error in getColumnsFromJson', e);
      }
  
      return columns;
    }
  
    static isValidTimestamp(key, value) {
      if (typeof value !== 'number') {
        return false;
      }
      return new Date(value).getTime() > 0 && /(?:_|(?=A))[aA]t$/.test(key);
    }
  
    static isValidDate(value) {
      return new Date(value).getTime() > 0;
    }
  */
    static colPropAuDisabled(col) {
        if (col.altered !== 1) {
            return true;
        }
        switch (col.dt.toUpperCase()) {
            case 'DATE':
            case 'DATETIME':
            case 'TIME':
            case 'TIMESTAMP':
            case 'TIMESTAMP_LTZ':
            case 'TIMESTAMP_NTZ':
            case 'TIMESTAMP_TZ':
                return false;
            default:
                return true;
        }
    }
    static getAbstractType(col) {
        var _a;
        switch ((_a = col.dt) === null || _a === void 0 ? void 0 : _a.toUpperCase()) {
            case 'NUMBER':
            case 'DECIMAL':
            case 'NUMERIC':
            case 'INT':
            case 'INTEGER':
            case 'BIGINT':
            case 'SMALLINT':
            case 'TINYINT':
            case 'BYTEINT':
                return 'integer';
            case 'FLOAT':
            case 'FLOAT4':
            case 'FLOAT8':
            case 'DOUBLE':
            case 'DOUBLE PRECISION':
            case 'REAL':
                return 'float';
            case 'VARCHAR':
            case 'CHAR':
            case 'CHARACTER':
            case 'STRING':
                return 'string';
            case 'TEXT':
                if (col.dtxp < 1024)
                    return 'string';
                return 'text';
            case 'BINARY':
            case 'VARBINARY':
                return 'string';
            case 'BOOLEAN':
                return 'boolean';
            case 'DATE':
                return 'date';
            case 'DATETIME':
            case 'TIME':
            case 'TIMESTAMP':
            case 'TIMESTAMP_LTZ':
            case 'TIMESTAMP_NTZ':
            case 'TIMESTAMP_TZ':
                return 'string';
            case 'VARIANT':
                return 'string';
            case 'OBJECT':
                return 'json';
            case 'ARRAY':
                return 'enum';
            case 'GEOGRAPHY':
                return 'string';
            default:
                return 'string';
        }
    }
    static getUIType(col) {
        switch (this.getAbstractType(col)) {
            case 'NUMBER':
            case 'DECIMAL':
            case 'NUMERIC':
            case 'INT':
            case 'INTEGER':
            case 'BIGINT':
            case 'SMALLINT':
            case 'TINYINT':
            case 'BYTEINT':
                return 'Number';
            case 'FLOAT':
            case 'FLOAT4':
            case 'FLOAT8':
            case 'DOUBLE':
            case 'DOUBLE PRECISION':
            case 'REAL':
                return 'Decimal';
            case 'VARCHAR':
            case 'CHAR':
            case 'CHARACTER':
            case 'STRING':
                return 'SingleLineText';
            case 'TEXT':
                return 'LongText';
            case 'BOOLEAN':
                return 'Checkbox';
            case 'DATE':
                return 'Date';
            case 'DATETIME':
                return 'DateTime';
        }
    }
    static getDataTypeForUiType(col, idType) {
        const colProp = {};
        switch (col.uidt) {
            case 'ID':
                {
                    const isAutoIncId = idType === 'AI';
                    const isAutoGenId = idType === 'AG';
                    colProp.dt = isAutoGenId ? 'VARCHAR' : 'int4';
                    colProp.pk = true;
                    colProp.un = isAutoIncId;
                    colProp.ai = isAutoIncId;
                    colProp.rqd = true;
                    colProp.meta = isAutoGenId ? { ag: 'nc' } : undefined;
                }
                break;
            case 'ForeignKey':
                colProp.dt = 'VARCHAR';
                break;
            case 'SingleLineText':
                colProp.dt = 'TEXT';
                break;
            case 'LongText':
                colProp.dt = 'TEXT';
                break;
            case 'Attachment':
                colProp.dt = 'TEXT';
                break;
            case 'GeoData':
                colProp.dt = 'TEXT';
                break;
            case 'Checkbox':
                colProp.dt = 'BOOLEAN';
                colProp.cdf = '0';
                break;
            case 'MultiSelect':
                colProp.dt = 'TEXT';
                break;
            case 'SingleSelect':
                colProp.dt = 'TEXT';
                break;
            case 'Collaborator':
                colProp.dt = 'VARCHAR';
                break;
            case 'Date':
                colProp.dt = 'DATE';
                break;
            case 'Year':
                colProp.dt = 'INT';
                break;
            case 'Time':
                colProp.dt = 'VARCHAR';
                break;
            case 'PhoneNumber':
                colProp.dt = 'VARCHAR';
                colProp.validate = {
                    func: ['isMobilePhone'],
                    args: [''],
                    msg: ['Validation failed : isMobilePhone'],
                };
                break;
            case 'Email':
                colProp.dt = 'VARCHAR';
                colProp.validate = {
                    func: ['isEmail'],
                    args: [''],
                    msg: ['Validation failed : isEmail'],
                };
                break;
            case 'URL':
                colProp.dt = 'TEXT';
                colProp.validate = {
                    func: ['isURL'],
                    args: [''],
                    msg: ['Validation failed : isURL'],
                };
                break;
            case 'Number':
                colProp.dt = 'BIGINT';
                break;
            case 'Decimal':
                colProp.dt = 'DECIMAL';
                break;
            case 'Currency':
                colProp.dt = 'DECIMAL';
                colProp.validate = {
                    func: ['isCurrency'],
                    args: [''],
                    msg: ['Validation failed : isCurrency'],
                };
                break;
            case 'Percent':
                colProp.dt = 'DOUBLE PRECISION';
                break;
            case 'Duration':
                colProp.dt = 'DECIMAL';
                break;
            case 'Rating':
                colProp.dt = 'SMALLINT';
                colProp.cdf = '0';
                break;
            case 'Formula':
                colProp.dt = 'VARCHAR';
                break;
            case 'Rollup':
                colProp.dt = 'VARCHAR';
                break;
            case 'Count':
                colProp.dt = 'INT';
                break;
            case 'Lookup':
                colProp.dt = 'VARCHAR';
                break;
            case 'DateTime':
                colProp.dt = 'TIMESTAMP';
                break;
            case 'CreatedTime':
                colProp.dt = 'TIMESTAMP';
                break;
            case 'LastModifiedTime':
                colProp.dt = 'TIMESTAMP';
                break;
            case 'AutoNumber':
                colProp.dt = 'INT';
                break;
            case 'Barcode':
                colProp.dt = 'VARCHAR';
                break;
            case 'Button':
                colProp.dt = 'VARCHAR';
                break;
            case 'JSON':
                colProp.dt = 'TEXT';
                break;
            default:
                colProp.dt = 'VARCHAR';
                break;
        }
        return colProp;
    }
    static getDataTypeListForUiType(col, idType) {
        switch (col.uidt) {
            case 'ID':
                if (idType === 'AG') {
                    return ['VARCHAR'];
                }
                else if (idType === 'AI') {
                    return ['NUMBER'];
                }
                else {
                    return dbTypes;
                }
            case 'ForeignKey':
                return dbTypes;
            case 'SingleLineText':
            case 'LongText':
            case 'Collaborator':
            case 'GeoData':
                return ['TEXT', 'VARCHAR', 'CHARACTER', 'CHAR'];
            case 'Attachment':
                return ['TEXT', 'CHAR', 'CHARACTER', 'VARCHAR'];
            case 'JSON':
                return ['TEXT'];
            case 'Checkbox':
                return ['BIT', 'BOOLEAN', 'TINYINT', 'INT', 'BIGINT'];
            case 'MultiSelect':
                return ['TEXT'];
            case 'SingleSelect':
                return ['TEXT'];
            case 'Year':
                return ['INT'];
            case 'Time':
                return ['TIMESTAMP', 'VARCHAR'];
            case 'PhoneNumber':
            case 'Email':
                return ['VARCHAR'];
            case 'URL':
                return ['TEXT', 'VARCHAR'];
            case 'Number':
                return [
                    'NUMBER',
                    'DECIMAL',
                    'NUMERIC',
                    'INT',
                    'INTEGER',
                    'BIGINT',
                    'SMALLINT',
                    'TINYINT',
                    'BYTEINT',
                    'FLOAT',
                    'FLOAT4',
                    'FLOAT8',
                    'DOUBLE',
                    'DOUBLE PRECISION',
                    'REAL',
                ];
            case 'Decimal':
                return [
                    'DOUBLE',
                    'DOUBLE PRECISION',
                    'FLOAT',
                    'FLOAT4',
                    'FLOAT8',
                    'NUMERIC',
                ];
            case 'Currency':
                return [
                    'NUMBER',
                    'DECIMAL',
                    'NUMERIC',
                    'INT',
                    'INTEGER',
                    'BIGINT',
                    'FLOAT',
                    'FLOAT4',
                    'FLOAT8',
                    'DOUBLE',
                    'DOUBLE PRECISION',
                ];
            case 'Percent':
                return [
                    'NUMBER',
                    'DECIMAL',
                    'NUMERIC',
                    'INT',
                    'INTEGER',
                    'BIGINT',
                    'FLOAT',
                    'FLOAT4',
                    'FLOAT8',
                    'DOUBLE',
                    'DOUBLE PRECISION',
                ];
            case 'Duration':
                return [
                    'NUMBER',
                    'DECIMAL',
                    'NUMERIC',
                    'INT',
                    'INTEGER',
                    'BIGINT',
                    'FLOAT',
                    'FLOAT4',
                    'FLOAT8',
                    'DOUBLE',
                    'DOUBLE PRECISION',
                ];
            case 'Rating':
                return [
                    'NUMBER',
                    'DECIMAL',
                    'NUMERIC',
                    'INT',
                    'INTEGER',
                    'BIGINT',
                    'FLOAT',
                    'FLOAT4',
                    'FLOAT8',
                    'DOUBLE',
                    'DOUBLE PRECISION',
                ];
            case 'Formula':
            case 'Button':
                return ['TEXT', 'VARCHAR'];
            case 'Rollup':
                return ['VARCHAR'];
            case 'Count':
                return ['NUMBER', 'INT', 'INTEGER', 'BIGINT'];
            case 'Lookup':
                return ['VARCHAR'];
            case 'Date':
                return ['DATE', 'TIMESTAMP'];
            case 'DateTime':
            case 'CreatedTime':
            case 'LastModifiedTime':
                return ['TIMESTAMP'];
            case 'User':
            case 'CreatedBy':
            case 'LastModifiedBy':
                return ['VARCHAR'];
            case 'AutoNumber':
                return ['NUMBER', 'INT', 'INTEGER', 'BIGINT'];
            case 'Barcode':
                return ['VARCHAR'];
            case 'Geometry':
                return ['TEXT'];
            default:
                return dbTypes;
        }
    }
    static getUnsupportedFnList() {
        return [
            'XOR',
            'REGEX_MATCH',
            'REGEX_EXTRACT',
            'REGEX_REPLACE',
            'VALUE',
            'COUNTA',
            'COUNT',
            'DATESTR',
            'ARRAYSORT',
            'ARRAYUNIQUE',
            'ARRAYSLICE',
            'ARRAYCOMPACT',
        ];
    }
    static getCurrentDateDefault(_col) {
        return null;
    }
    static isEqual(dataType1, dataType2) {
        if (dataType1 === dataType2)
            return true;
        const abstractType1 = this.getAbstractType({ dt: dataType1 });
        const abstractType2 = this.getAbstractType({ dt: dataType2 });
        if (abstractType1 &&
            abstractType1 === abstractType2 &&
            ['integer', 'float'].includes(abstractType1))
            return true;
        return false;
    }
    //#endregion statics
    //#region methods
    getNewTableColumns() {
        return SnowflakeUi.getNewTableColumns();
    }
    getNewColumn(suffix) {
        return SnowflakeUi.getNewColumn(suffix);
    }
    getDefaultLengthForDatatype(type) {
        return SnowflakeUi.getDefaultLengthForDatatype(type);
    }
    getDefaultLengthIsDisabled(type) {
        return SnowflakeUi.getDefaultLengthIsDisabled(type);
    }
    getDefaultValueForDatatype(type) {
        return SnowflakeUi.getDefaultValueForDatatype(type);
    }
    getDefaultScaleForDatatype(type) {
        return SnowflakeUi.getDefaultScaleForDatatype(type);
    }
    colPropAIDisabled(col, columns) {
        return SnowflakeUi.colPropAIDisabled(col, columns);
    }
    colPropUNDisabled(col) {
        return SnowflakeUi.colPropUNDisabled(col);
    }
    onCheckboxChangeAI(col) {
        return SnowflakeUi.onCheckboxChangeAI(col);
    }
    showScale(columnObj) {
        return SnowflakeUi.showScale(columnObj);
    }
    removeUnsigned(columns) {
        return SnowflakeUi.removeUnsigned(columns);
    }
    columnEditable(colObj) {
        return SnowflakeUi.columnEditable(colObj);
    }
    onCheckboxChangeAU(col) {
        return SnowflakeUi.onCheckboxChangeAU(col);
    }
    colPropAuDisabled(col) {
        return SnowflakeUi.colPropAuDisabled(col);
    }
    getAbstractType(col) {
        return SnowflakeUi.getAbstractType(col);
    }
    getUIType(col) {
        return SnowflakeUi.getUIType(col);
    }
    getDataTypeForUiType(col, idType) {
        return SnowflakeUi.getDataTypeForUiType(col, idType);
    }
    getDataTypeListForUiType(col, idType) {
        return SnowflakeUi.getDataTypeListForUiType(col, idType);
    }
    getUnsupportedFnList() {
        return SnowflakeUi.getUnsupportedFnList();
    }
    getCurrentDateDefault(_col) {
        return SnowflakeUi.getCurrentDateDefault(_col);
    }
    isEqual(dataType1, dataType2) {
        return SnowflakeUi.isEqual(dataType1, dataType2);
    }
    adjustLengthAndScale(_newColumn, _oldColumn) { }
    isParsedJsonReturnType(_col) {
        return false;
    }
    get tableNameLengthLimit() {
        return 255;
    }
}
// module.exports = SnowflakeUiHelp;
/**
 * @copyright Copyright (c) 2021, Xgene Cloud Ltd
 *
 * @author Naveen MR <oof1lab@gmail.com>
 * @author Pranav C Balan <pranavxc@gmail.com>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */
//# sourceMappingURL=data:application/json;base64,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