import { MysqlUi } from './MysqlUi';
import { OracleUi } from './OracleUi';
import { PgUi } from './PgUi';
import { SqliteUi } from './SqliteUi';
import { SnowflakeUi } from './SnowflakeUi';
import { DatabricksUi } from './DatabricksUi';
// import {YugabyteUi} from "./YugabyteUi";
// import {TidbUi} from "./TidbUi";
// import {VitessUi} from "./VitessUi";
export class SqlUiFactory {
    static create(connectionConfig) {
        // connectionConfig.meta = connectionConfig.meta || {};
        // connectionConfig.meta.dbtype = connectionConfig.meta.dbtype || "";
        if (connectionConfig.client === 'mysql' ||
            connectionConfig.client === 'mysql2') {
            // if (connectionConfig.meta.dbtype === "tidb")
            //   return Tidb;
            // if (connectionConfig.meta.dbtype === "vitess")
            //   return Vitess;
            return new MysqlUi();
        }
        if (connectionConfig.client === 'sqlite3') {
            return new SqliteUi();
        }
        if (connectionConfig.client === 'oracledb') {
            return new OracleUi();
        }
        if (connectionConfig.client === 'pg') {
            // if (connectionConfig.meta.dbtype === "yugabyte")
            //   return Yugabyte;
            return new PgUi();
        }
        if (connectionConfig.client === 'snowflake') {
            return new SnowflakeUi();
        }
        if (connectionConfig.client === 'databricks') {
            return new DatabricksUi();
        }
        throw new Error('Database not supported');
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU3FsVWlGYWN0b3J5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL2xpYi9zcWxVaS9TcWxVaUZhY3RvcnkudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBR0EsT0FBTyxFQUFFLE9BQU8sRUFBRSxNQUFNLFdBQVcsQ0FBQztBQUNwQyxPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0sWUFBWSxDQUFDO0FBQ3RDLE9BQU8sRUFBRSxJQUFJLEVBQUUsTUFBTSxRQUFRLENBQUM7QUFDOUIsT0FBTyxFQUFFLFFBQVEsRUFBRSxNQUFNLFlBQVksQ0FBQztBQUN0QyxPQUFPLEVBQUUsV0FBVyxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQzVDLE9BQU8sRUFBRSxZQUFZLEVBQUUsTUFBTSxnQkFBZ0IsQ0FBQztBQUc5QywyQ0FBMkM7QUFDM0MsbUNBQW1DO0FBQ25DLHVDQUF1QztBQUV2QyxNQUFNLE9BQU8sWUFBWTtJQUN2QixNQUFNLENBQUMsTUFBTSxDQUFDLGdCQUFnQjtRQUM1Qix1REFBdUQ7UUFDdkQscUVBQXFFO1FBQ3JFLElBQ0UsZ0JBQWdCLENBQUMsTUFBTSxLQUFLLE9BQU87WUFDbkMsZ0JBQWdCLENBQUMsTUFBTSxLQUFLLFFBQVEsRUFDcEMsQ0FBQztZQUNELCtDQUErQztZQUMvQyxpQkFBaUI7WUFDakIsaURBQWlEO1lBQ2pELG1CQUFtQjtZQUVuQixPQUFPLElBQUksT0FBTyxFQUFFLENBQUM7UUFDdkIsQ0FBQztRQUVELElBQUksZ0JBQWdCLENBQUMsTUFBTSxLQUFLLFNBQVMsRUFBRSxDQUFDO1lBQzFDLE9BQU8sSUFBSSxRQUFRLEVBQUUsQ0FBQztRQUN4QixDQUFDO1FBQ0QsSUFBSSxnQkFBZ0IsQ0FBQyxNQUFNLEtBQUssVUFBVSxFQUFFLENBQUM7WUFDM0MsT0FBTyxJQUFJLFFBQVEsRUFBRSxDQUFDO1FBQ3hCLENBQUM7UUFFRCxJQUFJLGdCQUFnQixDQUFDLE1BQU0sS0FBSyxJQUFJLEVBQUUsQ0FBQztZQUNyQyxtREFBbUQ7WUFDbkQscUJBQXFCO1lBQ3JCLE9BQU8sSUFBSSxJQUFJLEVBQUUsQ0FBQztRQUNwQixDQUFDO1FBRUQsSUFBSSxnQkFBZ0IsQ0FBQyxNQUFNLEtBQUssV0FBVyxFQUFFLENBQUM7WUFDNUMsT0FBTyxJQUFJLFdBQVcsRUFBRSxDQUFDO1FBQzNCLENBQUM7UUFFRCxJQUFJLGdCQUFnQixDQUFDLE1BQU0sS0FBSyxZQUFZLEVBQUUsQ0FBQztZQUM3QyxPQUFPLElBQUksWUFBWSxFQUFFLENBQUM7UUFDNUIsQ0FBQztRQUVELE1BQU0sSUFBSSxLQUFLLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUM1QyxDQUFDO0NBQ0YifQ==