import UITypes from '../UITypes';
const dbTypes = [
    'int',
    'integer',
    'tinyint',
    'smallint',
    'mediumint',
    'bigint',
    'int2',
    'int8',
    'character',
    'blob sub_type text',
    'blob',
    'real',
    'double',
    'double precision',
    'float',
    'numeric',
    'boolean',
    'date',
    'datetime',
    'text',
    'varchar',
    'timestamp',
];
export class SqliteUi {
    //#region statics
    static getNewTableColumns() {
        return [
            {
                column_name: 'id',
                title: 'Id',
                dt: 'integer',
                dtx: 'integer',
                ct: 'int(11)',
                nrqd: false,
                rqd: true,
                ck: false,
                pk: true,
                un: false,
                ai: true,
                cdf: null,
                clen: null,
                np: null,
                ns: 0,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: 'ID',
                uip: '',
                uicn: '',
            },
            {
                column_name: 'title',
                title: 'Title',
                dt: 'varchar',
                dtx: 'specificType',
                ct: 'varchar',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                cdf: null,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: 'SingleLineText',
                uip: '',
                uicn: '',
            },
            {
                column_name: 'created_at',
                title: 'CreatedAt',
                dt: 'datetime',
                dtx: 'specificType',
                ct: 'datetime',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: UITypes.CreatedTime,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'updated_at',
                title: 'UpdatedAt',
                dt: 'datetime',
                dtx: 'specificType',
                ct: 'datetime',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: UITypes.LastModifiedTime,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'created_by',
                title: 'nc_created_by',
                dt: 'varchar',
                dtx: 'specificType',
                ct: 'varchar',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: UITypes.CreatedBy,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'updated_by',
                title: 'nc_updated_by',
                dt: 'varchar',
                dtx: 'specificType',
                ct: 'varchar',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: 45,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: UITypes.LastModifiedBy,
                uip: '',
                uicn: '',
                system: true,
            },
            {
                column_name: 'nc_order',
                title: 'nc_order',
                dt: 'real',
                dtx: 'specificType',
                ct: 'real',
                nrqd: true,
                rqd: false,
                ck: false,
                pk: false,
                un: false,
                ai: false,
                clen: null,
                np: null,
                ns: null,
                dtxp: '',
                dtxs: '',
                altered: 1,
                uidt: UITypes.Order,
                uip: '',
                uicn: '',
                system: true,
            },
        ];
    }
    static getNewColumn(suffix) {
        return {
            column_name: 'title' + suffix,
            dt: 'varchar',
            dtx: 'specificType',
            ct: 'varchar',
            nrqd: true,
            rqd: false,
            ck: false,
            pk: false,
            un: false,
            ai: false,
            cdf: null,
            clen: 45,
            np: null,
            ns: null,
            dtxp: '',
            dtxs: '',
            altered: 1,
            uidt: 'SingleLineText',
            uip: '',
            uicn: '',
        };
    }
    static getDefaultLengthForDatatype(_type) {
        return '';
    }
    static getDefaultLengthIsDisabled(type) {
        switch (type) {
            case 'integer':
            case 'blob':
            case 'real':
            case 'numeric':
                return true;
            case 'text':
                return false;
        }
    }
    static getDefaultValueForDatatype(type) {
        switch (type) {
            case 'integer':
                return 'eg : ' + 10;
            case 'text':
                return 'eg : hey';
            case 'numeric':
                return 'eg : ' + 10;
            case 'real':
                return 'eg : ' + 10.0;
            case 'blob':
                return 'eg : ' + 100;
        }
    }
    static getDefaultScaleForDatatype(type) {
        switch (type) {
            case 'integer':
            case 'text':
            case 'numeric':
            case 'real':
            case 'blob':
                return ' ';
        }
    }
    static colPropAIDisabled(col, columns) {
        // console.log(col);
        if (col.dt === 'integer') {
            for (let i = 0; i < columns.length; ++i) {
                if (columns[i].cn !== col.cn && columns[i].ai) {
                    return true;
                }
            }
            return false;
        }
        else {
            return true;
        }
    }
    static colPropUNDisabled(_col) {
        return true;
    }
    static onCheckboxChangeAI(col) {
        console.log(col);
        if (col.dt === 'int' ||
            col.dt === 'bigint' ||
            col.dt === 'smallint' ||
            col.dt === 'tinyint') {
            col.altered = col.altered || 2;
        }
    }
    static showScale(_columnObj) {
        return false;
    }
    static removeUnsigned(columns) {
        for (let i = 0; i < columns.length; ++i) {
            if (columns[i].altered === 1 &&
                !(columns[i].dt === 'int' ||
                    columns[i].dt === 'bigint' ||
                    columns[i].dt === 'tinyint' ||
                    columns[i].dt === 'smallint' ||
                    columns[i].dt === 'mediumint')) {
                columns[i].un = false;
                console.log('>> resetting unsigned value', columns[i].cn);
            }
            console.log(columns[i].cn);
        }
    }
    /*static extractFunctionName(query) {
      const reg =
        /^\s*CREATE\s+(?:OR\s+REPLACE\s*)?\s*FUNCTION\s+(?:[\w\d_]+\.)?([\w_\d]+)/i;
      const match = query.match(reg);
      return match && match[1];
    }
  
    static extractProcedureName(query) {
      const reg =
        /^\s*CREATE\s+(?:OR\s+REPLACE\s*)?\s*PROCEDURE\s+(?:[\w\d_]+\.)?([\w_\d]+)/i;
      const match = query.match(reg);
      return match && match[1];
    }*/
    static columnEditable(_colObj) {
        return true; // colObj.altered === 1;
    }
    /*static handleRawOutput(result, headers) {
      console.log(result);
      if (Array.isArray(result) && result[0]) {
        const keys = Object.keys(result[0]);
        // set headers before settings result
        for (let i = 0; i < keys.length; i++) {
          const text = keys[i];
          headers.push({ text, value: text, sortable: false });
        }
      }
      return result;
    }
  
    static splitQueries(query) {
      /!***
       * we are splitting based on semicolon
       * there are mechanism to escape semicolon within single/double quotes(string)
       *!/
      return query.match(/\b("[^"]*;[^"]*"|'[^']*;[^']*'|[^;])*;/g);
    }
  
    /!**
     * if sql statement is SELECT - it limits to a number
     * @param args
     * @returns {string|*}
     *!/
    sanitiseQuery(args) {
      let q = args.query.trim().split(';');
  
      if (q[0].startsWith('Select')) {
        q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
      } else if (q[0].startsWith('select')) {
        q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
      } else if (q[0].startsWith('SELECT')) {
        q = q[0] + ` LIMIT 0,${args.limit ? args.limit : 100};`;
      } else {
        return args.query;
      }
  
      return q;
    }
  
    static getColumnsFromJson(json, tn) {
      const columns = [];
  
      try {
        if (typeof json === 'object' && !Array.isArray(json)) {
          const keys = Object.keys(json);
          for (let i = 0; i < keys.length; ++i) {
            const column = {
              dp: null,
              tn,
              column_name: keys[i],
              cno: keys[i],
              np: null,
              ns: null,
              clen: null,
              cop: 1,
              pk: false,
              nrqd: false,
              rqd: false,
              un: false,
              ct: 'int(11) unsigned',
              ai: false,
              unique: false,
              cdf: null,
              cc: '',
              csn: null,
              dtx: 'specificType',
              dtxp: null,
              dtxs: 0,
              altered: 1,
            };
  
            switch (typeof json[keys[i]]) {
              case 'number':
                if (Number.isInteger(json[keys[i]])) {
                  if (SqliteUi.isValidTimestamp(keys[i], json[keys[i]])) {
                    Object.assign(column, {
                      dt: 'timestamp',
                    });
                  } else {
                    Object.assign(column, {
                      dt: 'integer',
                    });
                  }
                } else {
                  Object.assign(column, {
                    dt: 'real',
                  });
                }
                break;
              case 'string':
                // if (SqliteUi.isValidDate(json[keys[i]])) {
                //   Object.assign(column, {
                //     "dt": "datetime"
                //   });
                // } else
                if (json[keys[i]].length <= 255) {
                  Object.assign(column, {
                    dt: 'varchar',
                  });
                } else {
                  Object.assign(column, {
                    dt: 'text',
                  });
                }
                break;
              case 'boolean':
                Object.assign(column, {
                  dt: 'integer',
                });
                break;
              case 'object':
                Object.assign(column, {
                  dt: 'text',
                  np: null,
                  dtxp: null,
                });
                break;
              default:
                break;
            }
            columns.push(column);
          }
        }
      } catch (e) {
        console.log('Error in getColumnsFromJson', e);
      }
  
      return columns;
    }
  
    static isValidTimestamp(key, value) {
      if (typeof value !== 'number') {
        return false;
      }
      return new Date(value).getTime() > 0 && /(?:_|(?=A))[aA]t$/.test(key);
    }
  
    static isValidDate(value) {
      return new Date(value).getTime() > 0;
    }*/
    static onCheckboxChangeAU(col) {
        console.log(col);
        // if (1) {
        col.altered = col.altered || 2;
        // }
        // if (!col.ai) {
        //   col.dtx = 'specificType'
        // } else {
        //   col.dtx = ''
        // }
    }
    static colPropAuDisabled(col) {
        if (col.altered !== 1) {
            return true;
        }
        switch (col.dt) {
            case 'date':
            case 'datetime':
            case 'timestamp':
            case 'time':
                return false;
            default:
                return true;
        }
    }
    static getAbstractType(col) {
        var _a;
        switch ((_a = col.dt) === null || _a === void 0 ? void 0 : _a.replace(/\(\d+\)$/).toLowerCase()) {
            case 'date':
                return 'date';
            case 'datetime':
            case 'timestamp':
                return 'datetime';
            case 'integer':
            case 'int':
            case 'tinyint':
            case 'smallint':
            case 'mediumint':
            case 'bigint':
            case 'int2':
            case 'int8':
                return 'integer';
            case 'text':
                return 'text';
            case 'boolean':
                return 'boolean';
            case 'real':
            case 'double':
            case 'double precision':
            case 'float':
            case 'decimal':
            case 'numeric':
                return 'float';
            case 'blob sub_type text':
            case 'blob':
                return 'blob';
            case 'character':
            case 'varchar':
                return 'string';
        }
        return 'string';
    }
    static getUIType(col) {
        switch (this.getAbstractType(col)) {
            case 'integer':
                return 'Number';
            case 'boolean':
                return 'Checkbox';
            case 'float':
                return 'Decimal';
            case 'date':
                return 'Date';
            case 'datetime':
                return 'CreatedTime';
            case 'time':
                return 'Time';
            case 'year':
                return 'Year';
            case 'string':
                return 'SingleLineText';
            case 'text':
                return 'LongText';
            case 'blob':
                return 'Attachment';
            case 'enum':
                return 'SingleSelect';
            case 'set':
                return 'MultiSelect';
            case 'json':
                return 'LongText';
        }
    }
    static getDataTypeForUiType(col, idType) {
        const colProp = {};
        switch (col.uidt) {
            case 'ID':
                {
                    const isAutoIncId = idType === 'AI';
                    const isAutoGenId = idType === 'AG';
                    colProp.dt = isAutoGenId ? 'varchar' : 'integer';
                    colProp.pk = true;
                    colProp.un = isAutoIncId;
                    colProp.ai = isAutoIncId;
                    colProp.rqd = true;
                    colProp.meta = isAutoGenId ? { ag: 'nc' } : undefined;
                }
                break;
            case 'ForeignKey':
                colProp.dt = 'varchar';
                break;
            case 'SingleLineText':
                colProp.dt = 'varchar';
                break;
            case 'LongText':
                colProp.dt = 'text';
                break;
            case 'Attachment':
                colProp.dt = 'text';
                break;
            case 'GeoData':
                colProp.dt = 'text';
                break;
            case 'Checkbox':
                colProp.dt = 'boolean';
                colProp.cdf = '0';
                break;
            case 'MultiSelect':
                colProp.dt = 'text';
                break;
            case 'SingleSelect':
                colProp.dt = 'text';
                break;
            case 'Collaborator':
                colProp.dt = 'varchar';
                break;
            case 'Date':
                colProp.dt = 'date';
                break;
            case 'Year':
                colProp.dt = 'year';
                break;
            case 'Time':
                colProp.dt = 'time';
                break;
            case 'PhoneNumber':
                colProp.dt = 'varchar';
                colProp.validate = {
                    func: ['isMobilePhone'],
                    args: [''],
                    msg: ['Validation failed : isMobilePhone'],
                };
                break;
            case 'Email':
                colProp.dt = 'varchar';
                colProp.validate = {
                    func: ['isEmail'],
                    args: [''],
                    msg: ['Validation failed : isEmail'],
                };
                break;
            case 'URL':
                colProp.dt = 'varchar';
                colProp.validate = {
                    func: ['isURL'],
                    args: [''],
                    msg: ['Validation failed : isURL'],
                };
                break;
            case 'Number':
                colProp.dt = 'integer';
                break;
            case 'Decimal':
                colProp.dt = 'decimal';
                break;
            case 'Currency':
                colProp.dt = 'double precision';
                colProp.validate = {
                    func: ['isCurrency'],
                    args: [''],
                    msg: ['Validation failed : isCurrency'],
                };
                break;
            case 'Percent':
                colProp.dt = 'double';
                break;
            case 'Duration':
                colProp.dt = 'decimal';
                break;
            case 'Rating':
                colProp.dt = 'integer';
                colProp.cdf = '0';
                break;
            case 'Formula':
                colProp.dt = 'varchar';
                break;
            case 'Rollup':
                colProp.dt = 'varchar';
                break;
            case 'Count':
                colProp.dt = 'integer';
                break;
            case 'Lookup':
                colProp.dt = 'varchar';
                break;
            case 'DateTime':
                colProp.dt = 'datetime';
                break;
            case 'CreatedTime':
                colProp.dt = 'datetime';
                break;
            case 'LastModifiedTime':
                colProp.dt = 'datetime';
                break;
            case 'AutoNumber':
                colProp.dt = 'integer';
                break;
            case 'Barcode':
                colProp.dt = 'varchar';
                break;
            case 'Button':
                colProp.dt = 'varchar';
                break;
            case 'JSON':
                colProp.dt = 'text';
                break;
            case 'Order':
                colProp.dt = 'real';
                break;
            default:
                colProp.dt = 'varchar';
                break;
        }
        return colProp;
    }
    static getDataTypeListForUiType(col, idType) {
        switch (col.uidt) {
            case 'ID':
                if (idType === 'AG') {
                    return ['character', 'text', 'varchar'];
                }
                else if (idType === 'AI') {
                    return [
                        'int',
                        'integer',
                        'tinyint',
                        'smallint',
                        'mediumint',
                        'bigint',
                        'int2',
                        'int8',
                    ];
                }
                else {
                    return dbTypes;
                }
            case 'ForeignKey':
                return dbTypes;
            case 'SingleLineText':
            case 'LongText':
            case 'Attachment':
            case 'Collaborator':
            case 'GeoData':
                return ['character', 'text', 'varchar'];
            case 'Checkbox':
                return [
                    'int',
                    'integer',
                    'tinyint',
                    'smallint',
                    'mediumint',
                    'bigint',
                    'int2',
                    'int8',
                    'boolean',
                ];
            case 'MultiSelect':
                return ['text', 'varchar'];
            case 'SingleSelect':
                return ['text', 'varchar'];
            case 'Year':
                return [
                    'int',
                    'integer',
                    'tinyint',
                    'smallint',
                    'mediumint',
                    'bigint',
                    'int2',
                    'int8',
                ];
            case 'Time':
                return [
                    'int',
                    'integer',
                    'tinyint',
                    'smallint',
                    'mediumint',
                    'bigint',
                    'int2',
                    'int8',
                ];
            case 'PhoneNumber':
            case 'Email':
                return ['varchar', 'text'];
            case 'URL':
                return ['varchar', 'text'];
            case 'Number':
                return [
                    'int',
                    'integer',
                    'tinyint',
                    'smallint',
                    'mediumint',
                    'bigint',
                    'int2',
                    'int8',
                    'numeric',
                    'real',
                    'double',
                    'double precision',
                    'float',
                ];
            case 'Decimal':
                return ['real', 'double', 'double precision', 'float', 'numeric'];
            case 'Currency':
                return [
                    'real',
                    'double',
                    'double precision',
                    'float',
                    'int',
                    'integer',
                    'tinyint',
                    'smallint',
                    'mediumint',
                    'bigint',
                    'int2',
                    'int8',
                    'numeric',
                ];
            case 'Percent':
                return [
                    'real',
                    'double',
                    'double precision',
                    'float',
                    'int',
                    'integer',
                    'tinyint',
                    'smallint',
                    'mediumint',
                    'bigint',
                    'int2',
                    'int8',
                    'numeric',
                ];
            case 'Duration':
                return [
                    'int',
                    'integer',
                    'tinyint',
                    'smallint',
                    'mediumint',
                    'bigint',
                    'int2',
                    'int8',
                ];
            case 'Rating':
                return [
                    'int',
                    'integer',
                    'tinyint',
                    'smallint',
                    'mediumint',
                    'bigint',
                    'int2',
                    'int8',
                    'numeric',
                    'real',
                    'double',
                    'double precision',
                    'float',
                ];
            case 'Formula':
            case 'Button':
                return ['text', 'varchar'];
            case 'Rollup':
                return ['varchar'];
            case 'Count':
                return [
                    'int',
                    'integer',
                    'tinyint',
                    'smallint',
                    'mediumint',
                    'bigint',
                    'int2',
                    'int8',
                ];
            case 'Lookup':
                return ['varchar'];
            case 'Date':
                return ['date', 'varchar'];
            case 'DateTime':
            case 'CreatedTime':
            case 'LastModifiedTime':
                return ['datetime', 'timestamp'];
            case 'AutoNumber':
                return [
                    'int',
                    'integer',
                    'tinyint',
                    'smallint',
                    'mediumint',
                    'bigint',
                    'int2',
                    'int8',
                ];
            case 'Barcode':
                return ['varchar'];
            case 'Geometry':
                return ['text'];
            case 'JSON':
                return ['text'];
            default:
                return dbTypes;
        }
    }
    static getUnsupportedFnList() {
        return [
            'XOR',
            'REGEX_MATCH',
            'REGEX_EXTRACT',
            'REGEX_REPLACE',
            'VALUE',
            'COUNTA',
            'COUNT',
            'DATESTR',
            'ARRAYSORT',
            'ARRAYUNIQUE',
            'ARRAYSLICE',
            'ARRAYCOMPACT',
        ];
    }
    static getCurrentDateDefault(_col) {
        return null;
    }
    static isEqual(dataType1, dataType2) {
        if (dataType1 === dataType2)
            return true;
        const abstractType1 = this.getAbstractType({ dt: dataType1 });
        const abstractType2 = this.getAbstractType({ dt: dataType2 });
        if (abstractType1 &&
            abstractType1 === abstractType2 &&
            ['integer', 'float'].includes(abstractType1))
            return true;
        return false;
    }
    //#endregion statics
    //#region methods
    getNewTableColumns() {
        return SqliteUi.getNewTableColumns();
    }
    getNewColumn(suffix) {
        return SqliteUi.getNewColumn(suffix);
    }
    getDefaultLengthForDatatype(type) {
        return SqliteUi.getDefaultLengthForDatatype(type);
    }
    getDefaultLengthIsDisabled(type) {
        return SqliteUi.getDefaultLengthIsDisabled(type);
    }
    getDefaultValueForDatatype(type) {
        return SqliteUi.getDefaultValueForDatatype(type);
    }
    getDefaultScaleForDatatype(type) {
        return SqliteUi.getDefaultScaleForDatatype(type);
    }
    colPropAIDisabled(col, columns) {
        return SqliteUi.colPropAIDisabled(col, columns);
    }
    colPropUNDisabled(col) {
        return SqliteUi.colPropUNDisabled(col);
    }
    onCheckboxChangeAI(col) {
        return SqliteUi.onCheckboxChangeAI(col);
    }
    showScale(columnObj) {
        return SqliteUi.showScale(columnObj);
    }
    removeUnsigned(columns) {
        return SqliteUi.removeUnsigned(columns);
    }
    columnEditable(colObj) {
        return SqliteUi.columnEditable(colObj);
    }
    onCheckboxChangeAU(col) {
        return SqliteUi.onCheckboxChangeAU(col);
    }
    colPropAuDisabled(col) {
        return SqliteUi.colPropAuDisabled(col);
    }
    getAbstractType(col) {
        return SqliteUi.getAbstractType(col);
    }
    getUIType(col) {
        return SqliteUi.getUIType(col);
    }
    getDataTypeForUiType(col, idType) {
        return SqliteUi.getDataTypeForUiType(col, idType);
    }
    getDataTypeListForUiType(col, idType) {
        return SqliteUi.getDataTypeListForUiType(col, idType);
    }
    getUnsupportedFnList() {
        return SqliteUi.getUnsupportedFnList();
    }
    getCurrentDateDefault(_col) {
        return SqliteUi.getCurrentDateDefault(_col);
    }
    isEqual(dataType1, dataType2) {
        return SqliteUi.isEqual(dataType1, dataType2);
    }
    adjustLengthAndScale(_newColumn, _oldColumn) { }
    isParsedJsonReturnType(_col) {
        return false;
    }
    get tableNameLengthLimit() {
        return 255;
    }
}
//# sourceMappingURL=data:application/json;base64,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