var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { v4 as uuidv4 } from 'uuid';
import { ncIsUndefined } from './is';
const AppendToLengthSuffixConfig = {
    _: {
        replacement: '___{index}',
        replacementRegex: /___\s?(\d*)$/,
    },
    dot: {
        replacement: '...{index}',
        replacementRegex: /\.\.\.\s?(\d*)$/,
    },
};
export var AppendToLengthSuffix;
(function (AppendToLengthSuffix) {
    AppendToLengthSuffix["_"] = "_";
    AppendToLengthSuffix["dot"] = "dot";
})(AppendToLengthSuffix || (AppendToLengthSuffix = {}));
/**
 * get a row & column given a numeric position
 * row & column start at 0
 */
export function getRowColPositionFromIndex({ stack, position, }) {
    const parts = stack.substring(0, position).split('\n');
    return {
        column: parts[parts.length - 1].length,
        row: parts.length - 1,
    };
}
export function appendToLength(param) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a, _b;
        const { value, appendage, maxLength, isExists } = param;
        const suffixConfig = AppendToLengthSuffixConfig[(_a = param.suffix) !== null && _a !== void 0 ? _a : AppendToLengthSuffix.dot];
        // if it's already in the form of truncated
        // skip with usual append
        if ((value + appendage).length > maxLength) {
            const existingIndex = (_b = value.match(suffixConfig.replacementRegex)) === null || _b === void 0 ? void 0 : _b[1];
            return truncateToLength({
                value,
                maxLength,
                currentIndex: !ncIsUndefined(existingIndex) && existingIndex !== ''
                    ? Number(existingIndex)
                    : undefined,
                isExists,
                suffix: param.suffix,
            });
        }
        let currentIndex = 1;
        let needle = value + appendage;
        while (yield isExists(needle)) {
            needle = value + appendage + '_' + currentIndex++;
            if (needle.length >= maxLength) {
                return appendToLength(Object.assign(Object.assign({}, param), { appendage: appendage + '_' + currentIndex++, suffix: param.suffix }));
            }
        }
        return needle;
    });
}
export function truncateToLength(param) {
    return __awaiter(this, void 0, void 0, function* () {
        var _a;
        const { value, currentIndex, maxLength, isExists } = param;
        const suffixConfig = AppendToLengthSuffixConfig[(_a = param.suffix) !== null && _a !== void 0 ? _a : AppendToLengthSuffix.dot];
        const replacement = ncIsUndefined(currentIndex) ? '' : `${currentIndex}`;
        const suffix = suffixConfig.replacement.replace('{index}', replacement);
        const needle = value.substring(0, maxLength - suffix.length) + suffix;
        if (!(yield isExists(needle))) {
            return needle;
        }
        else {
            return truncateToLength(Object.assign(Object.assign({}, param), { currentIndex: ncIsUndefined(currentIndex) ? 2 : currentIndex + 1 }));
        }
    });
}
/**
 * Generates a unique copy name by checking against existing names/items
 */
export function generateUniqueCopyName(originalName, existing, options = {}) {
    const { accessor, prefix = 'Copy of', separator = ' ', counterFormat = '({counter})', } = options;
    // Extract names from the existing array
    const existingNames = existing.map((item) => {
        if (typeof item === 'string')
            return item;
        if (accessor) {
            return typeof accessor === 'function'
                ? accessor(item)
                : String(item[accessor]);
        }
        // Default to 'title' property if no accessor specified
        return String(item.title);
    });
    const getPrefix = () => {
        return prefix ? `${prefix} ` : prefix !== null && prefix !== void 0 ? prefix : '';
    };
    let newName = `${getPrefix()}${originalName}`;
    let counter = 1;
    while (existingNames.includes(newName)) {
        const counterText = counterFormat.replace('{counter}', counter.toString());
        newName = `${getPrefix()}${originalName}${separator}${counterText}`;
        counter++;
    }
    return newName;
}
export function escapeRegexString(string) {
    return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');
}
/**
 * Trim matching quotes from the string
 * @param str - The string to trim
 * @returns The trimmed string
 */
export const trimMatchingQuotes = (str) => {
    var _a, _b;
    if (!(str === null || str === void 0 ? void 0 : str.trim()))
        return '';
    return (_b = (_a = str === null || str === void 0 ? void 0 : str.trim()) === null || _a === void 0 ? void 0 : _a.replace(/^(['"])(.*)\1$/, '$2')) !== null && _b !== void 0 ? _b : '';
};
/**
 * Get all matches of a regex in a string
 * @param str - The string to search
 * @param regex - The regular expression to match against
 * @returns An array of all matches of the regex in the string
 *
 * Note: Since we are using ES2017, `String.prototype.matchAll` is not available.
 * This function acts as a fallback to achieve the same behavior.
 */
export function stringAllMatches(str, regex) {
    // Ensure regex has the global flag, because exec() needs it to iterate
    const globalRegex = new RegExp(regex.source, regex.flags.includes('g') ? regex.flags : regex.flags + 'g');
    const matches = [];
    let m;
    while ((m = globalRegex.exec(str)) !== null) {
        matches.push(m);
    }
    return matches;
}
export function generateRandomUuid() {
    if ((crypto === null || crypto === void 0 ? void 0 : crypto.randomUUID) && typeof crypto.randomUUID === 'function') {
        return crypto.randomUUID();
    }
    return uuidv4();
}
//# sourceMappingURL=data:application/json;base64,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