import { MetaType } from '../Api';
export declare enum SyncType {
    Full = "full",
    Incremental = "incremental"
}
export declare enum SyncTrigger {
    Manual = "manual",
    Schedule = "schedule",
    Webhook = "webhook"
}
export declare enum OnDeleteAction {
    Delete = "delete",
    MarkDeleted = "mark_deleted"
}
export declare enum SyncCategory {
    TICKETING = "ticketing",
    HRIS = "hris",
    CRM = "crm",
    FILE_STORAGE = "file_storage",
    CUSTOM = "custom"
}
export interface SyncConfig {
    id: string;
    title: string;
    fk_parent_sync_config_id: string | null;
    fk_integration_id: string;
    sync_category: SyncCategory;
    sync_type: SyncType;
    sync_trigger: SyncTrigger;
    sync_trigger_cron?: string;
    sync_trigger_secret: string | null;
    sync_job_id: string;
    last_sync_at: string | null;
    next_sync_at: string | null;
    on_delete_action: OnDeleteAction;
    fk_workspace_id: string;
    base_id: string;
    created_at: string;
    updated_at: string;
    created_by: string;
    updated_by: string;
    children?: SyncConfig[];
    /**
     * JSON meta information for the sync config
     */
    meta?: MetaType;
}
export declare const SyncTriggerMeta: {
    manual: {
        value: SyncTrigger;
        label: string;
        description: string;
    };
    schedule: {
        value: SyncTrigger;
        label: string;
        description: string;
    };
    webhook: {
        value: SyncTrigger;
        label: string;
        description: string;
    };
};
export declare const OnDeleteActionMeta: {
    mark_deleted: {
        value: OnDeleteAction;
        label: string;
        description: string;
    };
    delete: {
        value: OnDeleteAction;
        label: string;
        description: string;
    };
};
export declare const SyncTypeMeta: {
    incremental: {
        value: SyncType;
        label: string;
        description: string;
    };
    full: {
        value: SyncType;
        label: string;
        description: string;
    };
};
export declare const SyncCategoryMeta: {
    ticketing: {
        value: SyncCategory;
        label: string;
        description: string;
        icon: string;
    };
    hris: {
        value: SyncCategory;
        label: string;
        description: string;
        icon: string;
    };
    crm: {
        value: SyncCategory;
        label: string;
        description: string;
        icon: string;
    };
    file_storage: {
        value: SyncCategory;
        label: string;
        description: string;
        icon: string;
    };
    custom: {
        value: SyncCategory;
        label: string;
        description: string;
        icon: string;
        beta: boolean;
    };
};
export declare enum TARGET_TABLES {
    TICKETING_TICKET = "ticketing_ticket",
    TICKETING_USER = "ticketing_user",
    TICKETING_COMMENT = "ticketing_comment",
    TICKETING_TEAM = "ticketing_team",
    HRIS_EMPLOYEE = "hris_employee",
    HRIS_EMPLOYMENT = "hris_employment",
    HRIS_LOCATION = "hris_location",
    FILE_STORAGE_FILE = "fs_file",
    FILE_STORAGE_FOLDER = "fs_folder",
    CRM_ACCOUNT = "crm_account",
    CRM_CONTACT = "crm_contact",
    CRM_USER = "crm_user"
}
export declare const TARGET_TABLES_META: {
    ticketing_ticket: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
    ticketing_user: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
    ticketing_comment: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
    ticketing_team: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
    hris_employee: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
    fs_file: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
    fs_folder: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
    hris_employment: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
    hris_location: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
    crm_account: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
    crm_contact: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
    crm_user: {
        category: SyncCategory;
        value: TARGET_TABLES;
        icon: string;
        label: string;
        description: string;
        required: boolean;
    };
};
