export var SyncType;
(function (SyncType) {
    SyncType["Full"] = "full";
    SyncType["Incremental"] = "incremental";
})(SyncType || (SyncType = {}));
export var SyncTrigger;
(function (SyncTrigger) {
    SyncTrigger["Manual"] = "manual";
    SyncTrigger["Schedule"] = "schedule";
    SyncTrigger["Webhook"] = "webhook";
})(SyncTrigger || (SyncTrigger = {}));
export var OnDeleteAction;
(function (OnDeleteAction) {
    OnDeleteAction["Delete"] = "delete";
    OnDeleteAction["MarkDeleted"] = "mark_deleted";
})(OnDeleteAction || (OnDeleteAction = {}));
export var SyncCategory;
(function (SyncCategory) {
    SyncCategory["TICKETING"] = "ticketing";
    SyncCategory["HRIS"] = "hris";
    SyncCategory["CRM"] = "crm";
    SyncCategory["FILE_STORAGE"] = "file_storage";
    SyncCategory["CUSTOM"] = "custom";
})(SyncCategory || (SyncCategory = {}));
export const SyncTriggerMeta = {
    [SyncTrigger.Manual]: {
        value: SyncTrigger.Manual,
        label: 'Manual',
        description: 'Sync changes only when explicitly requested.',
    },
    [SyncTrigger.Schedule]: {
        value: SyncTrigger.Schedule,
        label: 'Scheduled',
        description: 'Automatically sync data at predefined time intervals.',
    },
    [SyncTrigger.Webhook]: {
        value: SyncTrigger.Webhook,
        label: 'Webhook',
        description: 'Sync initiated instantly by external events or system notifications.',
    },
};
export const OnDeleteActionMeta = {
    [OnDeleteAction.MarkDeleted]: {
        value: OnDeleteAction.MarkDeleted,
        label: 'Ignore',
        description: 'Keep records even if the source deletes them.',
    },
    [OnDeleteAction.Delete]: {
        value: OnDeleteAction.Delete,
        label: 'Delete',
        description: 'Remove records when they are deleted at the source.',
    },
};
export const SyncTypeMeta = {
    [SyncType.Incremental]: {
        value: SyncType.Incremental,
        label: 'Incremental',
        description: 'Syncs only new or changed records.',
    },
    [SyncType.Full]: {
        value: SyncType.Full,
        label: 'Full',
        description: 'Syncs all records every run.',
    },
};
export const SyncCategoryMeta = {
    [SyncCategory.TICKETING]: {
        value: SyncCategory.TICKETING,
        label: 'Ticketing',
        description: 'Sync issues, tickets, and related activity.',
        icon: 'ncClipboard',
    },
    [SyncCategory.HRIS]: {
        value: SyncCategory.HRIS,
        label: 'HRIS',
        description: 'Sync employees, leaves and timesheet.',
        icon: 'ncUsers',
    },
    [SyncCategory.CRM]: {
        value: SyncCategory.CRM,
        label: 'CRM',
        description: 'Sync customer and lead data.',
        icon: 'ncUsers',
    },
    [SyncCategory.FILE_STORAGE]: {
        value: SyncCategory.FILE_STORAGE,
        label: 'File Storage',
        description: 'Sync files, folders, and metadata.',
        icon: 'ncFolder',
    },
    [SyncCategory.CUSTOM]: {
        value: SyncCategory.CUSTOM,
        label: 'Custom',
        description: 'Build a sync for another service or app.',
        icon: 'ncDatabase',
        beta: true,
    },
};
export var TARGET_TABLES;
(function (TARGET_TABLES) {
    TARGET_TABLES["TICKETING_TICKET"] = "ticketing_ticket";
    TARGET_TABLES["TICKETING_USER"] = "ticketing_user";
    TARGET_TABLES["TICKETING_COMMENT"] = "ticketing_comment";
    TARGET_TABLES["TICKETING_TEAM"] = "ticketing_team";
    TARGET_TABLES["HRIS_EMPLOYEE"] = "hris_employee";
    // one by one will be enabled
    // HRIS_BANK_INFO = 'hris_bank_info',
    // HRIS_BENEFIT = 'hris_benefit',
    // HRIS_COMPANY = 'hris_company',
    // HRIS_DEPENDENT = 'hris_dependent',
    // HRIS_EMPLOYEE_PAYROLL_RUN = 'hris_employee_payroll_run',
    TARGET_TABLES["HRIS_EMPLOYMENT"] = "hris_employment";
    // HRIS_GROUP = 'hris_group',
    TARGET_TABLES["HRIS_LOCATION"] = "hris_location";
    // HRIS_PAYROLL_RUN = 'hris_payroll_run',
    // HRIS_TIME_OFF = 'hris_time_off',
    // HRIS_TIME_OFF_BALANCE = 'hris_time_off_balance',
    // HRIS_TIMESHEET_ENTRY = 'hris_timesheet_entry',
    // some not prioritized HRIS tables are commented
    // HRIS_EMPLOYER_BENEFIT = 'hris_employer_benefit',
    TARGET_TABLES["FILE_STORAGE_FILE"] = "fs_file";
    TARGET_TABLES["FILE_STORAGE_FOLDER"] = "fs_folder";
    TARGET_TABLES["CRM_ACCOUNT"] = "crm_account";
    // CRM_ASSOCIATION = 'crm_association',
    // CRM_ASSOCIATION_TYPE = 'crm_association_type',
    TARGET_TABLES["CRM_CONTACT"] = "crm_contact";
    // CRM_CUSTOM_OBJECT = 'crm_custom_object',
    // CRM_CUSTOM_OBJECT_CLASS = 'crm_custom_object_class',
    // CRM_ENGAGEMENT = 'crm_engagement',
    // CRM_ENGAGEMENT_TYPE = 'crm_engagement_type',
    // CRM_LEAD = 'crm_lead',
    // CRM_NOTE = 'crm_note',
    // CRM_OPPORTUNITY = 'crm_opportunity',
    // CRM_STAGE = 'crm_stage',
    // CRM_TASK = 'crm_task',
    TARGET_TABLES["CRM_USER"] = "crm_user";
})(TARGET_TABLES || (TARGET_TABLES = {}));
export const TARGET_TABLES_META = {
    [TARGET_TABLES.TICKETING_TICKET]: {
        category: SyncCategory.TICKETING,
        value: TARGET_TABLES.TICKETING_TICKET,
        icon: 'ncBookOpen',
        label: 'Ticket',
        description: 'Represents a ticket, issue, task, or case.',
        required: true,
    },
    [TARGET_TABLES.TICKETING_USER]: {
        category: SyncCategory.TICKETING,
        value: TARGET_TABLES.TICKETING_USER,
        icon: 'ncUsers',
        label: 'User',
        description: 'Represents users in the source app.',
        required: true,
    },
    [TARGET_TABLES.TICKETING_COMMENT]: {
        category: SyncCategory.TICKETING,
        value: TARGET_TABLES.TICKETING_COMMENT,
        icon: 'ncMessageCircle',
        label: 'Comment',
        description: 'Represents comments added to a ticket.',
        required: false,
    },
    [TARGET_TABLES.TICKETING_TEAM]: {
        category: SyncCategory.TICKETING,
        value: TARGET_TABLES.TICKETING_TEAM,
        icon: 'ncUsers',
        label: 'Team',
        description: 'Represents teams or groups in the source system.',
        required: false,
    },
    [TARGET_TABLES.HRIS_EMPLOYEE]: {
        category: SyncCategory.HRIS,
        value: TARGET_TABLES.HRIS_EMPLOYEE,
        icon: 'ncUsers',
        label: 'HR_Employee',
        description: 'Represents human resources employee data.',
        required: true,
    },
    [TARGET_TABLES.FILE_STORAGE_FILE]: {
        category: SyncCategory.FILE_STORAGE,
        value: TARGET_TABLES.FILE_STORAGE_FILE,
        icon: 'file',
        label: 'FS_File',
        description: 'Represents file storage file metadata.',
        required: false,
    },
    [TARGET_TABLES.FILE_STORAGE_FOLDER]: {
        category: SyncCategory.FILE_STORAGE,
        value: TARGET_TABLES.FILE_STORAGE_FOLDER,
        icon: 'ncFolder',
        label: 'FS_Folder',
        description: 'Represents file storage folder metadata.',
        required: false,
    },
    // [TARGET_TABLES.HRIS_BANK_INFO]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_BANK_INFO,
    //   icon: 'ncDatabase',
    //   label: 'HR_Bank Info',
    //   description: 'Represents human resources bank information data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_BENEFIT]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_BENEFIT,
    //   icon: 'ncDatabase',
    //   label: 'HR_Benefit',
    //   description: 'Represents human resources benefit data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_COMPANY]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_COMPANY,
    //   icon: 'ncDatabase',
    //   label: 'HR_Company',
    //   description: 'Represents human resources company data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_DEPENDENT]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_DEPENDENT,
    //   icon: 'ncUsers',
    //   label: 'HR_Dependent',
    //   description: 'Represents human resources dependent data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_EMPLOYEE_PAYROLL_RUN]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_EMPLOYEE_PAYROLL_RUN,
    //   icon: 'ncDatabase',
    //   label: 'HR_Employee Payroll Run',
    //   description: 'Represents human resources employee payroll run data.',
    //   required: false,
    // },
    [TARGET_TABLES.HRIS_EMPLOYMENT]: {
        category: SyncCategory.HRIS,
        value: TARGET_TABLES.HRIS_EMPLOYMENT,
        icon: 'ncDatabase',
        label: 'HR_Employment',
        description: 'Represents human resources employment data.',
        required: false,
    },
    // [TARGET_TABLES.HRIS_GROUP]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_GROUP,
    //   icon: 'ncUsers',
    //   label: 'HR_Group',
    //   description: 'Represents human resources group data.',
    //   required: false,
    // },
    [TARGET_TABLES.HRIS_LOCATION]: {
        category: SyncCategory.HRIS,
        value: TARGET_TABLES.HRIS_LOCATION,
        icon: 'ncDatabase',
        label: 'HR_Location',
        description: 'Represents human resources location data.',
        required: false,
    },
    // [TARGET_TABLES.HRIS_PAYROLL_RUN]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_PAYROLL_RUN,
    //   icon: 'ncDatabase',
    //   label: 'HR - Payroll Run',
    //   description: 'Represents human resources payroll run data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_TIME_OFF]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_TIME_OFF,
    //   icon: 'ncDatabase',
    //   label: 'HR - Time Off',
    //   description: 'Represents human resources time off data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_TIME_OFF_BALANCE]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_TIME_OFF_BALANCE,
    //   icon: 'ncDatabase',
    //   label: 'HR - Time Off Balance',
    //   description: 'Represents human resources time off balance data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_TIMESHEET_ENTRY]: {
    //   category: SyncCategory.HRIS,
    //   value: TARGET_TABLES.HRIS_TIMESHEET_ENTRY,
    //   icon: 'ncDatabase',
    //   label: 'HR - Timesheet Entry',
    //   description: 'Represents human resources timesheet entry data.',
    //   required: false,
    // },
    // [TARGET_TABLES.HRIS_EMPLOYER_BENEFIT]: {
    //   category: SyncCategory.CUSTOM,
    //   value: TARGET_TABLES.HRIS_EMPLOYER_BENEFIT,
    //   icon: 'ncDatabase',
    //   label: 'HR - Employer Benefit',
    //   description: 'Represents human resources employer benefit data.',
    //   required: false,
    // },
    [TARGET_TABLES.CRM_ACCOUNT]: {
        category: SyncCategory.CRM,
        value: TARGET_TABLES.CRM_ACCOUNT,
        icon: 'ncUsers',
        label: 'CRM_Account',
        description: 'Represents crm account data.',
        required: true,
    },
    // [TARGET_TABLES.CRM_ASSOCIATION]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_ASSOCIATION,
    //   icon: 'link2',
    //   label: 'CRM_Association',
    //   description: 'Represents crm association data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_ASSOCIATION_TYPE]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_ASSOCIATION_TYPE,
    //   icon: 'label',
    //   label: 'CRM_Association_type',
    //   description: 'Represents crm association types data.',
    //   required: false,
    // },
    [TARGET_TABLES.CRM_CONTACT]: {
        category: SyncCategory.CRM,
        value: TARGET_TABLES.CRM_CONTACT,
        icon: 'ncUsers',
        label: 'CRM_Contact',
        description: 'Represents crm contact data.',
        required: true,
    },
    // [TARGET_TABLES.CRM_CUSTOM_OBJECT]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_CUSTOM_OBJECT,
    //   icon: 'box',
    //   label: 'CRM_Custom_Object',
    //   description: 'Represents crm custom object data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_CUSTOM_OBJECT_CLASS]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_CUSTOM_OBJECT_CLASS,
    //   icon: 'layers',
    //   label: 'CRM_Custom_Object_Class',
    //   description: 'Represents crm custom object class data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_ENGAGEMENT]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_ENGAGEMENT,
    //   icon: 'message-square',
    //   label: 'CRM_Engagement',
    //   description: 'Represents crm engagement data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_ENGAGEMENT_TYPE]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_ENGAGEMENT_TYPE,
    //   icon: 'tag',
    //   label: 'CRM_Engagement_Type',
    //   description: 'Represents crm engagement type data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_LEAD]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_LEAD,
    //   icon: 'user-plus',
    //   label: 'CRM_Lead',
    //   description: 'Represents crm lead data.',
    //   required: true,
    // },
    // [TARGET_TABLES.CRM_NOTE]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_NOTE,
    //   icon: 'file-text',
    //   label: 'CRM_Note',
    //   description: 'Represents crm note data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_OPPORTUNITY]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_OPPORTUNITY,
    //   icon: 'trending-up',
    //   label: 'CRM_Opportunity',
    //   description: 'Represents crm opportunity data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_STAGE]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_STAGE,
    //   icon: 'sliders',
    //   label: 'CRM_Stage',
    //   description: 'Represents crm stage data.',
    //   required: false,
    // },
    // [TARGET_TABLES.CRM_TASK]: {
    //   category: SyncCategory.CRM,
    //   value: TARGET_TABLES.CRM_TASK,
    //   icon: 'check-square',
    //   label: 'CRM_Task',
    //   description: 'Represents crm task data.',
    //   required: false,
    // },
    [TARGET_TABLES.CRM_USER]: {
        category: SyncCategory.CRM,
        value: TARGET_TABLES.CRM_USER,
        icon: 'user',
        label: 'CRM_User',
        description: 'Represents crm user data.',
        required: true,
    },
};
//# sourceMappingURL=data:application/json;base64,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