const ServiceUserType = {
    AUTOMATION_USER: 'AUTOMATION_USER',
    SYNC_USER: 'SYNC_USER',
    WORKFLOW_USER: 'WORKFLOW_USER',
};
const NOCO_SERVICE_USERS = {
    [ServiceUserType.AUTOMATION_USER]: {
        id: 'usrautomation',
        email: 'automation@nocodb.com',
        display_name: 'NocoDB Automation',
        email_verified: true,
    },
    [ServiceUserType.SYNC_USER]: {
        id: 'usrsync',
        email: 'sync-service@nocodb.com',
        display_name: 'NocoDB Sync',
        email_verified: true,
    },
    [ServiceUserType.WORKFLOW_USER]: {
        id: 'usrworkflow',
        email: 'workflow-service@nocodb.com',
        display_name: 'NocoDB Workflow',
        email_verified: true,
    },
};
const isServiceUser = (user, serviceType) => {
    if (!user)
        return false;
    if (Array.isArray(serviceType)) {
        return serviceType.some((type) => isServiceUser(user, type));
    }
    // If specific service type is provided, check against that service user only
    if (serviceType) {
        const serviceUser = NOCO_SERVICE_USERS[serviceType];
        return (user === null || user === void 0 ? void 0 : user.email) === serviceUser.email || (user === null || user === void 0 ? void 0 : user.id) === serviceUser.id;
    }
    // Otherwise, check against all service users
    return Object.values(NOCO_SERVICE_USERS).some((serviceUser) => (user === null || user === void 0 ? void 0 : user.email) === serviceUser.email || (user === null || user === void 0 ? void 0 : user.id) === serviceUser.id);
};
export { ServiceUserType, NOCO_SERVICE_USERS, isServiceUser };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VydmljZVVzZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbGliL3N5c3RlbS9zZXJ2aWNlVXNlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxNQUFNLGVBQWUsR0FBRztJQUN0QixlQUFlLEVBQUUsaUJBQWlCO0lBQ2xDLFNBQVMsRUFBRSxXQUFXO0lBQ3RCLGFBQWEsRUFBRSxlQUFlO0NBQ3RCLENBQUM7QUFFWCxNQUFNLGtCQUFrQixHQUFHO0lBQ3pCLENBQUMsZUFBZSxDQUFDLGVBQWUsQ0FBQyxFQUFFO1FBQ2pDLEVBQUUsRUFBRSxlQUFlO1FBQ25CLEtBQUssRUFBRSx1QkFBdUI7UUFDOUIsWUFBWSxFQUFFLG1CQUFtQjtRQUNqQyxjQUFjLEVBQUUsSUFBSTtLQUNyQjtJQUNELENBQUMsZUFBZSxDQUFDLFNBQVMsQ0FBQyxFQUFFO1FBQzNCLEVBQUUsRUFBRSxTQUFTO1FBQ2IsS0FBSyxFQUFFLHlCQUF5QjtRQUNoQyxZQUFZLEVBQUUsYUFBYTtRQUMzQixjQUFjLEVBQUUsSUFBSTtLQUNyQjtJQUNELENBQUMsZUFBZSxDQUFDLGFBQWEsQ0FBQyxFQUFFO1FBQy9CLEVBQUUsRUFBRSxhQUFhO1FBQ2pCLEtBQUssRUFBRSw2QkFBNkI7UUFDcEMsWUFBWSxFQUFFLGlCQUFpQjtRQUMvQixjQUFjLEVBQUUsSUFBSTtLQUNyQjtDQUNPLENBQUM7QUFJWCxNQUFNLGFBQWEsR0FBRyxDQUNwQixJQUFTLEVBQ1QsV0FBK0MsRUFDdEMsRUFBRTtJQUNYLElBQUksQ0FBQyxJQUFJO1FBQUUsT0FBTyxLQUFLLENBQUM7SUFFeEIsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLFdBQVcsQ0FBQyxFQUFFLENBQUM7UUFDL0IsT0FBTyxXQUFXLENBQUMsSUFBSSxDQUFDLENBQUMsSUFBSSxFQUFFLEVBQUUsQ0FBQyxhQUFhLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDLENBQUM7SUFDL0QsQ0FBQztJQUVELDZFQUE2RTtJQUM3RSxJQUFJLFdBQVcsRUFBRSxDQUFDO1FBQ2hCLE1BQU0sV0FBVyxHQUFHLGtCQUFrQixDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQ3BELE9BQU8sQ0FBQSxJQUFJLGFBQUosSUFBSSx1QkFBSixJQUFJLENBQUUsS0FBSyxNQUFLLFdBQVcsQ0FBQyxLQUFLLElBQUksQ0FBQSxJQUFJLGFBQUosSUFBSSx1QkFBSixJQUFJLENBQUUsRUFBRSxNQUFLLFdBQVcsQ0FBQyxFQUFFLENBQUM7SUFDMUUsQ0FBQztJQUVELDZDQUE2QztJQUM3QyxPQUFPLE1BQU0sQ0FBQyxNQUFNLENBQUMsa0JBQWtCLENBQUMsQ0FBQyxJQUFJLENBQzNDLENBQUMsV0FBVyxFQUFFLEVBQUUsQ0FDZCxDQUFBLElBQUksYUFBSixJQUFJLHVCQUFKLElBQUksQ0FBRSxLQUFLLE1BQUssV0FBVyxDQUFDLEtBQUssSUFBSSxDQUFBLElBQUksYUFBSixJQUFJLHVCQUFKLElBQUksQ0FBRSxFQUFFLE1BQUssV0FBVyxDQUFDLEVBQUUsQ0FDbkUsQ0FBQztBQUNKLENBQUMsQ0FBQztBQUVGLE9BQU8sRUFBRSxlQUFlLEVBQUUsa0JBQWtCLEVBQUUsYUFBYSxFQUFFLENBQUMifQ==