var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
export class Timer {
    constructor({ handler, time, errorHandler, }) {
        this.handler = handler;
        this.time = time;
        this.errorHandler = errorHandler;
    }
    static start(handler, 
    // set time default as 1 minute
    time = 60 * 1000, { errorHandler } = {}) {
        if (time <= 0) {
            // if time invalid, set it to 1 minute
            time = 60 * 1000;
        }
        const timer = new Timer({ handler, time, errorHandler });
        timer.start();
        return timer;
    }
    start() {
        this.timeoutHandle = setTimeout(() => __awaiter(this, void 0, void 0, function* () {
            var _a;
            try {
                yield this.handler(this);
            }
            catch (ex) {
                (_a = this.errorHandler) === null || _a === void 0 ? void 0 : _a.call(this, ex);
            }
        }), this.time);
        // Safe unref call
        // need to do this because the typescript is not specific for node, and unref is node-specific
        if (this.timeoutHandle &&
            typeof this.timeoutHandle === 'object' &&
            'unref' in this.timeoutHandle) {
            this.timeoutHandle.unref();
        }
    }
    stop() {
        if (this.timeoutHandle) {
            clearTimeout(this.timeoutHandle);
            this.timeoutHandle = undefined;
        }
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGltZXIudXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbGliL3RpbWVyLnV0aWxzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUNBLE1BQU0sT0FBTyxLQUFLO0lBQ2hCLFlBQW9CLEVBQ2xCLE9BQU8sRUFDUCxJQUFJLEVBQ0osWUFBWSxHQUtiO1FBQ0MsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUM7UUFDdkIsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7UUFDakIsSUFBSSxDQUFDLFlBQVksR0FBRyxZQUFZLENBQUM7SUFDbkMsQ0FBQztJQUtELE1BQU0sQ0FBQyxLQUFLLENBQ1YsT0FBb0I7SUFDcEIsK0JBQStCO0lBQy9CLE9BQWUsRUFBRSxHQUFHLElBQUksRUFDeEIsRUFBRSxZQUFZLEtBQTZDLEVBQUU7UUFFN0QsSUFBSSxJQUFJLElBQUksQ0FBQyxFQUFFLENBQUM7WUFDZCxzQ0FBc0M7WUFDdEMsSUFBSSxHQUFHLEVBQUUsR0FBRyxJQUFJLENBQUM7UUFDbkIsQ0FBQztRQUNELE1BQU0sS0FBSyxHQUFHLElBQUksS0FBSyxDQUFDLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxZQUFZLEVBQUUsQ0FBQyxDQUFDO1FBQ3pELEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUNkLE9BQU8sS0FBSyxDQUFDO0lBQ2YsQ0FBQztJQUdELEtBQUs7UUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLFVBQVUsQ0FBQyxHQUFTLEVBQUU7O1lBQ3pDLElBQUksQ0FBQztnQkFDSCxNQUFNLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDM0IsQ0FBQztZQUFDLE9BQU8sRUFBRSxFQUFFLENBQUM7Z0JBQ1osTUFBQSxJQUFJLENBQUMsWUFBWSxxREFBRyxFQUFFLENBQUMsQ0FBQztZQUMxQixDQUFDO1FBQ0gsQ0FBQyxDQUFBLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBRWQsa0JBQWtCO1FBQ2xCLDhGQUE4RjtRQUM5RixJQUNFLElBQUksQ0FBQyxhQUFhO1lBQ2xCLE9BQU8sSUFBSSxDQUFDLGFBQWEsS0FBSyxRQUFRO1lBQ3RDLE9BQU8sSUFBSSxJQUFJLENBQUMsYUFBYSxFQUM3QixDQUFDO1lBQ0EsSUFBSSxDQUFDLGFBQXFCLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDdEMsQ0FBQztJQUNILENBQUM7SUFDRCxJQUFJO1FBQ0YsSUFBSSxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUM7WUFDdkIsWUFBWSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztZQUNqQyxJQUFJLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztRQUNqQyxDQUFDO0lBQ0gsQ0FBQztDQUNGIn0=