import { getNodejsTimezone, isDateTimeStringHasTimezone, } from './timezoneUtils';
describe('timezoneUtils', () => {
    describe('getNodejsTimezone', () => {
        it('will get Asia/Kolkata', () => {
            expect(getNodejsTimezone('Asia/Kolkata', 'Asia/Jakarta')).toBe('Asia/Calcutta');
        });
    });
    describe('isDateTimeStringHasTimezone', () => {
        it('will evaluate some test cases', () => {
            // Test cases with expected values
            const testCases = [
                { value: '2024-10-14T10:30:00Z', expected: true },
                { value: '2024-10-14T10:30:00+05:30', expected: true },
                { value: '2024-10-14T10:30:00+0530', expected: true },
                { value: '2024-10-14T10:30:00-08:00', expected: true },
                { value: '2024-10-14 10:30:00 EST', expected: true },
                { value: '2024-10-14 10:30:00 GMT', expected: true },
                { value: 'Mon Oct 14 2024 10:30:00 GMT+0530', expected: true },
                { value: '2024-10-14 10:30:00 (PST)', expected: true },
                { value: '2024-10-14 10:30:00', expected: false },
                { value: '2024-10-14T10:30:00', expected: false },
                { value: '10/14/2024 10:30 AM', expected: false },
                { value: 'Mon Oct 14 10:30:00 2024', expected: false },
            ];
            const failed = [];
            testCases.forEach(({ value, expected }) => {
                const result = isDateTimeStringHasTimezone(value);
                if (result !== expected) {
                    failed.push(`${value} is expected ${expected} but found ${result}`);
                }
            });
            if (failed.length) {
                console.log(failed);
            }
            expect(failed.length).toBe(0);
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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