var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { RelationTypes } from '../../lib';
import { getColOptions } from '../../lib/unifiedMeta/getColOptions';
import { getColumns } from '../../lib/unifiedMeta/getColumns';
import { getLTARRelatedTable } from './getLTARRelatedTable';
/*
case 1:
table mw7s5x1ser8b8js
  ltar col: crxl9mqbdo9y06o
hm mkglmt0b0h84jp7
  ltar col: cps6kvxuf4s5phn

from crxl9mqbdo9y06o coloption:
  {
    "fk_column_id" : "crxl9mqbdo9y06o",
    "fk_related_model_id" : "mkglmt0b0h84jp7",
    "fk_child_column_id" : "ccz3j0i9d927vqf", // foreign key
    "fk_parent_column_id" : "ck2w0o0nhmjbvgj", // id
    "type": "hm"
  }

from cps6kvxuf4s5phn coloption:
  {
    "fk_column_id" : "cps6kvxuf4s5phn",
    "fk_related_model_id" : "mw7s5x1ser8b8js",
    "fk_child_column_id" : "ccz3j0i9d927vqf",
    "fk_parent_column_id" : "ck2w0o0nhmjbvgj",
    "type": "bt"
  }
*/
/*
case 2:
table mfz4bdhu24tl0yn
  ltar col: ckcs3zpt3opiadu
oo mdtzpm7lrqm0euq
  ltar col: ctmbms7ytc649i2

from ckcs3zpt3opiadu coloption:
  {
    "fk_column_id" : "ckcs3zpt3opiadu",
    "fk_related_model_id" : "mdtzpm7lrqm0euq",
    "fk_child_column_id" : "cjkd684tddrpvib", // foreign key
    "fk_parent_column_id" : "cytxetm7x9l24s4", // id
    "type": "oo"
  }

from ctmbms7ytc649i2 coloption:
  {
    "fk_column_id" : "ctmbms7ytc649i2",
    "fk_related_model_id" : "mfz4bdhu24tl0yn",
    "fk_child_column_id" : "cjkd684tddrpvib",
    "fk_parent_column_id" : "cytxetm7x9l24s4",
    "type": "oo"
  }

*/
export const getLinkInfo = (context_1, _a) => __awaiter(void 0, [context_1, _a], void 0, function* (context, { linkColumn, sourceModel, getMeta, }) {
    var _b, _c, _d, _e, _f, _g, _h;
    const relationColOptions = yield getColOptions(context, {
        column: linkColumn,
    });
    switch (relationColOptions.type) {
        case RelationTypes.ONE_TO_ONE:
        case RelationTypes.BELONGS_TO:
        case RelationTypes.HAS_MANY: {
            const joinIds = [
                relationColOptions.fk_child_column_id,
                relationColOptions.fk_parent_column_id,
            ];
            const sourceJoinColumn = (yield getColumns(context, { model: sourceModel })).find((col) => joinIds.includes(col.id));
            const targetContext = Object.assign(Object.assign({}, context), { base_id: (_b = relationColOptions.fk_related_base_id) !== null && _b !== void 0 ? _b : context.base_id });
            const targetModel = yield getLTARRelatedTable(targetContext, {
                colOptions: relationColOptions,
                getMeta,
            });
            const targetJoinColumn = (yield targetModel.getColumns(targetContext)).find((col) => joinIds.includes(col.id));
            return {
                source: {
                    context,
                    model: sourceModel,
                    linkColumn: linkColumn,
                    joinColumn: sourceJoinColumn,
                },
                target: {
                    context: targetContext,
                    model: targetModel,
                    joinColumn: targetJoinColumn,
                },
                relationType: relationColOptions.type,
                isBelongsTo: (_d = (_c = linkColumn.meta) === null || _c === void 0 ? void 0 : _c.bt) !== null && _d !== void 0 ? _d : false,
                relationFromSource: ((_e = linkColumn.meta) === null || _e === void 0 ? void 0 : _e.bt)
                    ? RelationTypes.BELONGS_TO
                    : relationColOptions.type,
            };
        }
        case RelationTypes.MANY_TO_MANY: {
            const joinIds = [
                relationColOptions.fk_child_column_id,
                relationColOptions.fk_parent_column_id,
            ];
            const sourceJoinColumn = (yield sourceModel.getColumns(context)).find((col) => joinIds.includes(col.id));
            const mmContext = Object.assign(Object.assign({}, context), { base_id: (_f = relationColOptions.fk_mm_base_id) !== null && _f !== void 0 ? _f : context.base_id });
            const mmModel = yield getMeta(mmContext, {
                id: relationColOptions.fk_mm_model_id,
            });
            const mmColumns = yield mmModel.getColumns(mmContext);
            let mmSourceJoinColumn;
            let mmTargetJoinColumn;
            if (sourceJoinColumn.id === relationColOptions.fk_parent_column_id) {
                mmSourceJoinColumn = mmColumns.find((col) => col.id === relationColOptions.fk_mm_parent_column_id);
                mmTargetJoinColumn = mmColumns.find((col) => col.id === relationColOptions.fk_mm_child_column_id);
            }
            else {
                mmSourceJoinColumn = mmColumns.find((col) => col.id === relationColOptions.fk_mm_child_column_id);
                mmTargetJoinColumn = mmColumns.find((col) => col.id === relationColOptions.fk_mm_parent_column_id);
            }
            const targetContext = Object.assign(Object.assign({}, context), { base_id: (_g = relationColOptions.fk_related_base_id) !== null && _g !== void 0 ? _g : context.base_id });
            const targetModel = yield relationColOptions.getRelatedTable(targetContext);
            const targetJoinColumn = (yield targetModel.getColumns(targetContext)).find((col) => joinIds.includes(col.id));
            return {
                source: {
                    context,
                    model: sourceModel,
                    linkColumn: linkColumn,
                    joinColumn: sourceJoinColumn,
                },
                mm: {
                    sourceJoinColumn: mmSourceJoinColumn,
                    targetJoinColumn: mmTargetJoinColumn,
                    model: mmModel,
                    context: mmContext,
                },
                target: {
                    context: targetContext,
                    model: targetModel,
                    joinColumn: targetJoinColumn,
                },
                relationType: relationColOptions.type,
                isBelongsTo: false,
                relationFromSource: ((_h = linkColumn.meta) === null || _h === void 0 ? void 0 : _h.bt)
                    ? RelationTypes.BELONGS_TO
                    : relationColOptions.type,
            };
        }
        // should not be possible to land into this
        default:
            return undefined;
    }
});
//# sourceMappingURL=data:application/json;base64,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