var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { getLTARRelatedTable } from './getLTARRelatedTable';
import { getContextFromObject } from './getContextFromObject';
import { getColOptions } from './getColOptions';
import { getColumns } from './getColumns';
export const getLookupRelatedInfo = (context_1, _a) => __awaiter(void 0, [context_1, _a], void 0, function* (context, { colOptions, columns, getMeta, }) {
    var _b;
    let relationColumn;
    relationColumn = columns.find((col) => col.id === colOptions.fk_relation_column_id);
    if (!relationColumn && 'getRelationColumn' in colOptions) {
        relationColumn = yield colOptions.getRelationColumn(Object.assign(Object.assign({}, context), { base_id: ((_b = columns === null || columns === void 0 ? void 0 : columns[0]) === null || _b === void 0 ? void 0 : _b.base_id) || context.base_id }));
    }
    const relatedTable = yield getLTARRelatedTable(getContextFromObject(relationColumn), {
        colOptions: yield getColOptions(getContextFromObject(relationColumn), {
            column: relationColumn,
        }),
        getMeta,
    });
    let lookupColumn;
    if ('getLookupColumn' in colOptions) {
        lookupColumn = yield colOptions.getLookupColumn(Object.assign(Object.assign({}, context), { base_id: (relatedTable === null || relatedTable === void 0 ? void 0 : relatedTable.base_id) || context.base_id }));
    }
    else {
        lookupColumn = (yield getColumns(getContextFromObject(relatedTable), {
            model: relatedTable,
        })).find((col) => col.id === colOptions.fk_lookup_column_id);
    }
    return {
        relatedTable,
        relationColumn,
        lookupColumn,
    };
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0TG9va3VwUmVsYXRlZEluZm8uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvbGliL3VuaWZpZWRNZXRhL2dldExvb2t1cFJlbGF0ZWRJbmZvLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUVBLE9BQU8sRUFBRSxtQkFBbUIsRUFBRSxNQUFNLHVCQUF1QixDQUFDO0FBQzVELE9BQU8sRUFBRSxvQkFBb0IsRUFBRSxNQUFNLHdCQUF3QixDQUFDO0FBQzlELE9BQU8sRUFBRSxhQUFhLEVBQUUsTUFBTSxpQkFBaUIsQ0FBQztBQUNoRCxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sY0FBYyxDQUFDO0FBRTFDLE1BQU0sQ0FBQyxNQUFNLG9CQUFvQixHQUFHLGdCQVdsQyxFQUFFLHVEQVZGLE9BQWtCLEVBQ2xCLEVBQ0UsVUFBVSxFQUNWLE9BQU8sRUFDUCxPQUFPLEdBS1I7O0lBRUQsSUFBSSxjQUF1QyxDQUFDO0lBQzVDLGNBQWMsR0FBRyxPQUFPLENBQUMsSUFBSSxDQUMzQixDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsR0FBRyxDQUFDLEVBQUUsS0FBSyxVQUFVLENBQUMscUJBQXFCLENBQ3JELENBQUM7SUFDRixJQUFJLENBQUMsY0FBYyxJQUFJLG1CQUFtQixJQUFJLFVBQVUsRUFBRSxDQUFDO1FBQ3pELGNBQWMsR0FBRyxNQUFNLFVBQVUsQ0FBQyxpQkFBaUIsaUNBQzlDLE9BQU8sS0FDVixPQUFPLEVBQUUsQ0FBQSxNQUFBLE9BQU8sYUFBUCxPQUFPLHVCQUFQLE9BQU8sQ0FBRyxDQUFDLENBQUMsMENBQUUsT0FBTyxLQUFJLE9BQU8sQ0FBQyxPQUFPLElBQ2pELENBQUM7SUFDTCxDQUFDO0lBRUQsTUFBTSxZQUFZLEdBQUcsTUFBTSxtQkFBbUIsQ0FDNUMsb0JBQW9CLENBQUMsY0FBYyxDQUFDLEVBQ3BDO1FBQ0UsVUFBVSxFQUNSLE1BQU0sYUFBYSxDQUNqQixvQkFBb0IsQ0FBQyxjQUFjLENBQUMsRUFDcEM7WUFDRSxNQUFNLEVBQUUsY0FBYztTQUN2QixDQUNGO1FBQ0gsT0FBTztLQUNSLENBQ0YsQ0FBQztJQUNGLElBQUksWUFBcUMsQ0FBQztJQUMxQyxJQUFJLGlCQUFpQixJQUFJLFVBQVUsRUFBRSxDQUFDO1FBQ3BDLFlBQVksR0FBRyxNQUFNLFVBQVUsQ0FBQyxlQUFlLGlDQUMxQyxPQUFPLEtBQ1YsT0FBTyxFQUFFLENBQUEsWUFBWSxhQUFaLFlBQVksdUJBQVosWUFBWSxDQUFFLE9BQU8sS0FBSSxPQUFPLENBQUMsT0FBTyxJQUNqRCxDQUFDO0lBQ0wsQ0FBQztTQUFNLENBQUM7UUFDTixZQUFZLEdBQUcsQ0FDYixNQUFNLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxZQUFZLENBQUMsRUFBRTtZQUNuRCxLQUFLLEVBQUUsWUFBWTtTQUNwQixDQUFDLENBQ0gsQ0FBQyxJQUFJLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUFDLEdBQUcsQ0FBQyxFQUFFLEtBQUssVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUM7SUFDN0QsQ0FBQztJQUVELE9BQU87UUFDTCxZQUFZO1FBQ1osY0FBYztRQUNkLFlBQVk7S0FDYixDQUFDO0FBQ0osQ0FBQyxDQUFBLENBQUMifQ==