var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { getColOptions } from './getColOptions';
import { getColumns } from './getColumns';
import { getLTARRelatedTable } from './getLTARRelatedTable';
export const getRollupColumn = (context_1, _a) => __awaiter(void 0, [context_1, _a], void 0, function* (context, { column, columns, getMeta, }) {
    const colOptions = yield getColOptions(context, { column });
    if ('getRollupColumn' in colOptions) {
        return yield colOptions.getRollupColumn(context);
    }
    else {
        const relationColumn = columns.find((col) => col.id ===
            colOptions.fk_relation_column_id);
        if (!relationColumn) {
            // TODO: better error type
            throw new Error(`Relation column not found on column ${column.title}(${column.id})`);
        }
        const relationColOptions = yield getColOptions(context, {
            column: relationColumn,
        });
        const relatedTable = yield getLTARRelatedTable(context, {
            colOptions: relationColOptions,
            getMeta,
        });
        const relatedTableColumns = yield getColumns(context, {
            model: relatedTable,
        });
        // TODO: possibly throw when column not found on relatedTableColumns
        return relatedTableColumns.find((col) => col.id ===
            colOptions.fk_rollup_column_id);
    }
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0Um9sbHVwQ29sdW1uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL2xpYi91bmlmaWVkTWV0YS9nZXRSb2xsdXBDb2x1bW4udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBRUEsT0FBTyxFQUFFLGFBQWEsRUFBRSxNQUFNLGlCQUFpQixDQUFDO0FBQ2hELE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxjQUFjLENBQUM7QUFDMUMsT0FBTyxFQUFFLG1CQUFtQixFQUFFLE1BQU0sdUJBQXVCLENBQUM7QUFFNUQsTUFBTSxDQUFDLE1BQU0sZUFBZSxHQUFHLGdCQVdLLEVBQUUsdURBVnBDLE9BQWtCLEVBQ2xCLEVBQ0UsTUFBTSxFQUNOLE9BQU8sRUFDUCxPQUFPLEdBS1I7SUFFRCxNQUFNLFVBQVUsR0FBRyxNQUFNLGFBQWEsQ0FDcEMsT0FBTyxFQUNQLEVBQUUsTUFBTSxFQUFFLENBQ1gsQ0FBQztJQUNGLElBQUksaUJBQWlCLElBQUksVUFBVSxFQUFFLENBQUM7UUFDcEMsT0FBTyxNQUFNLFVBQVUsQ0FBQyxlQUFlLENBQUMsT0FBTyxDQUFDLENBQUM7SUFDbkQsQ0FBQztTQUFNLENBQUM7UUFDTixNQUFNLGNBQWMsR0FBRyxPQUFPLENBQUMsSUFBSSxDQUNqQyxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQ04sR0FBRyxDQUFDLEVBQUU7WUFDTCxVQUE0QyxDQUFDLHFCQUFxQixDQUN0RSxDQUFDO1FBQ0YsSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO1lBQ3BCLDBCQUEwQjtZQUMxQixNQUFNLElBQUksS0FBSyxDQUNiLHVDQUF1QyxNQUFNLENBQUMsS0FBSyxJQUFJLE1BQU0sQ0FBQyxFQUFFLEdBQUcsQ0FDcEUsQ0FBQztRQUNKLENBQUM7UUFDRCxNQUFNLGtCQUFrQixHQUN0QixNQUFNLGFBQWEsQ0FBNkMsT0FBTyxFQUFFO1lBQ3ZFLE1BQU0sRUFBRSxjQUFjO1NBQ3ZCLENBQUMsQ0FBQztRQUVMLE1BQU0sWUFBWSxHQUFHLE1BQU0sbUJBQW1CLENBQUMsT0FBTyxFQUFFO1lBQ3RELFVBQVUsRUFBRSxrQkFBa0I7WUFDOUIsT0FBTztTQUNSLENBQUMsQ0FBQztRQUNILE1BQU0sbUJBQW1CLEdBQUcsTUFBTSxVQUFVLENBQUMsT0FBTyxFQUFFO1lBQ3BELEtBQUssRUFBRSxZQUFZO1NBQ3BCLENBQUMsQ0FBQztRQUNILG9FQUFvRTtRQUNwRSxPQUFPLG1CQUFtQixDQUFDLElBQUksQ0FDN0IsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUNOLEdBQUcsQ0FBQyxFQUFFO1lBQ0wsVUFBNEMsQ0FBQyxtQkFBbUIsQ0FDcEUsQ0FBQztJQUNKLENBQUM7QUFDSCxDQUFDLENBQUEsQ0FBQyJ9