import { UITypes } from './';
/**
 * Field types that support unique constraints
 */
export declare const UNIQUE_CONSTRAINT_SUPPORTED_TYPES: UITypes[];
/**
 * Validates if a field type supports unique constraints
 * @param uidt - UI data type
 * @param meta - Column metadata (for rich text check)
 * @returns true if the field type supports unique constraints
 */
export declare function isUniqueConstraintSupportedType(uidt: UITypes, meta?: any): boolean;
