import { UITypes } from './';
/**
 * Field types that support unique constraints
 */
export const UNIQUE_CONSTRAINT_SUPPORTED_TYPES = [
    UITypes.SingleLineText,
    UITypes.Email,
    UITypes.PhoneNumber,
    UITypes.URL,
    UITypes.Number,
    UITypes.Decimal,
    UITypes.Currency,
    UITypes.Percent,
    UITypes.Date,
    UITypes.DateTime,
    UITypes.Time,
];
/**
 * Validates if a field type supports unique constraints
 * @param uidt - UI data type
 * @param meta - Column metadata (for rich text check)
 * @returns true if the field type supports unique constraints
 */
export function isUniqueConstraintSupportedType(uidt, meta) {
    // Check for LongText with rich text enabled (not supported)
    if (uidt === UITypes.LongText && (meta === null || meta === void 0 ? void 0 : meta.richMode)) {
        return false;
    }
    return UNIQUE_CONSTRAINT_SUPPORTED_TYPES.includes(uidt);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidW5pcXVlQ29uc3RyYWludEhlbHBlcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvbGliL3VuaXF1ZUNvbnN0cmFpbnRIZWxwZXJzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxPQUFPLEVBQUUsTUFBTSxJQUFJLENBQUM7QUFFN0I7O0dBRUc7QUFDSCxNQUFNLENBQUMsTUFBTSxpQ0FBaUMsR0FBRztJQUMvQyxPQUFPLENBQUMsY0FBYztJQUN0QixPQUFPLENBQUMsS0FBSztJQUNiLE9BQU8sQ0FBQyxXQUFXO0lBQ25CLE9BQU8sQ0FBQyxHQUFHO0lBQ1gsT0FBTyxDQUFDLE1BQU07SUFDZCxPQUFPLENBQUMsT0FBTztJQUNmLE9BQU8sQ0FBQyxRQUFRO0lBQ2hCLE9BQU8sQ0FBQyxPQUFPO0lBQ2YsT0FBTyxDQUFDLElBQUk7SUFDWixPQUFPLENBQUMsUUFBUTtJQUNoQixPQUFPLENBQUMsSUFBSTtDQUNiLENBQUM7QUFFRjs7Ozs7R0FLRztBQUNILE1BQU0sVUFBVSwrQkFBK0IsQ0FDN0MsSUFBYSxFQUNiLElBQVU7SUFFViw0REFBNEQ7SUFDNUQsSUFBSSxJQUFJLEtBQUssT0FBTyxDQUFDLFFBQVEsS0FBSSxJQUFJLGFBQUosSUFBSSx1QkFBSixJQUFJLENBQUUsUUFBUSxDQUFBLEVBQUUsQ0FBQztRQUNoRCxPQUFPLEtBQUssQ0FBQztJQUNmLENBQUM7SUFFRCxPQUFPLGlDQUFpQyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUMxRCxDQUFDIn0=