import { WorkflowNodeDefinition } from './node';
export declare const GeneralNodeID: {
    readonly TRIGGER: "core.trigger";
    readonly PLUS: "core.plus";
    readonly NOTE: "note";
};
/**
 * Trigger activation types determine how triggers are managed when workflow is published/unpublished
 */
export declare enum TriggerActivationType {
    NONE = "none",// Manual triggers - no activation needed
    WEBHOOK = "webhook",// External webhooks (GitHub, GitLab, etc.)
    CRON = "cron"
}
/**
 * Trigger test modes determine how a trigger can be tested
 * A trigger can support multiple test modes (array)
 */
export declare enum TriggerTestMode {
    /** Use sample/mock data for testing (default) */
    SAMPLE_DATA = "sample_data",
    /** Create temporary webhook URL and wait for real request */
    LISTEN_WEBHOOK = "listen_webhook",
    /** User must trigger event on external service (GitHub, Stripe, etc.) */
    TRIGGER_EVENT = "trigger_event"
}
/**
 * Check if a node is a trigger node
 * Trigger nodes include:
 * - core.trigger (generic trigger placeholder)
 * - nocodb.trigger.* (NocoDB-specific triggers)
 * - *.trigger (external service triggers like github.trigger, gitlab.trigger)
 */
export declare function isTriggerNode(nodeType: string | undefined): boolean;
export declare const GENERAL_DEFAULT_NODES: WorkflowNodeDefinition[];
export declare const INIT_WORKFLOW_NODES: {
    id: string;
    type: "core.trigger";
    position: {
        x: number;
        y: number;
    };
    data: {
        title: string;
    };
}[];
