import { generateRandomUuid } from '../../lib/stringHelpers';
import { WorkflowNodeCategory } from './node';
export const GeneralNodeID = {
    TRIGGER: 'core.trigger',
    PLUS: 'core.plus',
    NOTE: 'note',
};
/**
 * Trigger activation types determine how triggers are managed when workflow is published/unpublished
 */
export var TriggerActivationType;
(function (TriggerActivationType) {
    TriggerActivationType["NONE"] = "none";
    TriggerActivationType["WEBHOOK"] = "webhook";
    TriggerActivationType["CRON"] = "cron";
})(TriggerActivationType || (TriggerActivationType = {}));
/**
 * Trigger test modes determine how a trigger can be tested
 * A trigger can support multiple test modes (array)
 */
export var TriggerTestMode;
(function (TriggerTestMode) {
    /** Use sample/mock data for testing (default) */
    TriggerTestMode["SAMPLE_DATA"] = "sample_data";
    /** Create temporary webhook URL and wait for real request */
    TriggerTestMode["LISTEN_WEBHOOK"] = "listen_webhook";
    /** User must trigger event on external service (GitHub, Stripe, etc.) */
    TriggerTestMode["TRIGGER_EVENT"] = "trigger_event";
})(TriggerTestMode || (TriggerTestMode = {}));
/**
 * Check if a node is a trigger node
 * Trigger nodes include:
 * - core.trigger (generic trigger placeholder)
 * - nocodb.trigger.* (NocoDB-specific triggers)
 * - *.trigger (external service triggers like github.trigger, gitlab.trigger)
 */
export function isTriggerNode(nodeType) {
    if (!nodeType)
        return false;
    return (nodeType === GeneralNodeID.TRIGGER ||
        nodeType.startsWith('nocodb.trigger.') ||
        nodeType.includes('.trigger'));
}
export const GENERAL_DEFAULT_NODES = [
    {
        id: GeneralNodeID.PLUS,
        title: 'Add Action / Condition',
        icon: 'ncPlus',
        description: 'Add a new action or condition to the workflow',
        category: WorkflowNodeCategory.ACTION,
        hidden: true,
        ports: [],
    },
    {
        id: GeneralNodeID.TRIGGER,
        title: 'Add Trigger',
        icon: 'ncPlus',
        description: 'Start your workflow',
        category: WorkflowNodeCategory.TRIGGER,
        hidden: true,
        ports: [],
    },
];
const initWorkflowNodes = [
    {
        id: generateRandomUuid(),
        type: GeneralNodeID.TRIGGER,
        position: { x: 250, y: 50 },
        data: {
            title: 'Trigger',
        },
    },
];
export const INIT_WORKFLOW_NODES = initWorkflowNodes;
//# sourceMappingURL=data:application/json;base64,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