declare enum VariableType {
    String = "string",
    Number = "number",
    Integer = "integer",
    Boolean = "boolean",
    Object = "object",
    Array = "array",
    Date = "date",
    DateTime = "datetime"
}
declare enum VariableGroupKey {
    Meta = "meta",// System fields (id, createdAt, etc.)
    Fields = "fields",// User data fields
    Iteration = "iteration"
}
interface VariableDefinition {
    key: string;
    name: string;
    type: VariableType;
    groupKey?: VariableGroupKey;
    isArray?: boolean;
    extra?: {
        entity_id?: string;
        entity?: 'column' | 'table' | 'view';
        icon?: string;
        uiType?: string;
        tableName?: string;
        viewName?: string;
        description?: string;
        value?: any;
        itemSchema?: VariableDefinition[];
        entityReferences?: {
            entity_id: string;
            entity: 'column' | 'table' | 'view';
            title: string;
            field: string;
        }[];
        port?: string;
    };
    children?: VariableDefinition[];
}
interface NodeExecutionResult {
    testMode?: string;
    nodeId: string;
    nodeTitle: string;
    status: 'pending' | 'running' | 'success' | 'error' | 'skipped';
    output?: any;
    input?: any;
    error?: string;
    startTime: number;
    endTime?: number;
    nextNode?: string;
    logs?: Array<{
        level: 'info' | 'warn' | 'error';
        message: string;
        ts?: number;
        data?: any;
    }>;
    metrics?: Record<string, number>;
    isStale?: boolean;
    inputVariables?: VariableDefinition[];
    outputVariables?: VariableDefinition[];
    loopContext?: LoopContext;
}
interface LoopContext {
    state: Record<string, any>;
    bodyPort: string;
    exitPort: string;
}
interface LoopIteration {
    iterationIndex: number;
    nodeResults: NodeExecutionResult[];
    childLoops?: {
        [loopNodeId: string]: LoopData;
    };
}
interface LoopData {
    nodeId: string;
    nodeTitle: string;
    totalIterations: number;
    iterations: {
        [iterationIndex: number]: LoopIteration;
    };
}
interface WorkflowExecutionState {
    id: string;
    workflowId: string;
    status: 'running' | 'waiting' | 'completed' | 'error' | 'cancelled' | 'skipped';
    startTime: number;
    endTime?: number;
    nodeResults: NodeExecutionResult[];
    currentNodeId?: string;
    triggerData?: any;
    triggerNodeTitle?: string;
    loops?: {
        [loopNodeId: string]: LoopData;
    };
    pausedAt?: number;
    resumeAt?: number;
    nextNodeId?: string;
}
interface IWorkflowExecution {
    id: string;
    fk_workspace_id: string;
    base_id: string;
    fk_workflow_id: string;
    workflow_data?: {
        id: string;
        title: string;
        nodes: WorkflowGeneralNode[];
        edges: WorkflowGeneralEdge[];
    } | Record<string, any>;
    execution_data?: WorkflowExecutionState;
    created_at?: string;
    updated_at?: string;
    finished_at?: string;
    started_at?: string;
    finished?: boolean;
    status: 'running' | 'waiting' | 'completed' | 'error' | 'cancelled' | 'skipped';
    resume_at?: string | Date;
}
interface NodeConfig {
    [key: string]: any;
}
interface WorkflowGeneralNode {
    id: string;
    type: string;
    position: {
        x: number;
        y: number;
    };
    data: {
        config: NodeConfig;
        title: string;
        description?: string;
        testResult?: NodeExecutionResult;
        inputVariables?: VariableDefinition[];
        outputVariables?: VariableDefinition[];
    };
    targetPosition: 'top' | 'bottom' | 'left' | 'right';
    sourcePosition: 'top' | 'bottom' | 'left' | 'right';
}
interface WorkflowGeneralEdge {
    id: string;
    source: string;
    target: string;
    animated: boolean;
    label?: string;
    sourcePortId?: string;
    targetPortId?: string;
}
export { VariableType, VariableGroupKey, VariableDefinition, WorkflowGeneralEdge, WorkflowGeneralNode, NodeExecutionResult, WorkflowExecutionState, IWorkflowExecution, LoopContext, LoopIteration, LoopData, };
