import { FormDefinition } from '../../lib/formBuilder';
import type { TriggerActivationType, TriggerTestMode } from './constants';
/**
 * Workflow Categories
 * Used to organize different types of workflow nodes
 */
export declare const WorkflowNodeCategory: {
    readonly TRIGGER: "trigger";
    readonly ACTION: "action";
    readonly FLOW: "flow";
};
export type WorkflowNodeCategoryType = (typeof WorkflowNodeCategory)[keyof typeof WorkflowNodeCategory];
export type WorkflowPortDirection = 'input' | 'output';
export interface WorkflowNodePort {
    id: string;
    label?: string;
    direction: WorkflowPortDirection;
    order?: number;
}
export interface WorkflowNodeDefinition {
    id: string;
    icon: string;
    title: string;
    description?: string;
    category: WorkflowNodeCategoryType;
    ports: WorkflowNodePort[];
    form?: FormDefinition;
    keywords?: string[];
    hidden?: boolean;
    documentation?: string;
    /**
     * Trigger activation type (only for trigger nodes)
     * - NONE: No activation needed (e.g., manual triggers, internal NocoDB triggers)
     * - WEBHOOK: Requires external webhook registration (e.g., GitHub, GitLab)
     * - CRON: Requires scheduling (e.g., cron triggers)
     */
    activationType?: TriggerActivationType;
    /**
     * Supported test modes for this trigger (array, can support multiple)
     * - SAMPLE_DATA: Use sample/mock data
     * - LISTEN_WEBHOOK: Listen for real webhook request
     * - TRIGGER_EVENT: User must trigger event externally
     *
     * If not specified, defaults to [SAMPLE_DATA]
     */
    testModes?: TriggerTestMode[];
    package?: {
        name: string;
        title: string;
        icon?: string;
    };
}
