/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.List;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.externaltools.AddRequest;
import org.nzbhydra.externaltools.ExternalTools;
import org.nzbhydra.notifications.IndexerDisabledNotificationEvent;
import org.nzbhydra.systemcontrol.SystemControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.annotation.Secured;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import sun.misc.Unsafe;

@RestController
public class DevEndpoint {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ExternalTools xdarr;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Value(value="${nzbhydra.devMode:false}")
    private boolean devMode;
    private static final Logger logger = LoggerFactory.getLogger(DevEndpoint.class);
    @Autowired
    private SystemControl systemControl;

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/dev/countDanglingIndexersearches"}, method={RequestMethod.GET})
    public BigInteger countDanglingIndexersearches() throws Exception {
        List resultList = this.entityManager.createNativeQuery("select count(*) from SEARCHRESULT x where x.INDEXERSEARCHENTITY not in (select y.id from INDEXERSEARCH y)").getResultList();
        return (BigInteger)resultList.get(0);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/dev/throwException"}, method={RequestMethod.GET})
    public BigInteger throwException() throws Exception {
        throw new RuntimeException("test");
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/dev/throwAccessDeniedException"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public BigInteger throwAccessDeniedException() throws Exception {
        throw new AccessDeniedException("test");
    }

    @Secured(value={"ROLE_ADMIN"})
    @Transactional
    @RequestMapping(value={"/dev/deleteDanglingIndexersearches"}, method={RequestMethod.GET})
    public String deleteDanglingIndexersearches() throws Exception {
        return "Deleted " + this.entityManager.createNativeQuery("delete from SEARCHRESULT where INDEXERSEARCHENTITY not in (select y.id from INDEXERSEARCH y)").executeUpdate() + " entries";
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/dev/testAddToSonarr"}, method={RequestMethod.GET})
    public String testAddToSonarr() throws Exception {
        if (!this.devMode) {
            return null;
        }
        AddRequest addRequest = new AddRequest();
        addRequest.setAddTorrent(false);
        addRequest.setAddUsenet(false);
        addRequest.setXdarrHost("http://localhost:9191");
        addRequest.setXdarrApiKey("51b42e76e902445d8ed3f068d698914a");
        addRequest.setNzbhydraHost("http://127.0.0.1:5076");
        this.xdarr.addNzbhydraAsIndexer(addRequest);
        return "OK";
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/dev/sendIndexerDisabledNotification"}, method={RequestMethod.GET})
    public void sendIndexerDisabledNotification() {
        this.applicationEventPublisher.publishEvent((Object)new IndexerDisabledNotificationEvent(((IndexerConfig)this.configProvider.getBaseConfig().getIndexers().get(0)).getName(), IndexerConfig.State.DISABLED_SYSTEM_TEMPORARY, "Some message generated by hydra"));
        this.applicationEventPublisher.publishEvent((Object)new IndexerDisabledNotificationEvent(((IndexerConfig)this.configProvider.getBaseConfig().getIndexers().get(0)).getName(), IndexerConfig.State.DISABLED_SYSTEM_TEMPORARY, "Some message generated by hydra2"));
        this.applicationEventPublisher.publishEvent((Object)new IndexerDisabledNotificationEvent(((IndexerConfig)this.configProvider.getBaseConfig().getIndexers().get(0)).getName(), IndexerConfig.State.DISABLED_SYSTEM_TEMPORARY, "Some message generated by hydra3"));
        this.applicationEventPublisher.publishEvent((Object)new IndexerDisabledNotificationEvent(((IndexerConfig)this.configProvider.getBaseConfig().getIndexers().get(0)).getName(), IndexerConfig.State.DISABLED_SYSTEM_TEMPORARY, "Some message generated by hydra4"));
        this.applicationEventPublisher.publishEvent((Object)new IndexerDisabledNotificationEvent(((IndexerConfig)this.configProvider.getBaseConfig().getIndexers().get(0)).getName(), IndexerConfig.State.DISABLED_SYSTEM_TEMPORARY, "Some message generated by hydra5"));
        this.applicationEventPublisher.publishEvent((Object)new IndexerDisabledNotificationEvent(((IndexerConfig)this.configProvider.getBaseConfig().getIndexers().get(0)).getName(), IndexerConfig.State.DISABLED_SYSTEM_TEMPORARY, "Some message generated by hydra6"));
        this.applicationEventPublisher.publishEvent((Object)new IndexerDisabledNotificationEvent(((IndexerConfig)this.configProvider.getBaseConfig().getIndexers().get(0)).getName(), IndexerConfig.State.DISABLED_SYSTEM_TEMPORARY, "Some message generated by hydra7"));
        this.applicationEventPublisher.publishEvent((Object)new IndexerDisabledNotificationEvent(((IndexerConfig)this.configProvider.getBaseConfig().getIndexers().get(0)).getName(), IndexerConfig.State.DISABLED_SYSTEM_TEMPORARY, "Some message generated by hydra8"));
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/dev/crash"}, method={RequestMethod.GET})
    public void crashHard() throws Exception {
        if (!this.devMode) {
            return;
        }
        Field f = Unsafe.class.getDeclaredField("theUnsafe");
        f.setAccessible(true);
        Unsafe unsafe = (Unsafe)f.get(null);
        unsafe.putAddress(0L, 0L);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/dev/shutDownForUpdate"}, method={RequestMethod.GET})
    public void shutDownForUpdate() throws Exception {
        if (!this.devMode) {
            return;
        }
        this.systemControl.exitWithReturnCode(11);
    }
}

