/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.auth;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.nzbhydra.auth.HydraWebAuthenticationDetails;
import org.nzbhydra.auth.LoginAndAccessAttemptService;
import org.nzbhydra.notifications.AuthFailureNotificationEvent;
import org.nzbhydra.web.SessionStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class AuthAndAccessEventHandler
extends AccessDeniedHandlerImpl {
    private static final Logger logger = LoggerFactory.getLogger(AuthAndAccessEventHandler.class);
    @Autowired
    private LoginAndAccessAttemptService attemptService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @EventListener
    public void onApplicationEvent(AuthenticationFailureBadCredentialsEvent event) {
        Object userName = event.getAuthentication().getPrincipal();
        String ip = (String)SessionStorage.IP.get();
        if (ip == null) {
            ip = ((HydraWebAuthenticationDetails)event.getAuthentication().getDetails()).getFilteredIp();
            SessionStorage.IP.set(ip);
        }
        logger.warn("Failed login with username {} from IP {}", userName, SessionStorage.IP.get());
        this.attemptService.accessFailed((String)SessionStorage.IP.get());
        this.applicationEventPublisher.publishEvent((Object)new AuthFailureNotificationEvent(ip, userName.toString()));
    }

    @EventListener
    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        String ip = (String)SessionStorage.IP.get();
        if (ip == null && event.getAuthentication().getDetails() instanceof HydraWebAuthenticationDetails) {
            ip = ((HydraWebAuthenticationDetails)event.getAuthentication().getDetails()).getFilteredIp();
            SessionStorage.IP.set(ip);
        }
        if (this.attemptService.wasUnsuccessfulBefore((String)SessionStorage.IP.get())) {
            try {
                User user = (User)event.getAuthentication().getPrincipal();
                logger.info("Successful login with username {} from IP {}. Removing previous unsuccessful events from block log", (Object)user.getUsername(), SessionStorage.IP.get());
            }
            catch (ClassCastException e) {
                logger.info("Successful login from IP {}. Removing previous unsuccessful events from block log", SessionStorage.IP.get());
            }
        }
        this.attemptService.accessSucceeded((String)SessionStorage.IP.get());
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        logger.warn("Access denied to IP {}: {}. Request path: {}. Parameters: {}", new Object[]{SessionStorage.IP.get(), accessDeniedException.getMessage(), request.getContextPath(), request.getParameterMap()});
        this.attemptService.accessFailed((String)SessionStorage.IP.get());
        super.handle(request, response, accessDeniedException);
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @RequestMapping(value={"unauthorised"})
    public String unAuthorised(HttpServletRequest request) throws Exception {
        return "hallo";
    }
}

