/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.auth;

import jakarta.servlet.http.HttpSession;
import java.security.Principal;
import org.nzbhydra.auth.UserInfosProvider;
import org.nzbhydra.web.BootstrappedDataTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AuthWeb {
    @Autowired
    private UserInfosProvider userInfos;

    @RequestMapping(value={"/internalapi/askadmin"}, method={RequestMethod.GET})
    @Secured(value={"ROLE_ADMIN"})
    public String askForAdmin(HttpSession session, Principal principal) {
        return "index";
    }

    @RequestMapping(value={"/internalapi/askpassword"}, method={RequestMethod.GET})
    public ResponseEntity<BootstrappedDataTO> askForPassword(HttpSession session, Principal principal) {
        if (SecurityContextHolder.getContext().getAuthentication() != null && !"AnonymousUser".equals(SecurityContextHolder.getContext().getAuthentication().getPrincipal())) {
            return ResponseEntity.ok((Object)this.userInfos.getUserInfos(principal));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)401).header("WWW-Authenticate", new String[]{"Basic realm=\"Ask for password\""})).body(null);
    }

    @RequestMapping(value={"/internalapi/userinfos"}, method={RequestMethod.GET}, produces={"application/json"})
    public BootstrappedDataTO userinfos(HttpSession session, Principal principal) {
        return this.userInfos.getUserInfos(principal);
    }
}

