/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.auth;

import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.logging.log4j.util.Strings;
import org.apache.tomcat.util.buf.MessageBytes;
import org.jetbrains.annotations.NotNull;
import org.nzbhydra.auth.HydraEmbeddedServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.stereotype.Component;

@Component
public class HydraEmbeddedServletContainer
implements WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> {
    private static final Logger logger = LoggerFactory.getLogger(HydraEmbeddedServletContainer.class);

    public void customize(ConfigurableServletWebServerFactory factory) {
        if (!(factory instanceof TomcatServletWebServerFactory)) {
            return;
        }
        TomcatServletWebServerFactory containerFactory = (TomcatServletWebServerFactory)factory;
        containerFactory.addContextValves(new Valve[]{new /* Unavailable Anonymous Inner Class!! */});
        containerFactory.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.setMapperContextRootRedirectEnabled(true)});
    }

    @NotNull
    static Result parseRequest(Request request) {
        int originalPort = -1;
        String forwardedPort = request.getHeader("X-Forwarded-Port");
        if (forwardedPort != null) {
            try {
                originalPort = request.getServerPort();
                request.setServerPort(Integer.parseInt(forwardedPort));
            }
            catch (NumberFormatException e) {
                logger.debug("ignoring forwarded port {}", (Object)forwardedPort);
            }
        }
        MessageBytes serverNameMB = request.getCoyoteRequest().serverName();
        String originalServerName = null;
        String forwardedHost = request.getHeader("X-Forwarded-Host");
        if (forwardedHost == null) {
            forwardedHost = request.getHeader("host");
        }
        if (Strings.isNotBlank((String)forwardedHost)) {
            int colonIndex;
            String[] split = forwardedHost.split("[ ,]");
            int n = colonIndex = (forwardedHost = split[0]).endsWith("]") ? -1 : forwardedHost.lastIndexOf(":");
            if (colonIndex > -1) {
                if (originalPort == -1) {
                    originalPort = request.getServerPort();
                }
                request.setServerPort(Integer.parseInt(forwardedHost.substring(colonIndex + 1)));
                forwardedHost = forwardedHost.substring(0, colonIndex);
            }
            originalServerName = serverNameMB.getString();
            serverNameMB.setString(forwardedHost);
        }
        Boolean originallySecure = null;
        String forwardedProto = request.getHeader("X-Forwarded-Proto");
        if (forwardedProto != null) {
            originallySecure = request.isSecure();
            request.setSecure(forwardedProto.equalsIgnoreCase("https"));
        }
        Result result = new Result(originalPort, forwardedPort, serverNameMB, originalServerName, forwardedHost, originallySecure);
        return result;
    }
}

