/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.auth;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.nzbhydra.logging.LoggingMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class ThreadLoggingFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ThreadLoggingFilter.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)true);
        log.info(LoggingMarkers.SERVER, "Request {} handled by thread {}", (Object)request.getRequestURI(), (Object)Thread.currentThread().getName());
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

