/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config;

import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigChangedEvent;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@DependsOn(value={"baseConfigHandler"})
@Component
public class ConfigProvider {
    @Autowired
    private BaseConfig baseConfig;

    @EventListener
    public void handleNewConfig(ConfigChangedEvent configChangedEvent) throws Exception {
        this.baseConfig = configChangedEvent.getNewConfig();
    }

    public BaseConfig getBaseConfig() {
        return this.baseConfig;
    }

    public IndexerConfig getIndexerByName(String name) {
        return this.baseConfig.getIndexers().stream().filter(x -> x.getName().equals(name)).findFirst().orElseThrow(() -> new RuntimeException("Unable to find indexer with name " + name));
    }
}

