/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.event.EventListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.nzbhydra.Jackson;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.MainConfig;
import org.nzbhydra.config.sensitive.SensitiveDataHandler;
import org.nzbhydra.logging.LoggingMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConfigReaderWriter {
    private static final Logger logger = LoggerFactory.getLogger(ConfigReaderWriter.class);
    public static final TypeReference<HashMap<String, Object>> MAP_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final RetryPolicy saveRetryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().withDelay(Duration.ofMillis(1000L)).withMaxRetries(3).handle(IOException.class)).build();
    private final SensitiveDataHandler sensitiveDataHandler = new SensitiveDataHandler();

    public void save(BaseConfig baseConfig) {
        try {
            BaseConfig copy = this.getCopy(baseConfig);
            this.sensitiveDataHandler.encryptSensitiveData((Object)copy);
            this.save(ConfigReaderWriter.buildConfigFileFile(), Jackson.YAML_MAPPER.writeValueAsString((Object)copy));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to save config", e);
        }
    }

    public void save(BaseConfig baseConfig, File targetFile) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            BaseConfig copy = this.getCopy(baseConfig);
            this.sensitiveDataHandler.encryptSensitiveData((Object)copy);
            this.save(targetFile, Jackson.YAML_MAPPER.writeValueAsString((Object)copy));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to save config", e);
        }
        finally {
            logger.debug(LoggingMarkers.PERFORMANCE, "Writing config took {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    public void save(Map<String, Object> baseConfig, File targetFile) {
        BaseConfig converted = (BaseConfig)Jackson.YAML_MAPPER.convertValue(baseConfig, BaseConfig.class);
        this.save(converted, targetFile);
    }

    public void save(Map<String, Object> baseConfig) {
        BaseConfig converted = (BaseConfig)Jackson.YAML_MAPPER.convertValue(baseConfig, BaseConfig.class);
        this.save(converted, ConfigReaderWriter.buildConfigFileFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save(File targetFile, String configAsYamlString) {
        if (NzbHydra.isNativeBuild()) {
            return;
        }
        ObjectMapper objectMapper = Jackson.YAML_MAPPER;
        synchronized (objectMapper) {
            Failsafe.with((Policy)this.saveRetryPolicy, (Policy[])new RetryPolicy[0]).onFailure((EventListener)new /* Unavailable Anonymous Inner Class!! */).run(() -> this.doWrite(targetFile, configAsYamlString));
        }
    }

    private void doWrite(File targetFile, String configAsYamlString) throws IOException {
        boolean deleted;
        if (Strings.isNullOrEmpty((String)configAsYamlString)) {
            logger.warn("Empty config string provided");
            throw new IOException("Empty YAML");
        }
        File tempFile = new File(targetFile.getParentFile(), targetFile.getName() + ".tmp");
        if (tempFile.exists() && !(deleted = tempFile.delete())) {
            logger.error("Error deleting previous temp file {}", (Object)tempFile);
            throw new RuntimeException("Error deleting previous temp file");
        }
        logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Writing to file {}", (Object)tempFile);
        try (FileOutputStream fos = new FileOutputStream(tempFile);){
            IOUtils.write((byte[])configAsYamlString.getBytes(Charsets.UTF_8), (OutputStream)fos);
            fos.flush();
            fos.getFD().sync();
        }
        try {
            fos = (BaseConfig)Jackson.YAML_MAPPER.readValue(tempFile, BaseConfig.class);
        }
        catch (IOException e) {
            logger.warn("Written target config file corrupted", (Throwable)e);
            throw e;
        }
        try {
            Files.move(tempFile.toPath(), targetFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.warn("Error moving temp file {} to target file {}", new Object[]{tempFile, targetFile, e});
            throw e;
        }
    }

    public boolean initializeIfNeeded(File yamlFile) throws IOException {
        if (NzbHydra.isNativeBuild()) {
            return false;
        }
        if (!yamlFile.exists()) {
            boolean bl;
            block10: {
                logger.info("No config file found at {}. Initializing with base config", (Object)yamlFile);
                InputStream stream = BaseConfig.class.getResource("/config/baseConfig.yml").openStream();
                try {
                    logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Copying YAML to {}", (Object)yamlFile);
                    yamlFile.getParentFile().mkdirs();
                    Files.copy(stream, yamlFile.toPath(), new CopyOption[0]);
                    bl = true;
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error("Unable to initialize config file", (Throwable)e);
                        throw e;
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    public void validateExistingConfig() {
        if (NzbHydra.isNativeBuild()) {
            return;
        }
        File configFile = ConfigReaderWriter.buildConfigFileFile();
        if (!configFile.exists()) {
            logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Config file {} doesn't exist. Nothing to validate", (Object)configFile);
            return;
        }
        try {
            Map map = (Map)Jackson.YAML_MAPPER.readValue(configFile, MAP_TYPE_REFERENCE);
            if (!map.containsKey("main") || !((Map)map.get("main")).containsKey("configVersion")) {
                throw new IOException("Unable to find main config or config version in config file");
            }
            int foundConfigVersion = (Integer)((Map)map.get("main")).get("configVersion");
            if (foundConfigVersion < new MainConfig().getConfigVersion()) {
                return;
            }
            Jackson.YAML_MAPPER.readValue(configFile, BaseConfig.class);
        }
        catch (IOException e) {
            logger.warn("Error while reading YAML from {}", (Object)configFile);
            File tempFile = new File(configFile.getAbsolutePath() + ".bak");
            logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Using temporary file {}", (Object)tempFile);
            if (!tempFile.exists()) {
                logger.error("Config file corrupted: {}", (Object)e.getMessage());
                throw new RuntimeException("Config file " + configFile.getAbsolutePath() + " corrupted. If you find a ZIP in your backup folder restore it from there. Otherwise you'll have to delete the file and start over. Please contact the developer when you have it running.");
            }
            logger.debug(LoggingMarkers.CONFIG_READ_WRITE, "Temporary file {} exists", (Object)tempFile);
            try {
                Jackson.YAML_MAPPER.readValue(tempFile, BaseConfig.class);
            }
            catch (IOException e2) {
                logger.error("Config backup file corrupted: {}", (Object)e.getMessage());
                throw new RuntimeException("Config file " + configFile.getAbsolutePath() + " and its backup are corrupted. If you find a ZIP in your backup folder restore it from there. Otherwise you'll have to delete the file and start over. Please contact the developer when you have it running.");
            }
            logger.warn("Invalid config file found. Will try to restore from backup. Error message: {}", (Object)e.getMessage());
            try {
                Files.copy(tempFile.toPath(), configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e1) {
                throw new RuntimeException("Error while restoring config file. You'll have to manually copy " + tempFile.getAbsolutePath() + " to " + configFile.getAbsolutePath());
            }
            logger.warn("Restored config file from backup");
        }
    }

    public BaseConfig loadSavedConfig() throws IOException {
        File configFile = ConfigReaderWriter.buildConfigFileFile();
        if (configFile.exists()) {
            BaseConfig baseConfig = (BaseConfig)Jackson.YAML_MAPPER.readValue(configFile, BaseConfig.class);
            this.sensitiveDataHandler.decryptSensitiveData((Object)baseConfig);
            return baseConfig;
        }
        return this.originalConfig();
    }

    public Map<String, Object> loadSavedConfigAsMap() throws IOException {
        return (Map)Jackson.YAML_MAPPER.readValue(ConfigReaderWriter.buildConfigFileFile(), MAP_TYPE_REFERENCE);
    }

    public static File buildConfigFileFile() {
        return new File(NzbHydra.getDataFolder(), "nzbhydra.yml");
    }

    public BaseConfig originalConfig() throws IOException {
        String applicationYmlContent;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(BaseConfig.class.getResource("/config/baseConfig.yml").openStream()));){
            applicationYmlContent = reader.lines().collect(Collectors.joining("\n"));
        }
        return (BaseConfig)Jackson.YAML_MAPPER.readValue(applicationYmlContent, BaseConfig.class);
    }

    public BaseConfig getCopy(BaseConfig toCopy) {
        try {
            return (BaseConfig)Jackson.YAML_MAPPER.readValue(Jackson.YAML_MAPPER.writeValueAsString((Object)toCopy), BaseConfig.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy config", e);
        }
    }

    public String getAsYamlString(BaseConfig baseConfig) {
        try {
            return Jackson.YAML_WRITER.writeValueAsString((Object)baseConfig);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error while deserializing config", e);
        }
    }
}

