/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.indexers.IndexerEntity;
import org.nzbhydra.indexers.IndexerRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IndexerConfigService {
    private static final Logger logger = LoggerFactory.getLogger(IndexerConfigService.class);
    @Autowired
    private IndexerRepository indexerRepository;
    @Autowired
    private ConfigProvider configProvider;

    @Transactional
    public void handleIndexerConfigChanges(BaseConfig newConfig) {
        this.handleRenamedIndexers(newConfig);
        this.handleDeletedIndexers(newConfig);
    }

    private void handleRenamedIndexers(BaseConfig newConfig) {
        HashSet loggedSameNameAndApiKey = new HashSet();
        for (IndexerConfig newIndexer : newConfig.getIndexers()) {
            Optional<IndexerConfig> sameOldIndexer;
            boolean alreadyExistedBefore = this.configProvider.getBaseConfig().getIndexers().stream().filter(x -> x != newIndexer).anyMatch(x -> x.getName().equals(newIndexer.getName()));
            if (alreadyExistedBefore || !(sameOldIndexer = this.configProvider.getBaseConfig().getIndexers().stream().filter(x -> !x.getName().equals(newIndexer.getName())).filter(x -> IndexerConfig.isIndexerEquals((IndexerConfig)newIndexer, (IndexerConfig)x)).findFirst()).isPresent()) continue;
            logger.info("Indexer was renamed from {} to {}", (Object)sameOldIndexer.get().getName(), (Object)newIndexer.getName());
            try {
                IndexerEntity indexerEntity = this.indexerRepository.findByName(sameOldIndexer.get().getName());
                if (indexerEntity == null) continue;
                indexerEntity.setName(newIndexer.getName());
                this.indexerRepository.save(indexerEntity);
            }
            catch (Exception e) {
                logger.error("Error while renaming indexer", (Throwable)e);
            }
        }
    }

    private void handleDeletedIndexers(BaseConfig newConfig) {
        List newIndexerNames = newConfig.getIndexers().stream().map(IndexerConfig::getName).collect(Collectors.toList());
        if (newIndexerNames.isEmpty()) {
            List allIndexers = this.indexerRepository.findAll();
            for (IndexerEntity indexerEntity : allIndexers) {
                logger.info("Deleting indexer {} and its related data because it was removed from the config", (Object)indexerEntity.getName());
            }
            this.indexerRepository.deleteAllNative();
        } else {
            Collection indexersToDelete = this.indexerRepository.findByNameNotIn(newIndexerNames);
            for (IndexerEntity indexerEntity : indexersToDelete) {
                logger.info("Deleting indexer {} and its related data because it was removed from the config", (Object)indexerEntity.getName());
                this.indexerRepository.deleteByIdNative(indexerEntity.getId());
            }
        }
    }
}

