/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.migration;

import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nzbhydra.config.MainConfig;
import org.nzbhydra.config.migration.ConfigMigrationStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ConfigMigration {
    private static final Logger logger = LoggerFactory.getLogger(ConfigMigration.class);
    private static final DefaultPrettyPrinter defaultPrettyPrinter;
    protected List<ConfigMigrationStep> steps = ConfigMigration.getMigrationSteps();
    protected int expectedConfigVersion = new MainConfig().getConfigVersion();

    public Map<String, Object> migrate(Map<String, Object> map) {
        int foundConfigVersion = (Integer)((Map)map.get("main")).get("configVersion");
        if (foundConfigVersion > this.expectedConfigVersion) {
            throw new RuntimeException("The existing config file has version " + foundConfigVersion + " but the program expects version " + this.expectedConfigVersion + ". You might be trying to use an older code base with settings created by a newer version of the program");
        }
        for (ConfigMigrationStep step : this.steps) {
            if (foundConfigVersion <= step.forVersion()) {
                logger.info("Migrating config from version {}", (Object)step.forVersion());
                map = step.migrate(map);
                foundConfigVersion = step.forVersion() + 1;
            }
            ((Map)map.get("main")).put("configVersion", foundConfigVersion);
        }
        if (foundConfigVersion != this.expectedConfigVersion) {
            throw new RuntimeException(String.format("Expected the config after migration to be at version %d but it's at version %d", this.expectedConfigVersion, foundConfigVersion));
        }
        return map;
    }

    protected static List<ConfigMigrationStep> getMigrationSteps() {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(ConfigMigrationStep.class));
        Set candidates = provider.findCandidateComponents(ConfigMigrationStep.class.getPackage().getName());
        ArrayList<ConfigMigrationStep> steps = new ArrayList<ConfigMigrationStep>();
        for (BeanDefinition beanDefinition : candidates) {
            try {
                ConfigMigrationStep instance = (ConfigMigrationStep)Class.forName(beanDefinition.getBeanClassName()).getConstructor(new Class[0]).newInstance(new Object[0]);
                steps.add(instance);
            }
            catch (Exception e) {
                logger.error("Unable to instantiate migration step from class {}", (Object)beanDefinition.getBeanClassName(), (Object)e);
            }
        }
        Collections.sort(steps);
        return steps;
    }

    static {
        DefaultIndenter indenter = new DefaultIndenter("    ", DefaultIndenter.SYS_LF);
        defaultPrettyPrinter = new DefaultPrettyPrinter();
        defaultPrettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        defaultPrettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
    }
}

