/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.migration;

import java.util.List;
import java.util.Map;
import org.nzbhydra.config.migration.ConfigMigration;
import org.nzbhydra.config.migration.ConfigMigrationStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class ConfigMigrationStep021to022
implements ConfigMigrationStep {
    private static final Logger logger = LoggerFactory.getLogger(ConfigMigration.class);
    private static final String BCRYPT_PREFIX = "{bcrypt}";
    private static final String NOOP_PREFIX = "{noop}";
    private final BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    public int forVersion() {
        return 21;
    }

    public Map<String, Object> migrate(Map<String, Object> toMigrate) {
        List users;
        logger.info("Migrating user passwords from plaintext to BCrypt encryption");
        Map authConfig = this.getFromMap(toMigrate, "auth");
        if (authConfig != null && (users = this.getListFromMap(authConfig, "users")) != null) {
            for (Map user : users) {
                String migratedPassword;
                String password = (String)user.get("password");
                if (password == null || password.isEmpty() || (migratedPassword = this.migratePassword(password, (String)user.get("username"))).equals(password)) continue;
                user.put("password", migratedPassword);
            }
        }
        return toMigrate;
    }

    private String migratePassword(String password, String username) {
        if (password.startsWith(BCRYPT_PREFIX)) {
            logger.debug("Password for user '{}' is already BCrypt encrypted", (Object)username);
            return password;
        }
        if (password.startsWith(NOOP_PREFIX)) {
            String plainPassword = password.substring(NOOP_PREFIX.length());
            String hashedPassword = this.passwordEncoder.encode((CharSequence)plainPassword);
            logger.info("Migrated {noop} password to BCrypt for user '{}'", (Object)username);
            return BCRYPT_PREFIX + hashedPassword;
        }
        if (!password.startsWith("{")) {
            String hashedPassword = this.passwordEncoder.encode((CharSequence)password);
            logger.info("Migrated plaintext password to BCrypt for user '{}'", (Object)username);
            return BCRYPT_PREFIX + hashedPassword;
        }
        logger.debug("Password for user '{}' has unknown format, leaving unchanged", (Object)username);
        return password;
    }
}

