/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.safeconfig;

import java.util.List;
import java.util.stream.Collectors;
import org.nzbhydra.config.downloading.DownloadingConfig;
import org.nzbhydra.config.downloading.FileDownloadAccessType;
import org.nzbhydra.config.safeconfig.SafeDownloaderConfig;

public class SafeDownloadingConfig {
    private final String saveTorrentsTo;
    private final String saveNzbsTo;
    private final boolean sendMagnetLinks;
    private final List<SafeDownloaderConfig> downloaders;
    private final boolean showDownloaderStatus;
    private final String primaryDownloader;
    private final FileDownloadAccessType fileDownloadAccessType;

    public SafeDownloadingConfig(DownloadingConfig downloadingConfig) {
        this.saveTorrentsTo = downloadingConfig.getSaveTorrentsTo().orElse(null);
        this.saveNzbsTo = downloadingConfig.getSaveNzbsTo().orElse(null);
        this.sendMagnetLinks = downloadingConfig.isSendMagnetLinks();
        this.showDownloaderStatus = downloadingConfig.isShowDownloaderStatus();
        this.downloaders = downloadingConfig.getDownloaders().stream().map(SafeDownloaderConfig::new).collect(Collectors.toList());
        this.primaryDownloader = downloadingConfig.getPrimaryDownloader();
        this.fileDownloadAccessType = downloadingConfig.getNzbAccessType();
    }

    public String getSaveTorrentsTo() {
        return this.saveTorrentsTo;
    }

    public String getSaveNzbsTo() {
        return this.saveNzbsTo;
    }

    public boolean isSendMagnetLinks() {
        return this.sendMagnetLinks;
    }

    public List<SafeDownloaderConfig> getDownloaders() {
        return this.downloaders;
    }

    public boolean isShowDownloaderStatus() {
        return this.showDownloaderStatus;
    }

    public String getPrimaryDownloader() {
        return this.primaryDownloader;
    }

    public FileDownloadAccessType getFileDownloadAccessType() {
        return this.fileDownloadAccessType;
    }
}

