/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.safeconfig;

import java.util.List;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.springnative.ReflectionMarker;

@ReflectionMarker
public class SafeIndexerConfig {
    private String name;
    private boolean preselect;
    private List<String> categories;
    private boolean showOnSearch;
    private String enabledForSearchSource;
    private String searchModuleType;
    private String color;
    private String vipExpirationDate;

    public SafeIndexerConfig(IndexerConfig indexerConfig, BaseConfig baseConfig) {
        this.name = indexerConfig.getName();
        this.preselect = indexerConfig.isPreselect();
        this.categories = indexerConfig.getEnabledCategories();
        this.showOnSearch = indexerConfig.isEligibleForInternalSearch();
        this.enabledForSearchSource = indexerConfig.getEnabledForSearchSource().name();
        this.searchModuleType = indexerConfig.getSearchModuleType().name();
        this.color = indexerConfig.getColor();
        this.vipExpirationDate = indexerConfig.getVipExpirationDate();
    }

    public String getName() {
        return this.name;
    }

    public boolean isPreselect() {
        return this.preselect;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public boolean isShowOnSearch() {
        return this.showOnSearch;
    }

    public String getEnabledForSearchSource() {
        return this.enabledForSearchSource;
    }

    public String getSearchModuleType() {
        return this.searchModuleType;
    }

    public String getColor() {
        return this.color;
    }

    public String getVipExpirationDate() {
        return this.vipExpirationDate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPreselect(boolean preselect) {
        this.preselect = preselect;
    }

    public void setCategories(List<String> categories) {
        this.categories = categories;
    }

    public void setShowOnSearch(boolean showOnSearch) {
        this.showOnSearch = showOnSearch;
    }

    public void setEnabledForSearchSource(String enabledForSearchSource) {
        this.enabledForSearchSource = enabledForSearchSource;
    }

    public void setSearchModuleType(String searchModuleType) {
        this.searchModuleType = searchModuleType;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setVipExpirationDate(String vipExpirationDate) {
        this.vipExpirationDate = vipExpirationDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SafeIndexerConfig)) {
            return false;
        }
        SafeIndexerConfig other = (SafeIndexerConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isPreselect() != other.isPreselect()) {
            return false;
        }
        if (this.isShowOnSearch() != other.isShowOnSearch()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List this$categories = this.getCategories();
        List other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !((Object)this$categories).equals(other$categories)) {
            return false;
        }
        String this$enabledForSearchSource = this.getEnabledForSearchSource();
        String other$enabledForSearchSource = other.getEnabledForSearchSource();
        if (this$enabledForSearchSource == null ? other$enabledForSearchSource != null : !this$enabledForSearchSource.equals(other$enabledForSearchSource)) {
            return false;
        }
        String this$searchModuleType = this.getSearchModuleType();
        String other$searchModuleType = other.getSearchModuleType();
        if (this$searchModuleType == null ? other$searchModuleType != null : !this$searchModuleType.equals(other$searchModuleType)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        String this$vipExpirationDate = this.getVipExpirationDate();
        String other$vipExpirationDate = other.getVipExpirationDate();
        return !(this$vipExpirationDate == null ? other$vipExpirationDate != null : !this$vipExpirationDate.equals(other$vipExpirationDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SafeIndexerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreselect() ? 79 : 97);
        result = result * 59 + (this.isShowOnSearch() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : ((Object)$categories).hashCode());
        String $enabledForSearchSource = this.getEnabledForSearchSource();
        result = result * 59 + ($enabledForSearchSource == null ? 43 : $enabledForSearchSource.hashCode());
        String $searchModuleType = this.getSearchModuleType();
        result = result * 59 + ($searchModuleType == null ? 43 : $searchModuleType.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        String $vipExpirationDate = this.getVipExpirationDate();
        result = result * 59 + ($vipExpirationDate == null ? 43 : $vipExpirationDate.hashCode());
        return result;
    }

    public String toString() {
        return "SafeIndexerConfig(name=" + this.getName() + ", preselect=" + this.isPreselect() + ", categories=" + String.valueOf(this.getCategories()) + ", showOnSearch=" + this.isShowOnSearch() + ", enabledForSearchSource=" + this.getEnabledForSearchSource() + ", searchModuleType=" + this.getSearchModuleType() + ", color=" + this.getColor() + ", vipExpirationDate=" + this.getVipExpirationDate() + ")";
    }
}

