/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.safeconfig;

import java.util.List;
import org.nzbhydra.config.SearchingConfig;

public class SafeSearchingConfig {
    private final boolean ignoreTemporarilyDisabled;
    private final Integer coverSize;
    private final Integer maxAge;
    private final boolean showQuickFilterButtons;
    private final boolean alwaysShowQuickFilterButtons;
    private final List<String> customQuickFilterButtons;
    private final List<String> preselectQuickFilterButtons;
    private final int loadLimitInternal;

    public SafeSearchingConfig(SearchingConfig searchingConfig) {
        this.coverSize = searchingConfig.getCoverSize();
        this.showQuickFilterButtons = searchingConfig.isShowQuickFilterButtons();
        this.alwaysShowQuickFilterButtons = searchingConfig.isAlwaysShowQuickFilterButtons();
        this.customQuickFilterButtons = searchingConfig.getCustomQuickFilterButtons();
        this.preselectQuickFilterButtons = searchingConfig.getPreselectQuickFilterButtons();
        this.maxAge = searchingConfig.getMaxAge().orElse(null);
        this.ignoreTemporarilyDisabled = searchingConfig.isIgnoreTemporarilyDisabled();
        this.loadLimitInternal = searchingConfig.getLoadLimitInternal();
    }

    public boolean isIgnoreTemporarilyDisabled() {
        return this.ignoreTemporarilyDisabled;
    }

    public Integer getCoverSize() {
        return this.coverSize;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public boolean isShowQuickFilterButtons() {
        return this.showQuickFilterButtons;
    }

    public boolean isAlwaysShowQuickFilterButtons() {
        return this.alwaysShowQuickFilterButtons;
    }

    public List<String> getCustomQuickFilterButtons() {
        return this.customQuickFilterButtons;
    }

    public List<String> getPreselectQuickFilterButtons() {
        return this.preselectQuickFilterButtons;
    }

    public int getLoadLimitInternal() {
        return this.loadLimitInternal;
    }
}

