/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.sensitive;

import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.List;
import org.nzbhydra.config.sensitive.SensitiveData;
import org.nzbhydra.config.sensitive.SensitiveDataObfuscator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SensitiveDataHandler {
    private static final Logger logger = LoggerFactory.getLogger(SensitiveDataHandler.class);

    public void encryptSensitiveData(Object obj) {
        if (obj == null) {
            return;
        }
        this.processObject(obj, true);
    }

    public void decryptSensitiveData(Object obj) {
        if (obj == null) {
            return;
        }
        this.processObject(obj, false);
    }

    private void processObject(Object obj, boolean encrypt) {
        if (obj == null) {
            return;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isPrimitive() || clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Boolean.class || clazz == Double.class || clazz == Float.class || clazz.isEnum()) {
            return;
        }
        String className = clazz.getName();
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("com.sun.")) {
            if (obj instanceof List) {
                List list = (List)obj;
                for (Object item : list) {
                    this.processObject(item, encrypt);
                }
            }
            return;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object item : list) {
                this.processObject(item, encrypt);
            }
            return;
        }
        while (clazz != null && clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    String fieldName;
                    Object fieldValue;
                    String value;
                    if (field.isSynthetic()) continue;
                    try {
                        field.setAccessible(true);
                    }
                    catch (InaccessibleObjectException e) {
                        continue;
                    }
                    if (field.isAnnotationPresent(SensitiveData.class) && field.getType() == String.class && (value = (String)field.get(obj)) != null) {
                        String processedValue = encrypt ? SensitiveDataObfuscator.encrypt((String)value) : SensitiveDataObfuscator.decrypt((String)value);
                        field.set(obj, processedValue);
                    }
                    if ((fieldValue = field.get(obj)) == null || field.getType().isPrimitive() || field.getType().equals(String.class) || (fieldName = field.getName()).equals("parent") || fieldName.equals("this$0")) continue;
                    this.processObject(fieldValue, encrypt);
                }
                catch (Exception e) {
                    logger.debug("Failed to process field {} in class {}", new Object[]{field.getName(), clazz.getName(), e});
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    public List<String> listSensitiveFields(Object obj) {
        ArrayList<String> sensitiveFields = new ArrayList<String>();
        if (obj == null) {
            return sensitiveFields;
        }
        this.findSensitiveFields(obj, "", sensitiveFields);
        return sensitiveFields;
    }

    private void findSensitiveFields(Object obj, String path, List<String> sensitiveFields) {
        if (obj == null) {
            return;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isPrimitive() || clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Boolean.class || clazz == Double.class || clazz == Float.class || clazz.isEnum()) {
            return;
        }
        String className = clazz.getName();
        if (className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("com.sun.")) {
            if (obj instanceof List) {
                List list = (List)obj;
                for (int i = 0; i < list.size(); ++i) {
                    this.findSensitiveFields(list.get(i), path + "[" + i + "]", sensitiveFields);
                }
            }
            return;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            for (int i = 0; i < list.size(); ++i) {
                this.findSensitiveFields(list.get(i), path + "[" + i + "]", sensitiveFields);
            }
            return;
        }
        while (clazz != null && clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    String fieldName;
                    Object fieldValue;
                    Object value;
                    String fieldPath;
                    if (field.isSynthetic()) continue;
                    try {
                        field.setAccessible(true);
                    }
                    catch (InaccessibleObjectException e) {
                        continue;
                    }
                    String string = fieldPath = path.isEmpty() ? field.getName() : path + "." + field.getName();
                    if (field.isAnnotationPresent(SensitiveData.class) && (value = field.get(obj)) != null) {
                        sensitiveFields.add(fieldPath + " = " + (value instanceof String ? "[SENSITIVE]" : value.getClass().getSimpleName()));
                    }
                    if ((fieldValue = field.get(obj)) == null || field.getType().isPrimitive() || field.getType().equals(String.class) || (fieldName = field.getName()).equals("parent") || fieldName.equals("this$0")) continue;
                    this.findSensitiveFields(fieldValue, fieldPath, sensitiveFields);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            clazz = clazz.getSuperclass();
        }
    }
}

