/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import java.util.ArrayList;
import java.util.Collections;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.downloading.DownloaderConfig;
import org.nzbhydra.config.downloading.NzbAddingType;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.config.validation.ConfigValidator;
import org.nzbhydra.downloading.DownloaderType;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DownloaderConfigValidator
implements ConfigValidator<DownloaderConfig> {
    public boolean doesValidate(Class<?> clazz) {
        return clazz == DownloaderConfig.class;
    }

    public ConfigValidationResult validateConfig(BaseConfig oldBaseConfig, BaseConfig newBaseConfig, DownloaderConfig newConfig) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (DownloaderConfigValidator.isEnabledWithoutSendLink((BaseConfig)newBaseConfig, (String)"nzbs.in", (DownloaderConfig)newConfig)) {
            warnings.add("nzbs.in forbids NZBHydra to download NZBs directly. The NZB adding type \"Send link\" will automatically be used for this indexer.");
        }
        if (DownloaderConfigValidator.isEnabledWithoutSendLink((BaseConfig)newBaseConfig, (String)"omgwtfnzbs", (DownloaderConfig)newConfig)) {
            warnings.add("omgwtfnzbs forbids NZBHydra to download NZBs directly. The NZB adding type \"Send link\" will automatically be used for this indexer.");
        }
        if (DownloaderConfigValidator.isEnabledWithoutSendLink((BaseConfig)newBaseConfig, (String)"nzbfinder", (DownloaderConfig)newConfig)) {
            warnings.add("NZB Finder forbids NZBHydra to download NZBs directly. The NZB adding type \"Send link\" will automatically be used for this indexer.");
        }
        return new ConfigValidationResult(true, false, Collections.emptyList(), warnings);
    }

    private static boolean isEnabledWithoutSendLink(BaseConfig newBaseConfig, String hostContains, DownloaderConfig newDownloaderConfig) {
        if (!newDownloaderConfig.isEnabled()) {
            return false;
        }
        if (newDownloaderConfig.getDownloaderType() == DownloaderType.TORBOX) {
            return false;
        }
        boolean isIndexerEnabled = newBaseConfig.getIndexers().stream().anyMatch(x -> x.getHost().toLowerCase().contains(hostContains) && x.getState() == IndexerConfig.State.ENABLED);
        return isIndexerEnabled && newDownloaderConfig.getNzbAddingType() != NzbAddingType.SEND_LINK;
    }
}

