/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import java.util.Arrays;
import java.util.Iterator;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.LoggingConfig;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.config.validation.ConfigValidationTools;
import org.nzbhydra.config.validation.ConfigValidator;
import org.nzbhydra.logging.LoggingMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoggingConfigValidator
implements ConfigValidator<LoggingConfig> {
    private static final Logger logger = LoggerFactory.getLogger(LoggingConfigValidator.class);

    public boolean doesValidate(Class<?> clazz) {
        return clazz == LoggingConfig.class;
    }

    public ConfigValidationResult validateConfig(BaseConfig oldBaseConfig, BaseConfig newBaseConfig, LoggingConfig newConfig) {
        ConfigValidationResult result = new ConfigValidationResult();
        result.setRestartNeeded(ConfigValidationTools.isRestartNeeded((Object)oldBaseConfig.getMain().getLogging(), (Object)newConfig));
        if (newBaseConfig.getMain().getLogging().getMarkersToLog().size() > 3) {
            result.getWarningMessages().add("You have more than 3 logging markers enabled. This is very rarely useful. Please make sure that this is actually needed. When creating debug infos please only enable those markers requested by the developer.");
        }
        return result;
    }

    public LoggingConfig prepareForSaving(BaseConfig oldBaseConfig, LoggingConfig newConfig) {
        Iterator iterator = newConfig.getMarkersToLog().iterator();
        while (iterator.hasNext()) {
            String marker = (String)iterator.next();
            if (!Arrays.stream(LoggingMarkers.class.getDeclaredFields()).noneMatch(x -> x.getName().equals(marker))) continue;
            logger.info("Removing logging marker that doesn't exist anymore.");
            iterator.remove();
        }
        return newConfig;
    }
}

