/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.config.validation;

import java.util.ArrayList;
import joptsimple.internal.Strings;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.NotificationConfig;
import org.nzbhydra.config.validation.ConfigValidationResult;
import org.nzbhydra.config.validation.ConfigValidator;
import org.springframework.stereotype.Component;

@Component
public class NotificationConfigValidator
implements ConfigValidator<NotificationConfig> {
    public boolean doesValidate(Class<?> clazz) {
        return clazz == NotificationConfig.class;
    }

    public ConfigValidationResult validateConfig(BaseConfig oldBaseConfig, BaseConfig newBaseConfig, NotificationConfig newConfig) {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        if (newConfig.getEntries().stream().anyMatch(x -> Strings.isNullOrEmpty((String)x.getAppriseUrls()))) {
            errors.add("Make sure all notification entries contain a URL");
        }
        boolean appriseUrlSet = !Strings.isNullOrEmpty((String)newConfig.getAppriseApiUrl());
        boolean anyEntries = newConfig.getEntries().isEmpty();
        if (anyEntries && !appriseUrlSet) {
            warnings.add("No notifications will be sent unless the Apprise API URL is configured.");
        }
        return new ConfigValidationResult(true, false, errors, warnings);
    }
}

