/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.debuginfos;

import com.google.common.base.Joiner;
import com.google.common.collect.HashMultimap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.NzbHydra;
import org.nzbhydra.config.BaseConfigHandler;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.debuginfos.DebugInfosProvider;
import org.nzbhydra.debuginfos.DebugInfosWeb;
import org.nzbhydra.debuginfos.FileIoUploader;
import org.nzbhydra.logging.LogContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.web.mappings.MappingsEndpoint;
import org.springframework.boot.actuate.web.mappings.servlet.RequestMappingConditionsDescription;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DebugInfosWeb {
    private static final Pattern NIO_THREAD_PATTERN = Pattern.compile("http-nio-[\\d\\.]*-\\d{1,6}-exec-(\\d)");
    @Autowired
    private LogContentProvider logContentProvider;
    @Autowired
    private DebugInfosProvider debugInfos;
    @Autowired
    private MappingsEndpoint mappingsEndpoint;
    @Autowired
    private ConfigProvider configProvider;
    @Autowired
    private BaseConfigHandler baseConfigHandler;
    private static final Logger logger = LoggerFactory.getLogger(DebugInfosWeb.class);

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/currentlogfile"}, method={RequestMethod.GET}, produces={"text/plain"})
    public FileSystemResource getCurrentLogFile() {
        return new FileSystemResource(this.logContentProvider.getCurrentLogfile(false));
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/downloadlog"}, method={RequestMethod.GET}, produces={"text/plain"})
    public FileSystemResource downloadLogFile(@RequestParam String logfilename) throws IOException {
        File file = new File(new File(NzbHydra.getDataFolder(), "logs"), logfilename);
        if (!file.getCanonicalFile().toPath().startsWith(new File(NzbHydra.getDataFolder()).getCanonicalFile().toPath())) {
            throw new IOException("Log file not in data folder");
        }
        return new FileSystemResource(file);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/logfilenames"}, method={RequestMethod.GET})
    public List<String> getLogFilenames() {
        return this.logContentProvider.getLogFileNames();
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/jsonlogs"}, method={RequestMethod.GET})
    public ResponseEntity<LogContentProvider.JsonLogResponse> logsAsJson(@RequestParam(required=false) Integer offset, @RequestParam(required=false) Integer limit) {
        try {
            LogContentProvider.JsonLogResponse jsonObjects = this.logContentProvider.getLogsAsJsonLines(offset == null ? 0 : offset, limit == null ? 500 : limit);
            return ResponseEntity.ok((Object)jsonObjects);
        }
        catch (IOException e) {
            logger.error("Error while getting log file content", (Throwable)e);
            return ResponseEntity.status((int)500).build();
        }
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/createAndProvideZipAsBytes"}, produces={"application/zip"}, method={RequestMethod.GET})
    public byte[] createAndProvideDebugInfos() throws IOException {
        try {
            return this.debugInfos.getDebugInfosAsZip();
        }
        catch (IOException e) {
            logger.error("Error while getting debug infos", (Throwable)e);
            throw e;
        }
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/createAndUploadDebugInfos"}, produces={"text/plain"}, method={RequestMethod.GET})
    public String createAndUploadDebugInfos() throws IOException {
        File debugInfosZipFile;
        try {
            debugInfosZipFile = this.debugInfos.createDebugInfosZipFile();
        }
        catch (IOException e) {
            logger.error("Error while creating", (Throwable)e);
            throw e;
        }
        try {
            String e = FileIoUploader.upload((File)debugInfosZipFile);
            return e;
        }
        catch (Exception e) {
            logger.error("Error while creating or uploading debug infos", (Throwable)e);
            throw e;
        }
        finally {
            debugInfosZipFile.delete();
        }
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/threadCpuUsage"}, produces={"application/json"}, method={RequestMethod.GET})
    public List<ThreadCpuUsageChartData> getThreadCpuUsageChartData() throws IOException {
        HashMap map = new HashMap();
        ArrayList<ThreadCpuUsageChartData> list = new ArrayList<ThreadCpuUsageChartData>();
        List chartData = this.debugInfos.getThreadCpuUsageChartData();
        for (DebugInfosProvider.TimeAndThreadCpuUsages timeAndThreadCpuUsages : chartData) {
            for (DebugInfosProvider.ThreadCpuUsage threadCpuUsage : timeAndThreadCpuUsages.getThreadCpuUsages()) {
                if (!map.containsKey(threadCpuUsage.getThreadName())) {
                    map.put(threadCpuUsage.getThreadName(), new ArrayList());
                }
                ((List)map.get(threadCpuUsage.getThreadName())).add(new TimeAndValue(timeAndThreadCpuUsages.getTime(), (float)threadCpuUsage.getCpuUsage()));
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((List)entry.getValue()).stream().allMatch(x -> x.getValue() < 1.0f)) continue;
            list.add(new ThreadCpuUsageChartData((String)entry.getKey(), ((List)entry.getValue()).stream().sorted(Comparator.comparing(x -> x.time)).collect(Collectors.toList())));
        }
        return list;
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/logThreadDump"})
    public String logThreadDump() {
        return this.debugInfos.logThreadDump();
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/executesqlquery"}, method={RequestMethod.POST})
    public GenericResponse executeSqlQuery(@RequestBody String sql) throws IOException {
        try {
            return GenericResponse.ok((String)this.debugInfos.executeSqlQuery(sql));
        }
        catch (IOException e) {
            logger.error("Error while executing SQL", (Throwable)e);
            return GenericResponse.notOk((String)("Error while executing SQL " + e.getMessage()));
        }
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/executesqlupdate"}, method={RequestMethod.POST})
    public GenericResponse executeSqlUpdate(@RequestBody String sql) throws IOException {
        try {
            return GenericResponse.ok((String)this.debugInfos.executeSqlUpdate(sql));
        }
        catch (Exception e) {
            logger.error("Error while executing SQL", (Throwable)e);
            return GenericResponse.notOk((String)("Error while executing SQL " + e.getMessage()));
        }
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/endpoints"}, method={RequestMethod.GET})
    public ResponseEntity<List<PrefixAndEndpoint>> getEndpoints() {
        List<RequestMappingConditionsDescription> conditionsDescriptions = ((List)((Map)((MappingsEndpoint.ContextMappingsDescriptor)this.mappingsEndpoint.mappings().getContexts().get("NZBHydra2")).getMappings().get("dispatcherServlets")).get("dispatcherServlet")).stream().filter(x1 -> x1.getHandler().contains("nzbhydra")).map(x -> x.getDetails().getRequestMappingConditions()).toList();
        ArrayList<PrefixAndEndpoint> prefixAndEndpoints = new ArrayList<PrefixAndEndpoint>();
        HashMultimap endpoints = HashMultimap.create();
        for (RequestMappingConditionsDescription description : conditionsDescriptions) {
            for (String pattern : description.getPatterns()) {
                String methods = Joiner.on((String)", ").skipNulls().join((Iterable)description.getMethods());
                String params = Joiner.on((String)", ").skipNulls().join((Iterable)description.getParams());
                String consumes = description.getConsumes().stream().map(x -> x.getMediaType()).collect(Collectors.joining(", "));
                String produces = description.getProduces().stream().map(x -> x.getMediaType()).collect(Collectors.joining(", "));
                String prefix = pattern.split("/")[1];
                endpoints.put((Object)prefix, (Object)new Endpoint(pattern, methods, params, consumes, produces));
            }
        }
        for (String prefix : endpoints.keySet()) {
            prefixAndEndpoints.add(new PrefixAndEndpoint(prefix, new ArrayList(endpoints.get((Object)prefix))));
        }
        prefixAndEndpoints.sort(Comparator.comparing(x -> x.prefix));
        return ResponseEntity.ok(prefixAndEndpoints);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/internalapi/debuginfos/setLoggingConfig"}, method={RequestMethod.GET})
    public ResponseEntity setLoggingConfig(@RequestParam(required=false) String markersToEnable) {
        this.configProvider.getBaseConfig().getMain().getLogging().setLogfilelevel("DEBUG");
        if (markersToEnable != null) {
            this.configProvider.getBaseConfig().getMain().getLogging().setMarkersToLog(Arrays.asList(markersToEnable.split(",")));
        }
        String msg = "Set log file level to debug and enabled the following logging markers: " + markersToEnable;
        logger.info(msg);
        this.baseConfigHandler.save(true);
        return ResponseEntity.ok((Object)msg);
    }
}

