/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.downloading.FileDownloadAccessType;
import org.nzbhydra.downloading.FileDownloadStatus;
import org.nzbhydra.searching.db.SearchResultEntity;
import org.nzbhydra.springnative.ReflectionMarker;
import org.nzbhydra.web.SessionStorage;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@ReflectionMarker
@Entity
@Table(name="indexernzbdownload", indexes={@Index(name="NZB_DOWNLOAD_EXT_ID", columnList="EXTERNAL_ID")})
public final class FileDownloadEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @SequenceGenerator(allocationSize=1, name="INDEXERNZBDOWNLOAD_SEQ")
    private int id;
    @ManyToOne
    @JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer"})
    @OnDelete(action=OnDeleteAction.CASCADE)
    private SearchResultEntity searchResult;
    @Enumerated(value=EnumType.STRING)
    private FileDownloadAccessType nzbAccessType;
    @Enumerated(value=EnumType.STRING)
    private SearchSource accessSource;
    @Convert(converter=Jsr310JpaConverters.InstantConverter.class)
    private Instant time = Instant.now();
    @Enumerated(value=EnumType.STRING)
    private FileDownloadStatus status;
    private String error;
    private String username;
    private String ip;
    private String userAgent;
    private Integer age;
    @Column(name="EXTERNAL_ID")
    private String externalId;

    public FileDownloadEntity(SearchResultEntity searchResult, FileDownloadAccessType nzbAccessType, SearchSource accessSource, FileDownloadStatus status, String error) {
        this.searchResult = searchResult;
        this.nzbAccessType = nzbAccessType;
        this.accessSource = accessSource;
        this.status = status;
        this.time = Instant.now();
        this.username = (String)SessionStorage.username.get();
        this.userAgent = (String)SessionStorage.userAgent.get();
        this.ip = (String)SessionStorage.IP.get();
        this.age = (int)(Duration.between(searchResult.getPubDate(), searchResult.getFirstFound()).get(ChronoUnit.SECONDS) / 86400L);
        this.setError(error);
    }

    public void setError(String error) {
        this.error = error != null && error.length() > 4000 ? error.substring(0, 4000) : error;
    }

    public FileDownloadEntity() {
        this.time = Instant.now();
    }

    public int getId() {
        return this.id;
    }

    public SearchResultEntity getSearchResult() {
        return this.searchResult;
    }

    public FileDownloadAccessType getNzbAccessType() {
        return this.nzbAccessType;
    }

    public SearchSource getAccessSource() {
        return this.accessSource;
    }

    public Instant getTime() {
        return this.time;
    }

    public FileDownloadStatus getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public String getUsername() {
        return this.username;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Integer getAge() {
        return this.age;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setId(int id) {
        this.id = id;
    }

    @JsonIgnoreProperties(value={"handler", "hibernateLazyInitializer"})
    public void setSearchResult(SearchResultEntity searchResult) {
        this.searchResult = searchResult;
    }

    public void setNzbAccessType(FileDownloadAccessType nzbAccessType) {
        this.nzbAccessType = nzbAccessType;
    }

    public void setAccessSource(SearchSource accessSource) {
        this.accessSource = accessSource;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public void setStatus(FileDownloadStatus status) {
        this.status = status;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileDownloadEntity)) {
            return false;
        }
        FileDownloadEntity other = (FileDownloadEntity)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        Integer this$age = this.getAge();
        Integer other$age = other.getAge();
        if (this$age == null ? other$age != null : !((Object)this$age).equals(other$age)) {
            return false;
        }
        SearchResultEntity this$searchResult = this.getSearchResult();
        SearchResultEntity other$searchResult = other.getSearchResult();
        if (this$searchResult == null ? other$searchResult != null : !this$searchResult.equals(other$searchResult)) {
            return false;
        }
        FileDownloadAccessType this$nzbAccessType = this.getNzbAccessType();
        FileDownloadAccessType other$nzbAccessType = other.getNzbAccessType();
        if (this$nzbAccessType == null ? other$nzbAccessType != null : !this$nzbAccessType.equals(other$nzbAccessType)) {
            return false;
        }
        SearchSource this$accessSource = this.getAccessSource();
        SearchSource other$accessSource = other.getAccessSource();
        if (this$accessSource == null ? other$accessSource != null : !this$accessSource.equals(other$accessSource)) {
            return false;
        }
        Instant this$time = this.getTime();
        Instant other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        FileDownloadStatus this$status = this.getStatus();
        FileDownloadStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        return !(this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        Integer $age = this.getAge();
        result = result * 59 + ($age == null ? 43 : ((Object)$age).hashCode());
        SearchResultEntity $searchResult = this.getSearchResult();
        result = result * 59 + ($searchResult == null ? 43 : $searchResult.hashCode());
        FileDownloadAccessType $nzbAccessType = this.getNzbAccessType();
        result = result * 59 + ($nzbAccessType == null ? 43 : $nzbAccessType.hashCode());
        SearchSource $accessSource = this.getAccessSource();
        result = result * 59 + ($accessSource == null ? 43 : $accessSource.hashCode());
        Instant $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        FileDownloadStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        return result;
    }

    public String toString() {
        return "FileDownloadEntity(id=" + this.getId() + ", searchResult=" + String.valueOf(this.getSearchResult()) + ", nzbAccessType=" + String.valueOf(this.getNzbAccessType()) + ", accessSource=" + String.valueOf(this.getAccessSource()) + ", time=" + String.valueOf(this.getTime()) + ", status=" + String.valueOf(this.getStatus()) + ", error=" + this.getError() + ", username=" + this.getUsername() + ", ip=" + this.getIp() + ", userAgent=" + this.getUserAgent() + ", age=" + this.getAge() + ", externalId=" + this.getExternalId() + ")";
    }
}

