/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading.downloaders;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import jakarta.persistence.EntityNotFoundException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.config.downloading.DownloaderConfig;
import org.nzbhydra.config.downloading.FileDownloadAccessType;
import org.nzbhydra.config.downloading.NzbAddingType;
import org.nzbhydra.config.indexer.IndexerConfig;
import org.nzbhydra.downloading.AddFilesRequest;
import org.nzbhydra.downloading.DownloadResult;
import org.nzbhydra.downloading.FileDownloadEntity;
import org.nzbhydra.downloading.FileDownloadStatus;
import org.nzbhydra.downloading.FileHandler;
import org.nzbhydra.downloading.IndexerSpecificDownloadExceptions;
import org.nzbhydra.downloading.downloaders.AddNzbsResponse;
import org.nzbhydra.downloading.downloaders.Downloader;
import org.nzbhydra.downloading.downloaders.DownloaderEntry;
import org.nzbhydra.downloading.downloaders.DownloaderStatus;
import org.nzbhydra.downloading.downloadurls.DownloadLink;
import org.nzbhydra.downloading.downloadurls.DownloadUrlBuilder;
import org.nzbhydra.downloading.exceptions.DownloaderException;
import org.nzbhydra.downloading.exceptions.DuplicateNzbException;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.notifications.DownloadCompletionNotificationEvent;
import org.nzbhydra.searching.db.SearchResultEntity;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public abstract class Downloader {
    private static final Logger logger = LoggerFactory.getLogger(Downloader.class);
    protected final Map<Long, String> guidExternalIds = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).expiration(5L, TimeUnit.MINUTES).build();
    private final DownloadUrlBuilder downloadUrlBuilder;
    protected FileHandler fileHandler;
    protected SearchResultRepository searchResultRepository;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final IndexerSpecificDownloadExceptions indexerSpecificDownloadExceptions;
    protected final ConfigProvider configProvider;
    protected DownloaderConfig downloaderConfig;
    protected List<Long> downloadRates = new ArrayList();

    public Downloader(FileHandler fileHandler, SearchResultRepository searchResultRepository, ApplicationEventPublisher applicationEventPublisher, IndexerSpecificDownloadExceptions indexerSpecificDownloadExceptions, ConfigProvider configProvider, DownloadUrlBuilder downloadUrlBuilder) {
        this.fileHandler = fileHandler;
        this.searchResultRepository = searchResultRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.indexerSpecificDownloadExceptions = indexerSpecificDownloadExceptions;
        this.configProvider = configProvider;
        this.downloadUrlBuilder = downloadUrlBuilder;
    }

    public void initialize(DownloaderConfig downloaderConfig) {
        this.downloaderConfig = downloaderConfig;
    }

    public boolean isEnabled() {
        return this.downloaderConfig != null && this.downloaderConfig.isEnabled();
    }

    public String getName() {
        return this.downloaderConfig.getName();
    }

    @Transactional
    public AddNzbsResponse addBySearchResultIds(List<AddFilesRequest.SearchResult> searchResults, String category) {
        HashSet<Long> addedNzbs = new HashSet<Long>();
        HashSet<SearchResultEntity> missedNzbs = new HashSet<SearchResultEntity>();
        HashSet<Long> failedSearchResultIds = new HashSet<Long>();
        for (AddFilesRequest.SearchResult entry : searchResults) {
            try {
                Object categoryToSend;
                Long guid = Long.valueOf(entry.getSearchResultId());
                if ("Use original category".equals(category)) {
                    if ("N/A".equals(entry.getOriginalCategory())) {
                        logger.info("Using mapped category {} because the original category is N/A", (Object)entry.getMappedCategory());
                        categoryToSend = entry.getMappedCategory();
                    } else {
                        categoryToSend = entry.getOriginalCategory();
                    }
                } else {
                    categoryToSend = "Use mapped category".equals(category) ? entry.getMappedCategory() : ("Use no category".equals(category) ? null : category);
                }
                Optional optionalResult = this.searchResultRepository.findById((Object)guid);
                if (optionalResult.isEmpty()) {
                    logger.error("Download request with invalid/outdated GUID {}", (Object)guid);
                    failedSearchResultIds.add(guid);
                    continue;
                }
                SearchResultEntity searchResult = (SearchResultEntity)optionalResult.get();
                String searchResultTitle = ((SearchResultEntity)optionalResult.get()).getTitle();
                IndexerConfig indexerConfig = this.configProvider.getIndexerByName(((SearchResultEntity)optionalResult.get()).getIndexer().getName());
                try {
                    String externalId;
                    NzbAddingType addingType = this.getNzbAddingType(searchResult.getDownloadType(), searchResult);
                    FileDownloadAccessType accessTypeForIndexer = this.indexerSpecificDownloadExceptions.getAccessTypeForIndexer(indexerConfig, this.configProvider.getBaseConfig().getDownloading().getNzbAccessType(), searchResult);
                    if (addingType == NzbAddingType.UPLOAD && accessTypeForIndexer == FileDownloadAccessType.PROXY) {
                        logger.debug("Adding type UPLOAD and file download access type PROXY for downloader {} and indexer {}", (Object)this.getName(), (Object)indexerConfig.getName());
                        DownloadResult result = this.fileHandler.getFileByResult(FileDownloadAccessType.PROXY, SearchSource.INTERNAL, (SearchResultEntity)optionalResult.get());
                        if (result.isSuccessful()) {
                            externalId = this.addContent(result.getContent(), result.getTitle(), searchResult.getDownloadType(), (String)categoryToSend);
                            result.getDownloadEntity().setExternalId(externalId);
                            this.fileHandler.updateStatusByEntity(result.getDownloadEntity(), FileDownloadStatus.NZB_ADDED);
                            addedNzbs.add(guid);
                            continue;
                        }
                        missedNzbs.add(searchResult);
                        continue;
                    }
                    logger.debug("Adding type SEND_LINK for downloader {} and indexer {}", (Object)this.getName(), (Object)indexerConfig.getName());
                    DownloadLink link = this.downloadUrlBuilder.getDownloadLinkForSendingToDownloader(searchResult, false);
                    externalId = this.addLink(link.link(), searchResultTitle, searchResult.getDownloadType(), (String)categoryToSend);
                    this.guidExternalIds.put(guid, externalId);
                    addedNzbs.add(guid);
                    if (link.isInternal()) continue;
                    logger.debug("Saving download for sending an external link to the downloader");
                    this.fileHandler.handleRedirect(SearchSource.INTERNAL, searchResult, link.link());
                }
                catch (DuplicateNzbException e) {
                    if (searchResult == null) continue;
                    missedNzbs.add(searchResult);
                }
            }
            catch (EntityNotFoundException e) {
                logger.error("Unable to find the search result in the database for ID: {}", (Object)entry.getSearchResultId());
                failedSearchResultIds.add(Long.valueOf(entry.getSearchResultId()));
            }
            catch (DownloaderException e) {
                logger.error("Downloader error: {}", (Object)e.getMessage());
                Object message = e.getMessage();
                if (!addedNzbs.isEmpty()) {
                    message = (String)message + ".\n" + addedNzbs.size() + " were added successfully before the error";
                }
                for (AddFilesRequest.SearchResult remainingEntry : searchResults) {
                    Long remainingGuid = Long.valueOf(remainingEntry.getSearchResultId());
                    if (addedNzbs.contains(remainingGuid) || failedSearchResultIds.contains(remainingGuid)) continue;
                    failedSearchResultIds.add(remainingGuid);
                }
                failedSearchResultIds.addAll(missedNzbs.stream().map(SearchResultEntity::getId).collect(Collectors.toSet()));
                return new AddNzbsResponse(false, (String)message, addedNzbs, failedSearchResultIds);
            }
        }
        failedSearchResultIds.addAll(missedNzbs.stream().map(SearchResultEntity::getId).collect(Collectors.toSet()));
        if (missedNzbs.isEmpty() && failedSearchResultIds.isEmpty()) {
            return new AddNzbsResponse(true, null, addedNzbs, Collections.emptyList());
        }
        logger.debug("At least one NZB was not downloaded successfully or could not be added to the downloader");
        Object message = "";
        if (!missedNzbs.isEmpty()) {
            message = "NZBs for the following titles could not be downloaded or added:\r\n" + missedNzbs.stream().map(SearchResultEntity::getTitle).collect(Collectors.joining(", "));
        }
        if (!failedSearchResultIds.isEmpty() && missedNzbs.isEmpty()) {
            message = "Some search results could not be processed";
        }
        return new AddNzbsResponse(true, (String)message, addedNzbs, new ArrayList(failedSearchResultIds));
    }

    protected NzbAddingType getNzbAddingType(DownloadType downloadType, SearchResultEntity searchResult) {
        return this.downloaderConfig.getNzbAddingType();
    }

    public abstract GenericResponse checkConnection();

    public abstract List<String> getCategories();

    public abstract String addLink(String var1, String var2, DownloadType var3, String var4) throws DownloaderException;

    public abstract String addContent(byte[] var1, String var2, DownloadType var3, String var4) throws DownloaderException;

    public abstract DownloaderStatus getStatus() throws DownloaderException;

    public List<FileDownloadEntity> checkForStatusUpdates(List<FileDownloadEntity> downloads, StatusCheckType statusCheckType) {
        logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Checking {} history for updates to downloaded statuses", (Object)this.downloaderConfig.getName());
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (downloads.isEmpty()) {
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "No downloades in history");
            return Collections.emptyList();
        }
        Instant earliestDownload = ((FileDownloadEntity)Iterables.getLast(downloads)).getTime();
        ArrayList<FileDownloadEntity> updatedDownloads = new ArrayList<FileDownloadEntity>();
        try {
            Sets.SetView unmatchedEntries;
            List downloaderEntries = statusCheckType == StatusCheckType.HISTORY ? this.getHistory(earliestDownload) : this.getQueue(earliestDownload);
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Found {} downloader history entries", (Object)downloaderEntries.size());
            HashSet<FileDownloadEntity> matchedDownloads = new HashSet<FileDownloadEntity>();
            HashSet<DownloaderEntry> matchedEntries = new HashSet<DownloaderEntry>();
            for (FileDownloadEntity download : downloads) {
                for (DownloaderEntry entry : downloaderEntries) {
                    if (download.getSearchResult() == null || !this.isDownloadMatchingDownloaderEntry(download, entry)) continue;
                    matchedDownloads.add(download);
                    matchedEntries.add(entry);
                    logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Found match between download and downloader entry with title {}", (Object)entry.getNzbName());
                    FileDownloadStatus newStatus = this.getDownloadStatusFromDownloaderEntry(entry, statusCheckType);
                    if (newStatus == null) {
                        logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Unable to map downloader status {}", (Object)entry.getStatus());
                        continue;
                    }
                    if ((download.getStatus() == FileDownloadStatus.NONE || download.getStatus() == FileDownloadStatus.REQUESTED) && download.getExternalId() == null && statusCheckType == StatusCheckType.QUEUE) {
                        logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Current download status is {} and no downloader ID was set. Setting ID {} now", (Object)entry.getStatus(), (Object)entry.getNzbId());
                        download.setExternalId(String.valueOf(entry.getNzbId()));
                    }
                    if (newStatus.canUpdate(download.getStatus())) {
                        download.setStatus(newStatus);
                        updatedDownloads.add(download);
                        logger.info("Updating download status for {} to {}", (Object)entry.getNzbName(), (Object)newStatus);
                    }
                    if (!newStatus.isFinal()) continue;
                    logger.debug(LoggingMarkers.NOTIFICATIONS, "Throwing notification for final download status {} of {}", (Object)newStatus, (Object)entry.getNzbName());
                    this.applicationEventPublisher.publishEvent((Object)new DownloadCompletionNotificationEvent(entry.getNzbName(), newStatus.humanize()));
                }
            }
            Sets.SetView unmatchedDownloads = Sets.difference(new HashSet<FileDownloadEntity>(downloads), matchedDownloads);
            if (!unmatchedDownloads.isEmpty()) {
                logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Unable to find downloader entries for these downloads: {}", (Object)Joiner.on((String)", ").join((Iterable)unmatchedDownloads));
            }
            if (!(unmatchedEntries = Sets.difference(new HashSet(downloaderEntries), matchedEntries)).isEmpty()) {
                logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Unable to find downloads for these downloader entries: {}", (Object)Joiner.on((String)", ").join((Iterable)unmatchedEntries));
            }
            logger.debug(LoggingMarkers.PERFORMANCE, "Took {}ms to check download status updates for {} downloads in the database and {} entries from {} {}", new Object[]{stopwatch.elapsed(TimeUnit.MILLISECONDS), downloads.size(), downloaderEntries.size(), this.downloaderConfig.getName(), statusCheckType});
        }
        catch (DownloaderException e) {
            logger.warn("Unable to contact downloader {}: {}", (Object)this.downloaderConfig.getName(), (Object)e.getMessage());
        }
        catch (Throwable throwable) {
            logger.error("Error while trying to update download statuses", throwable);
        }
        return updatedDownloads;
    }

    protected void addDownloadRate(long downloadRateKb) {
        if (this.downloadRates.size() >= 300) {
            this.downloadRates.remove(0);
        }
        this.downloadRates.add(downloadRateKb);
    }

    public abstract List<DownloaderEntry> getHistory(Instant var1) throws DownloaderException;

    public abstract List<DownloaderEntry> getQueue(Instant var1) throws DownloaderException;

    protected abstract FileDownloadStatus getDownloadStatusFromDownloaderEntry(DownloaderEntry var1, StatusCheckType var2);

    boolean isDownloadMatchingDownloaderEntry(FileDownloadEntity download, DownloaderEntry entry) {
        if (download.getExternalId() != null) {
            boolean idMatches = download.getExternalId() != null && download.getExternalId().equals(entry.getNzbId());
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Trying to match downloader entry {} with download {}. Id match: {}. ", new Object[]{entry, download, idMatches});
            return idMatches;
        }
        if (this.guidExternalIds.containsKey(download.getSearchResult().getId())) {
            boolean idFromMapMatches = this.guidExternalIds.containsKey(download.getSearchResult().getId()) && ((String)this.guidExternalIds.get(download.getSearchResult().getId())).equals(entry.getNzbId());
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Trying to match downloader entry {} with download {}. Id map match: {}. ", new Object[]{entry, download, idFromMapMatches});
            return idFromMapMatches;
        }
        if (download.getSearchResult().getTitle() == null) {
            logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Unable to match downloader entry {} with download {} without title ", (Object)entry, (Object)download);
            return false;
        }
        String downloadTitleCleaned = download.getSearchResult().getTitle().replaceAll("[^a-zA-Z0-9 _\\-]", "");
        String entryTitleCleaned = entry.getNzbName().replaceAll("[^a-zA-Z0-9 _\\-]", "");
        boolean nameMatches = downloadTitleCleaned.equalsIgnoreCase(entryTitleCleaned);
        logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Trying to match downloader entry {} with download {}. Name match: {}. ", new Object[]{entry, download, nameMatches});
        return nameMatches;
    }

    public String getUrl() {
        return this.downloaderConfig.getUrl();
    }

    protected String suffixNzbToTitle(String title) {
        if (!((String)title).toLowerCase().endsWith(".nzb")) {
            title = (String)title + ".nzb";
        }
        return title;
    }
}

