/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading.downloaders.sabnzbd;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.nzbhydra.GenericResponse;
import org.nzbhydra.Jackson;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.downloading.DownloaderType;
import org.nzbhydra.downloading.FileDownloadStatus;
import org.nzbhydra.downloading.FileHandler;
import org.nzbhydra.downloading.IndexerSpecificDownloadExceptions;
import org.nzbhydra.downloading.downloaders.Downloader;
import org.nzbhydra.downloading.downloaders.DownloaderEntry;
import org.nzbhydra.downloading.downloaders.DownloaderStatus;
import org.nzbhydra.downloading.downloaders.sabnzbd.mapping.AddNzbResponse;
import org.nzbhydra.downloading.downloaders.sabnzbd.mapping.CategoriesResponse;
import org.nzbhydra.downloading.downloaders.sabnzbd.mapping.HistoryEntry;
import org.nzbhydra.downloading.downloaders.sabnzbd.mapping.HistoryResponse;
import org.nzbhydra.downloading.downloaders.sabnzbd.mapping.Queue;
import org.nzbhydra.downloading.downloaders.sabnzbd.mapping.QueueEntry;
import org.nzbhydra.downloading.downloaders.sabnzbd.mapping.QueueResponse;
import org.nzbhydra.downloading.downloadurls.DownloadUrlBuilder;
import org.nzbhydra.downloading.exceptions.DownloaderException;
import org.nzbhydra.downloading.exceptions.DownloaderUnreachableException;
import org.nzbhydra.downloading.exceptions.DuplicateNzbException;
import org.nzbhydra.logging.LoggingMarkers;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.nzbhydra.webaccess.HydraOkHttp3ClientHttpRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.client.UnknownContentTypeException;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
public class Sabnzbd
extends Downloader {
    private static final Logger logger = LoggerFactory.getLogger(Sabnzbd.class);
    private static final Map<String, FileDownloadStatus> SABNZBD_STATUS_TO_HYDRA_STATUS = new HashMap();
    private Instant lastErrorLogged;
    private final RestTemplate restTemplate;
    private final HydraOkHttp3ClientHttpRequestFactory requestFactory;

    public Sabnzbd(FileHandler nzbHandler, SearchResultRepository searchResultRepository, ApplicationEventPublisher applicationEventPublisher, IndexerSpecificDownloadExceptions indexerSpecificDownloadExceptions, ConfigProvider configProvider, RestTemplate restTemplate, HydraOkHttp3ClientHttpRequestFactory requestFactory, DownloadUrlBuilder downloadUrlBuilder) {
        super(nzbHandler, searchResultRepository, applicationEventPublisher, indexerSpecificDownloadExceptions, configProvider, downloadUrlBuilder);
        this.restTemplate = restTemplate;
        this.requestFactory = requestFactory;
    }

    private UriComponentsBuilder getBaseUrl() {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)this.downloaderConfig.getUrl()).pathSegment(new String[]{"api"});
        if (!Strings.isNullOrEmpty((String)this.downloaderConfig.getApiKey())) {
            builder.queryParam("apikey", new Object[]{this.downloaderConfig.getApiKey()});
        }
        builder.queryParam("output", new Object[]{"json"});
        return builder;
    }

    public String addLink(String url, String title, DownloadType downloadType, String category) throws DownloaderException {
        logger.debug("Sending link for NZB {} to sabnzbd", (Object)title);
        title = this.suffixNzbToTitle(title);
        title = title.replace("\"", "_").replace("/", "_");
        UriComponentsBuilder urlBuilder = this.getBaseUrl();
        urlBuilder.queryParam("mode", new Object[]{"addurl"}).queryParam("name", new Object[]{url}).queryParam("nzbname", new Object[]{title}).queryParam("priority", new Object[]{this.getPriority()});
        if (!Strings.isNullOrEmpty((String)category)) {
            urlBuilder.queryParam("cat", new Object[]{category});
        }
        String nzoId = this.sendAddNzbLinkCommand(urlBuilder, null, HttpMethod.POST);
        logger.info("Successfully added link {} for NZB \"{}\" to sabnzbd queue with ID {}", new Object[]{url, title, nzoId});
        return nzoId;
    }

    private String sendAddNzbLinkCommand(UriComponentsBuilder urlBuilder, HttpEntity httpEntity, HttpMethod httpMethod) throws DownloaderException {
        try {
            URI url = urlBuilder.build().encode().toUri();
            ResponseEntity response = this.restTemplate.exchange(url, httpMethod, httpEntity, AddNzbResponse.class);
            if (!response.getStatusCode().is2xxSuccessful()) {
                throw new DownloaderException("Downloader returned status code " + String.valueOf(response.getStatusCode()));
            }
            if (!((AddNzbResponse)response.getBody()).isStatus()) {
                throw new DownloaderException("Downloader says NZB was not added successfully.");
            }
            if (((AddNzbResponse)response.getBody()).getNzoIds().isEmpty()) {
                throw new DownloaderException("Sabnzbd says NZB was added successfully but didn't return an NZO ID");
            }
            return (String)((AddNzbResponse)response.getBody()).getNzoIds().get(0);
        }
        catch (RestClientException e) {
            throw new DownloaderUnreachableException("Error while adding NZB(s): " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String addContent(byte[] fileContent, String title, DownloadType downloadType, String category) throws DownloaderException {
        logger.debug("Uploading NZB {} to sabnzbd", (Object)title);
        UriComponentsBuilder urlBuilder = this.getBaseUrl();
        title = this.suffixNzbToTitle(title);
        title = title.replace("\"", "_").replace("/", "_");
        urlBuilder.queryParam("mode", new Object[]{"addfile"}).queryParam("nzbname", new Object[]{title}).queryParam("priority", new Object[]{this.getPriority()});
        if (!Strings.isNullOrEmpty((String)category)) {
            urlBuilder.queryParam("cat", new Object[]{category});
        }
        MultipartBody formBody = new MultipartBody.Builder().addFormDataPart("name", title, RequestBody.create((MediaType)MediaType.parse((String)"application/xml"), (byte[])fileContent)).build();
        Request request = new Request.Builder().url(urlBuilder.toUriString()).post((RequestBody)formBody).build();
        OkHttpClient client = this.requestFactory.getOkHttpClient(urlBuilder.build().encode().toUri().getHost());
        try (Response response = client.newCall(request).execute();){
            String string;
            block17: {
                ResponseBody body = response.body();
                try {
                    if (!response.isSuccessful()) {
                        throw new DownloaderException("Downloader returned status code " + response.code() + " and message " + response.message());
                    }
                    String bodyContent = body.string();
                    AddNzbResponse addNzbResponse = (AddNzbResponse)Jackson.JSON_MAPPER.readValue(bodyContent, AddNzbResponse.class);
                    if (addNzbResponse.getNzoIds().isEmpty()) {
                        logger.warn("Tried to add NZB \"{}\" but sabNZBd reports it as a duplicate", (Object)title);
                        throw new DuplicateNzbException("Duplicate: " + title);
                    }
                    String nzoId = (String)addNzbResponse.getNzoIds().get(0);
                    logger.info("Successfully added NZB \"{}\" to sabnzbd queue with ID {}", (Object)title, (Object)nzoId);
                    string = nzoId;
                    if (body == null) break block17;
                }
                catch (Throwable throwable) {
                    if (body != null) {
                        try {
                            body.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                body.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new DownloaderException("Error while communicating with downloader: " + e.getMessage());
        }
    }

    private String getPriority() {
        if (this.downloaderConfig.isAddPaused()) {
            return "-2";
        }
        return "-100";
    }

    public DownloaderStatus getStatus() throws DownloaderException {
        UriComponentsBuilder uriBuilder = this.getBaseUrl().queryParam("mode", new Object[]{"queue"});
        QueueResponse queueResponse = null;
        try {
            queueResponse = (QueueResponse)this.callSabnzb(uriBuilder.build().toUri(), QueueResponse.class);
            this.lastErrorLogged = null;
        }
        catch (DownloaderException e) {
            if (this.lastErrorLogged == null || this.lastErrorLogged.isBefore(Instant.now().minus(10L, ChronoUnit.MINUTES))) {
                logger.error("Error contacting sabnzbd", (Throwable)e);
                this.lastErrorLogged = Instant.now();
            }
            DownloaderStatus status = new DownloaderStatus();
            status.setState(DownloaderStatus.State.OFFLINE);
            this.addDownloadRate(0L);
            return status;
        }
        DownloaderStatus status = new DownloaderStatus();
        if (queueResponse == null || queueResponse.getQueue() == null || queueResponse.getQueue().getSlots() == null) {
            throw new DownloaderException("Sanzbd returned empty respone");
        }
        Queue queue = queueResponse.getQueue();
        if (queue.getPaused().booleanValue()) {
            status.setState(DownloaderStatus.State.PAUSED);
        } else if ("Downloading".equals(queue.getStatus())) {
            status.setState(DownloaderStatus.State.DOWNLOADING);
        } else {
            status.setState(DownloaderStatus.State.IDLE);
        }
        status.setDownloaderType(DownloaderType.SABNZBD);
        status.setDownloaderName(this.downloaderConfig.getName());
        if (queue.getKbpersec() != null) {
            status.setDownloadRateInKilobytes((long)Float.parseFloat(queue.getKbpersec()));
            this.addDownloadRate(status.getDownloadRateInKilobytes());
        }
        status.setElementsInQueue(queue.getSlots().size());
        if (queue.getMbleft() != null) {
            status.setRemainingSizeInMegaBytes((long)Float.parseFloat(queue.getMbleft()));
        }
        status.setRemainingSeconds(this.parseRemainingTime(queue.getTimeleft()));
        if (!queue.getSlots().isEmpty()) {
            QueueEntry currentEntry = (QueueEntry)queue.getSlots().get(0);
            status.setDownloadingTitle(currentEntry.getFilename());
            status.setDownloadingTitleRemainingTimeSeconds(this.parseRemainingTime(currentEntry.getTimeleft()));
            status.setDownloadingTitleRemainingSizeKilobytes((long)Float.parseFloat(currentEntry.getMbleft()) * 1024L);
            status.setDownloadingTitlePercentFinished(Integer.parseInt(currentEntry.getPercentage()));
        }
        status.setDownloadingRatesInKilobytes(this.downloadRates);
        return status;
    }

    private long parseRemainingTime(String timeleft) {
        if (Strings.isNullOrEmpty((String)timeleft)) {
            return 0L;
        }
        try {
            if (StringUtils.countMatches((CharSequence)timeleft, (CharSequence)":") == 3) {
                return Sabnzbd.durationStringToSeconds((String)timeleft);
            }
            return Sabnzbd.durationStringToSeconds((String)timeleft);
        }
        catch (Exception e) {
            logger.error("Unable to parse time left from value '{}'", (Object)timeleft);
            return 0L;
        }
    }

    static int durationStringToSeconds(String duration) {
        String[] tokens = duration.split(":");
        if (tokens.length == 2) {
            int minutes = Integer.parseInt(tokens[0]);
            int seconds = Integer.parseInt(tokens[1]);
            return 60 * minutes + seconds;
        }
        int hours = Integer.parseInt(tokens[0]);
        int minutes = Integer.parseInt(tokens[1]);
        int seconds = Integer.parseInt(tokens[2]);
        return 3600 * hours + 60 * minutes + seconds;
    }

    public List<DownloaderEntry> getHistory(Instant earliestDownloadTime) throws DownloaderException {
        UriComponentsBuilder uriBuilder = this.getBaseUrl().queryParam("mode", new Object[]{"history"}).queryParam("archive", new Object[]{"1"});
        HistoryResponse queueResponse = (HistoryResponse)this.callSabnzb(uriBuilder.build().toUri(), HistoryResponse.class);
        ArrayList<DownloaderEntry> historyEntries = new ArrayList<DownloaderEntry>();
        for (HistoryEntry historyEntry : queueResponse.getHistory().getSlots()) {
            DownloaderEntry entry = new DownloaderEntry();
            entry.setNzbId(historyEntry.getNzo_id());
            entry.setNzbName(historyEntry.getName());
            entry.setStatus(historyEntry.getStatus());
            entry.setTime(Instant.ofEpochSecond(historyEntry.getCompleted()));
            if (entry.getTime().isBefore(earliestDownloadTime)) {
                logger.debug(LoggingMarkers.DOWNLOAD_STATUS_UPDATE, "Stopping transforming history entries because the current history entry is from {} which is before earliest download to check which is from {}", (Object)entry.getTime(), (Object)earliestDownloadTime);
                return historyEntries;
            }
            historyEntries.add(entry);
        }
        return historyEntries;
    }

    public List<DownloaderEntry> getQueue(Instant earliestDownload) throws DownloaderException {
        UriComponentsBuilder uriBuilder = this.getBaseUrl().queryParam("mode", new Object[]{"queue"});
        QueueResponse queueResponse = (QueueResponse)this.callSabnzb(uriBuilder.build().toUri(), QueueResponse.class);
        ArrayList<DownloaderEntry> historyEntries = new ArrayList<DownloaderEntry>();
        for (QueueEntry slotEntry : queueResponse.getQueue().getSlots()) {
            DownloaderEntry entry = new DownloaderEntry();
            entry.setNzbId(slotEntry.getNzo_id());
            entry.setNzbName(slotEntry.getFilename());
            entry.setStatus(slotEntry.getStatus());
            historyEntries.add(entry);
        }
        return historyEntries;
    }

    protected <T> T callSabnzb(URI uri, Class<T> responseType) throws DownloaderException {
        try {
            return (T)this.restTemplate.getForObject(uri, responseType);
        }
        catch (RestClientException e) {
            throw new DownloaderException("Error while calling sabNZBd", (Throwable)e);
        }
    }

    protected FileDownloadStatus getDownloadStatusFromDownloaderEntry(DownloaderEntry entry, Downloader.StatusCheckType statusCheckType) {
        return (FileDownloadStatus)SABNZBD_STATUS_TO_HYDRA_STATUS.get(entry.getStatus());
    }

    public GenericResponse checkConnection() {
        logger.debug("Checking connection");
        UriComponentsBuilder baseUrl = this.getBaseUrl();
        try {
            ResponseEntity exchange = this.restTemplate.exchange(baseUrl.queryParam("mode", new Object[]{"queue"}).build().toUri().toString(), HttpMethod.GET, null, QueueResponse.class, new Object[0]);
            if (!exchange.getStatusCode().is2xxSuccessful()) {
                logger.info("Connection check with sabNZBd using URL {}\n failed: Response body: {}", (Object)baseUrl.toUriString(), (Object)((QueueResponse)exchange.getBody()).toString());
                return new GenericResponse(false, "Connection check with sabnzbd failed. Status code: " + String.valueOf(exchange.getStatusCode()) + ".The log may contain more infos.");
            }
            if (exchange.getBody() == null || ((QueueResponse)exchange.getBody()).getQueue() == null) {
                logger.info("Connection check with sabNZBd using URL {} failed. Unable to parse response.", (Object)baseUrl.toUriString());
                return new GenericResponse(false, "Connection check with sabnzbd failed. Unable to parse response.");
            }
            logger.info("Connection check with sabNZBd using URL {} successful", (Object)baseUrl.toUriString());
            return new GenericResponse(true, null);
        }
        catch (UnknownContentTypeException e) {
            logger.info("Connection check with sabnzbd using URL {} failed. Hydra was unable to parse the response. This usually means that whatever is behind that URL is not sabNZBd. Response: {}", (Object)baseUrl.toUriString(), (Object)e.getMessage());
            return new GenericResponse(false, "Connection check failed. Whatever is behind that URL is probably not sabNZBd.");
        }
        catch (RestClientException e) {
            Throwable exception = e;
            if (exception.getCause() != null && exception.getCause() instanceof ConnectException) {
                exception = exception.getCause();
            }
            logger.info("Connection check with sabNZBd using URL {} failed: {}", (Object)baseUrl.toUriString(), (Object)exception.getMessage());
            return new GenericResponse(false, exception.getMessage());
        }
        catch (Exception e) {
            logger.info("Connection check with sabNZBd using URL {} failed: {}", (Object)baseUrl.toUriString(), (Object)e.getMessage());
            return new GenericResponse(false, e.getMessage());
        }
    }

    public List<String> getCategories() {
        logger.debug("Loading list of categories");
        UriComponentsBuilder uriBuilder = this.getBaseUrl().queryParam("mode", new Object[]{"get_cats"});
        return ((CategoriesResponse)this.restTemplate.getForObject(uriBuilder.build().toUri(), CategoriesResponse.class)).getCategories();
    }

    static {
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Grabbing", FileDownloadStatus.REQUESTED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Queued", FileDownloadStatus.NZB_ADDED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Paused", FileDownloadStatus.NZB_ADDED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Checking", FileDownloadStatus.NZB_ADDED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Downloading", FileDownloadStatus.NZB_ADDED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("QuickCheck", FileDownloadStatus.NZB_ADDED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Verifying", FileDownloadStatus.NZB_ADDED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Repairing", FileDownloadStatus.NZB_ADDED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Fetching", FileDownloadStatus.NZB_ADDED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Extracting", FileDownloadStatus.NZB_ADDED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Moving", FileDownloadStatus.NZB_ADDED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Running", FileDownloadStatus.NZB_ADDED);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Completed", FileDownloadStatus.CONTENT_DOWNLOAD_SUCCESSFUL);
        SABNZBD_STATUS_TO_HYDRA_STATUS.put("Failed", FileDownloadStatus.CONTENT_DOWNLOAD_ERROR);
    }
}

