/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.downloading.nzbs;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.nzbhydra.api.WrongApiKeyException;
import org.nzbhydra.config.BaseConfig;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.config.SearchSource;
import org.nzbhydra.downloading.FileHandler;
import org.nzbhydra.downloading.FileZipResponse;
import org.nzbhydra.downloading.InvalidSearchResultIdException;
import org.nzbhydra.downloading.SaveOrSendResultsResponse;
import org.nzbhydra.indexers.NfoResult;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class NzbHandlingWeb {
    private static final Logger logger = LoggerFactory.getLogger(NzbHandlingWeb.class);
    @Value(value="${nzbhydra.dev.noApiKey:false}")
    private boolean noApiKeyNeeded = false;
    @Autowired
    private FileHandler fileHandler;
    @Autowired
    private ConfigProvider configProvider;

    @RequestMapping(value={"/internalapi/nzb/{guid}"})
    @Secured(value={"ROLE_USER"})
    public ResponseEntity<Object> downloadNzbInternal(@PathVariable(value="guid") long guid) throws InvalidSearchResultIdException {
        logger.debug("downloadNzbInternal: {}", (Object)guid);
        return this.fileHandler.getFileByGuid(guid, SearchSource.INTERNAL).getAsResponseEntity();
    }

    @RequestMapping(value={"/internalapi/saveNzbsToBlackhole"}, method={RequestMethod.PUT}, produces={"application/json"})
    @Secured(value={"ROLE_USER"})
    public SaveOrSendResultsResponse saveNzbToBlackhole(@RequestBody Set<Long> searchResultId) {
        logger.debug("saveNzbToBlackhole searchResultId: {}", searchResultId);
        return this.fileHandler.saveNzbToBlackhole(searchResultId);
    }

    @RequestMapping(value={"/internalapi/nzbzip"}, produces={"application/json"}, method={RequestMethod.POST})
    @Secured(value={"ROLE_USER"})
    public FileZipResponse getNzbZipData(@RequestBody List<Long> guids) {
        logger.debug("getNzbZipData: {}", guids);
        try {
            return this.fileHandler.getFilesAsZip(guids);
        }
        catch (Exception e) {
            logger.error("Error while creating ZIP with NZBs", (Throwable)e);
            return new FileZipResponse(false, null, "Error while creating ZIP with NZBs: " + e.getMessage(), Collections.emptyList(), guids);
        }
    }

    @RequestMapping(value={"/internalapi/nzbzipDownload"}, produces={"application/json"}, method={RequestMethod.POST})
    @Secured(value={"ROLE_USER"})
    public FileSystemResource downloadNzbZip(@RequestBody String zipFilepath) {
        logger.debug("downloadNzbZip: {}", (Object)zipFilepath);
        Optional<File> matchingFile = this.fileHandler.getTemporaryZipFiles().stream().filter(x -> x.getAbsolutePath().equals(zipFilepath)).findFirst();
        if (matchingFile.isPresent()) {
            return new FileSystemResource(zipFilepath);
        }
        throw new RuntimeException("Not allowed to access file " + zipFilepath + " as it was not created by NZBHydra");
    }

    @RequestMapping(value={"/internalapi/nfo/{guid}"}, produces={"application/json"})
    @Secured(value={"ROLE_USER"})
    public NfoResult getNfo(@PathVariable(value="guid") long guid) throws IndexerAccessException {
        return this.fileHandler.getNfo(Long.valueOf(guid));
    }

    @RequestMapping(value={"/getnzb/user/{guid}"}, produces={"application/x-nzb"})
    @Secured(value={"ROLE_USER"})
    public ResponseEntity<Object> downloadNzbForUsers(@PathVariable(value="guid") long guid) throws InvalidSearchResultIdException {
        logger.debug("downloadNzbForUsers guid: {}", (Object)guid);
        return this.fileHandler.getFileByGuid(guid, SearchSource.INTERNAL).getAsResponseEntity();
    }

    @RequestMapping(value={"/getnzb/api/{guid}"}, produces={"application/x-nzb"})
    public ResponseEntity downloadNzbWithApikey(@PathVariable(value="guid") long guid, @RequestParam(required=false) String apikey) throws WrongApiKeyException {
        logger.debug("downloadNzbWithApikey guid: {}", (Object)guid);
        BaseConfig baseConfig = this.configProvider.getBaseConfig();
        if (!(apikey != null && apikey.equals(baseConfig.getMain().getApiKey()) || this.noApiKeyNeeded)) {
            logger.error("Received NZB API download call with wrong API key");
            throw new WrongApiKeyException("Wrong api key");
        }
        try {
            return this.fileHandler.getFileByGuid(guid, SearchSource.API).getAsResponseEntity();
        }
        catch (InvalidSearchResultIdException e) {
            return ResponseEntity.ok().contentType(MediaType.APPLICATION_XML).body((Object)"<error code=\"300\" description=\"Invalid or outdated search result ID\"/>");
        }
    }
}

