/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.fortests;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URL;
import java.util.Enumeration;
import org.nzbhydra.config.ConfigProvider;
import org.nzbhydra.web.UrlCalculator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class DebugWeb {
    @Autowired
    private UrlCalculator urlCalculator;
    @Autowired
    private ConfigProvider configProvider;

    @RequestMapping(value={"/fortests/showCalculatedUrl"}, method={RequestMethod.GET})
    public String testHostSTuff(HttpServletRequest request) throws Exception {
        return this.urlCalculator.getRequestBasedUriBuilder().toUriString();
    }

    @RequestMapping(value={"/fortests/getHostData"}, method={RequestMethod.GET})
    public String getHostData(HttpServletRequest request) throws Exception {
        StringBuilder info = new StringBuilder();
        URL requestUrl = new URL(request.getRequestURL().toString());
        info.append("Config:<br>");
        info.append("Host: ").append(this.configProvider.getBaseConfig().getMain().getHost()).append("\r\n<br>");
        info.append("Port: ").append(this.configProvider.getBaseConfig().getMain().getPort()).append("\r\n<br>");
        info.append("Scheme: ").append(this.configProvider.getBaseConfig().getMain().isSsl() ? "https" : "http").append("\r\n<br>");
        info.append("<br>Headers:<br>");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            String content = request.getHeader(name);
            info.append(name).append(": ").append(content).append("\r\n<br>");
        }
        info.append("<br>From request URL:<br>");
        info.append("Request URL: ").append(request.getRequestURL()).append("\r\n<br>");
        info.append("Request Host: ").append(requestUrl.getHost()).append("\r\n<br>");
        info.append("Request Port: ").append(requestUrl.getPort()).append("\r\n<br>");
        info.append("Request Protocol: ").append(requestUrl.getProtocol()).append("\r\n<br>");
        info.append("<br>From request:<br>");
        info.append("Server name: ").append(request.getServerName()).append("\r\n<br>");
        info.append("Server port: ").append(request.getServerPort()).append("\r\n<br>");
        info.append("Server protocol: ").append(request.getProtocol()).append("\r\n<br>");
        info.append("Scheme: ").append(request.getScheme()).append("\r\n<br>");
        info.append("Context path: ").append(request.getContextPath()).append("\r\n<br>");
        info.append("Servlet path: ").append(request.getServletPath()).append("\r\n<br>");
        return info.toString();
    }
}

