/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.historystats;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.nzbhydra.Jackson;
import org.nzbhydra.downloading.FileDownloadEntity;
import org.nzbhydra.downloading.FileDownloadEntityTO;
import org.nzbhydra.historystats.History;
import org.nzbhydra.historystats.stats.HistoryRequest;
import org.nzbhydra.notifications.NotificationEntity;
import org.nzbhydra.notifications.NotificationEntityTO;
import org.nzbhydra.searching.db.SearchEntity;
import org.nzbhydra.searching.db.SearchEntityTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.security.access.annotation.Secured;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class HistoryWeb {
    @Autowired
    private History history;

    @Secured(value={"ROLE_STATS"})
    @Transactional
    @RequestMapping(value={"/internalapi/history/searches"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public Page<SearchEntityTO> searchHistory(@RequestBody HistoryRequest requestData) {
        Page page = this.history.getHistory(requestData, "SEARCH x", SearchEntity.class);
        List<SearchEntityTO> searchEntityTOS = page.getContent().stream().map(x -> (SearchEntityTO)Jackson.JSON_MAPPER.convertValue(x, SearchEntityTO.class)).toList();
        return new PageImpl(searchEntityTOS, page.getPageable(), page.getTotalElements());
    }

    @Secured(value={"ROLE_STATS"})
    @Transactional
    @RequestMapping(value={"/internalapi/history/searches/details/{searchId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public History.SearchDetails searchHistoryDetails(@PathVariable int searchId) {
        return this.history.getSearchDetails(searchId);
    }

    @Secured(value={"ROLE_USER"})
    @RequestMapping(value={"/internalapi/history/searches/forsearching"}, method={RequestMethod.POST}, produces={"application/json"})
    public List<SearchEntityTO> searchHistoryForSearchPage(HttpServletRequest request) {
        return this.history.getHistoryForSearching().stream().map(x -> (SearchEntityTO)Jackson.JSON_MAPPER.convertValue(x, SearchEntityTO.class)).toList();
    }

    @Secured(value={"ROLE_STATS"})
    @RequestMapping(value={"/internalapi/history/downloads"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public Page<FileDownloadEntityTO> downloadHistory(@RequestBody HistoryRequest requestData) {
        Page page = this.history.getHistory(requestData, "INDEXERNZBDOWNLOAD x left join SEARCHRESULT s on x.SEARCH_RESULT_ID = s.ID LEFT JOIN INDEXER i ON s.INDEXER_ID = i.ID", FileDownloadEntity.class);
        List<FileDownloadEntityTO> downloadEntityTOS = page.stream().map(x -> (FileDownloadEntityTO)Jackson.JSON_MAPPER.convertValue(x, FileDownloadEntityTO.class)).toList();
        return new PageImpl(downloadEntityTOS, page.getPageable(), page.getTotalElements());
    }

    @Secured(value={"ROLE_STATS"})
    @RequestMapping(value={"/internalapi/history/notifications"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/json"})
    public Page<NotificationEntityTO> notificationHistory(@RequestBody HistoryRequest requestData) {
        Page page = this.history.getHistory(requestData, "NOTIFICATION x", NotificationEntity.class);
        List<NotificationEntityTO> tos = page.stream().map(x -> (NotificationEntityTO)Jackson.JSON_MAPPER.convertValue(x, NotificationEntityTO.class)).toList();
        return new PageImpl(tos, page.getPageable(), page.getTotalElements());
    }
}

