/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.function.CheckedSupplier;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.NfoResult;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.indexers.exceptions.IndexerParsingException;
import org.nzbhydra.indexers.exceptions.IndexerSearchAbortedException;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="binsearch")
@Scope(value="prototype")
public class Binsearch
extends Indexer<String> {
    private static final Logger logger = LoggerFactory.getLogger(Binsearch.class);
    private static final Pattern TITLE_PATTERN = Pattern.compile("\"(.*)\\.(rar|nfo|mkv|mp3|mobi|avi|mp4|epub|txt|pdf|par2|001|nzb|url|zip|r[0-9]{2})\"", 2);
    private static final Pattern GROUP_PATTERN = Pattern.compile("&g=([\\w\\.]*)&", 2);
    private static final Pattern POSTER_PATTERN = Pattern.compile("&p=(.*)&", 2);
    private static final Pattern NFO_INFO_PATTERN = Pattern.compile("\\d nfo file", 2);
    private static final Pattern SIZE_PATTERN = Pattern.compile("(?<size>[0-9]+(\\.[0-9]+)?)(?<unit>(GB|MB|KB|B))", 2);
    private static final Pattern PUBDATE_PATTERN = Pattern.compile("(\\d{1,2}\\-\\w{3}\\-\\d{4})", 2);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("dd-MMM-yyyy").parseDefaulting(ChronoField.NANO_OF_DAY, 0L).toFormatter().withZone(ZoneId.of("UTC")).withLocale(Locale.ENGLISH);
    private static final Pattern NFO_PATTERN = Pattern.compile("<pre>(?<nfo>.*)<\\/pre>", 34);
    private final RetryPolicy<Object> retry503policy = ((RetryPolicyBuilder)RetryPolicy.builder().handleIf(x -> x instanceof IndexerAccessException && Throwables.getStackTraceAsString((Throwable)x).contains("503"))).withDelay(Duration.ofMillis(500L)).withMaxRetries(2).build();
    static Clock clock = Clock.systemUTC();

    protected void completeIndexerSearchResult(String response, IndexerSearchResult indexerSearchResult, SearchResultAcceptor.AcceptorResult acceptorResult, SearchRequest searchRequest, int offset, Integer limit) {
        Document doc = Jsoup.parse((String)response);
        Element navElement = this.getElementOrNone((Element)doc, "div.justify-between:nth-child(2) > ul:nth-child(2)");
        if (navElement != null) {
            Elements pageLinks = navElement.select("li");
            boolean hasMore = !pageLinks.isEmpty() && !((Element)pageLinks.get(2)).classNames().contains("disabled");
            boolean totalKnown = false;
            indexerSearchResult.setOffset(searchRequest.getOffset());
            int total = searchRequest.getOffset() + 100;
            if (!hasMore) {
                total = searchRequest.getOffset() + indexerSearchResult.getSearchResultItems().size();
                totalKnown = true;
            }
            indexerSearchResult.setHasMoreResults(hasMore);
            indexerSearchResult.setTotalResults(total);
            indexerSearchResult.setTotalResultsKnown(totalKnown);
        } else {
            indexerSearchResult.setHasMoreResults(false);
            indexerSearchResult.setTotalResults(indexerSearchResult.getSearchResultItems().size());
            indexerSearchResult.setTotalResultsKnown(true);
        }
        indexerSearchResult.setPageSize(100);
        indexerSearchResult.setOffset(offset);
    }

    protected List<SearchResultItem> getSearchResultItems(String searchRequestResponse, SearchRequest searchRequest) throws IndexerParsingException {
        ArrayList<SearchResultItem> items = new ArrayList<SearchResultItem>();
        Document doc = Jsoup.parse((String)searchRequestResponse);
        if (doc.text().contains("No results in most popular groups")) {
            return Collections.emptyList();
        }
        Elements mainTables = doc.select("table.result-table");
        if (mainTables.size() == 0) {
            throw new IndexerParsingException("Unable to find main table in binsearch page. This happens sometimes ;-)");
        }
        Element mainTable = (Element)mainTables.get(0);
        Elements rows = mainTable.select("tr");
        for (int i = 1; i < rows.size(); ++i) {
            Element row = (Element)rows.get(i);
            SearchResultItem item = this.parseRow(row);
            if (item == null) continue;
            items.add(item);
        }
        this.debug("Finished parsing {} of {} rows", new Object[]{items.size(), rows.size()});
        return items;
    }

    private SearchResultItem parseRow(Element row) {
        Float size;
        Element sizeElement;
        Matcher sizeMatcher;
        Element posterElement;
        Matcher matcher;
        SearchResultItem item = new SearchResultItem();
        Element titleElement = this.getElementOrNone(row, "td:nth-child(3) > div:nth-child(1) > a");
        if (titleElement == null) {
            this.debug("Table row does not have a title", new Object[0]);
            return null;
        }
        String title = titleElement.ownText();
        if (title.contains("password protect") || title.contains("passworded")) {
            item.setPassworded(true);
        }
        if (!(matcher = TITLE_PATTERN.matcher(title)).find()) {
            this.debug("Unable to find title in text {}", new Object[]{title});
            return null;
        }
        title = matcher.group(1);
        String filename = matcher.group(1) + "." + matcher.group(2);
        title = this.cleanUpTitle(title);
        item.setTitle(title);
        item.setIndexerGuid(this.getElementOrNone(row, "input[type=checkbox]").attr("name"));
        item.setLink("https://binsearch.info/nzb?mode=files&%s=on&name=%s".formatted(item.getIndexerGuid(), StringUtils.removeEnd((String)filename, (String)".nzb") + ".nzb"));
        Element infoElement = this.getElementOrNone(row, "td:nth-child(3) > div:nth-child(1) > div");
        if (infoElement == null) {
            this.debug("Ignored entry because it has no info", new Object[0]);
            return null;
        }
        String collectionLink = this.getElementOrNone(row, "a").attr("href");
        item.setDetails("https://binsearch.info/details/" + item.getIndexerGuid());
        Element groupElement = this.getElementOrNone(infoElement, "a[href*=\"search?group\"]");
        if (groupElement != null) {
            item.setGroup(groupElement.ownText());
        }
        if ((posterElement = this.getElementOrNone(infoElement, "a[href*=\"search?poster\"]")) != null) {
            item.setPoster(posterElement.text());
        }
        if ((sizeMatcher = SIZE_PATTERN.matcher((sizeElement = this.getElementOrNone(infoElement, "span")).ownText())).find()) {
            String unit;
            size = Float.valueOf(Float.parseFloat(sizeMatcher.group("size")));
            switch (unit = sizeMatcher.group("unit")) {
                case "GB": {
                    size = Float.valueOf(size.floatValue() * 1000.0f * 1000.0f * 1000.0f);
                    break;
                }
                case "MB": {
                    size = Float.valueOf(size.floatValue() * 1000.0f * 1000.0f);
                    break;
                }
                case "KB": {
                    size = Float.valueOf(size.floatValue() * 1000.0f);
                }
            }
        } else {
            this.debug("Unable to find size in text {}", new Object[]{sizeElement.ownText()});
            return null;
        }
        item.setSize(Long.valueOf(size.longValue()));
        Matcher nfoMatcher = NFO_INFO_PATTERN.matcher(infoElement.ownText());
        item.setHasNfo(nfoMatcher.find() ? SearchResultItem.HasNfo.YES : SearchResultItem.HasNfo.NO);
        Element ageElement = this.getElementOrNone(row, "td:nth-child(4)");
        if (ageElement == null) {
            this.debug("Unable to find pubdate in row {}", new Object[]{row.text()});
            return null;
        }
        String pubdateString = ageElement.text();
        Instant pubdate = Binsearch.convertToInstant((String)pubdateString);
        item.setPubDate(pubdate);
        item.setAgePrecise(false);
        item.setCategory(this.categoryProvider.getNotAvailable());
        item.setIndexer((Indexer)this);
        item.setDownloadType(DownloadType.NZB);
        item.setIndexerScore(Integer.valueOf(this.config.getScore()));
        return item;
    }

    private Element getElementOrNone(Element parent, String selector) {
        Elements selectionResult = parent.select(selector);
        return selectionResult.size() == 0 ? null : (Element)selectionResult.get(0);
    }

    protected UriComponentsBuilder buildSearchUrl(SearchRequest searchRequest, Integer offset, Integer limit) throws IndexerSearchAbortedException {
        String query = super.generateQueryIfApplicable(searchRequest, "");
        if (Strings.isNullOrEmpty((String)(query = this.addRequiredWordsToQuery(searchRequest, query)))) {
            throw new IndexerSearchAbortedException("Binsearch cannot search without a query");
        }
        query = this.cleanupQuery(query);
        UriComponentsBuilder queryBuilder = UriComponentsBuilder.fromHttpUrl((String)"https://www.binsearch.info/").queryParam("max", new Object[]{limit}).queryParam("q", new Object[]{query});
        if (this.getConfig().isBinsearchOtherGroups()) {
            queryBuilder = queryBuilder.queryParam("server", new Object[]{"2"});
        }
        return queryBuilder;
    }

    private String addRequiredWordsToQuery(SearchRequest searchRequest, String query) {
        List requiredWords = searchRequest.getInternalData().getRequiredWords();
        requiredWords.addAll(this.configProvider.getBaseConfig().getSearching().getRequiredWords());
        requiredWords.addAll(searchRequest.getCategory().getRequiredWords());
        if (!requiredWords.isEmpty()) {
            query = (String)query + (((String)query).isEmpty() ? "" : " ") + Joiner.on((String)" ").join((Iterable)requiredWords);
        }
        return query;
    }

    public NfoResult getNfo(String guid) {
        URI nfoUri = UriComponentsBuilder.fromHttpUrl((String)this.config.getHost()).pathSegment(new String[]{"viewNFO.php"}).queryParam("oid", new Object[]{guid}).build().toUri();
        try {
            String html = (String)this.getAndStoreResultToDatabase(nfoUri, String.class, IndexerApiAccessType.NFO);
            Matcher matcher = NFO_PATTERN.matcher(html);
            if (!matcher.find()) {
                return NfoResult.withoutNfo();
            }
            return NfoResult.withNfo((String)matcher.group("nfo"));
        }
        catch (IndexerAccessException e) {
            return NfoResult.unsuccessful((String)e.getMessage());
        }
    }

    protected String getAndStoreResultToDatabase(URI uri, IndexerApiAccessType apiAccessType) throws IndexerAccessException {
        return (String)Failsafe.with((Policy)this.retry503policy, (Policy[])new RetryPolicy[0]).onFailure(throwable -> logger.warn("Encountered 503 error. Will retry")).get((CheckedSupplier)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected Logger getLogger() {
        return logger;
    }

    private static Instant convertToInstant(String ageString) {
        Pattern pattern = Pattern.compile("(\\d+)\\s+(second|seconds|minute|minutes|hour|hours|day|days|week|weeks|month|months|year|years)");
        Matcher matcher = pattern.matcher(ageString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid age string format: " + ageString);
        }
        int quantity = Integer.parseInt(matcher.group(1));
        String unit = matcher.group(2).toLowerCase();
        LocalDateTime now = LocalDateTime.now(clock);
        LocalDateTime result = switch (unit) {
            case "second", "seconds" -> now.minusSeconds(quantity);
            case "minute", "minutes" -> now.minusMinutes(quantity);
            case "hour", "hours" -> now.minusHours(quantity);
            case "day", "days" -> now.minusDays(quantity);
            case "week", "weeks" -> now.minusWeeks(quantity);
            case "month", "months" -> now.minusMonths(quantity);
            case "year", "years" -> now.minusYears(quantity);
            default -> throw new IllegalArgumentException("Unsupported time unit: " + unit);
        };
        return result.toInstant(ZoneOffset.UTC);
    }
}

