/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import org.nzbhydra.NzbHydraException;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.Newznab;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.mapping.newznab.mock.NewznabMockBuilder;
import org.nzbhydra.mapping.newznab.mock.NewznabMockRequest;
import org.nzbhydra.mapping.newznab.xml.NewznabAttribute;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlItem;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlRoot;
import org.nzbhydra.mapping.newznab.xml.Xml;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="devindexer")
@Scope(value="prototype")
public class DevIndexer
extends Newznab {
    protected Xml getAndStoreResultToDatabase(URI uri, IndexerApiAccessType apiAccessType) throws IndexerAccessException {
        NewznabXmlRoot rssRoot = new NewznabXmlRoot();
        if (uri.toString().contains("oneduplicate")) {
            NewznabMockRequest mockRequest = NewznabMockRequest.builder().numberOfResults(1).titleBase("oneresult").titleWords(Collections.emptyList()).total(1).build();
            rssRoot = NewznabMockBuilder.generateResponse((NewznabMockRequest)mockRequest);
            rssRoot.getRssChannel().getNewznabResponse().setTotal(Integer.valueOf(1));
            ((NewznabXmlItem)rssRoot.getRssChannel().getItems().get(0)).getEnclosure().setLength(Long.valueOf(100000L));
            ((NewznabXmlItem)rssRoot.getRssChannel().getItems().get(0)).getNewznabAttributes().clear();
        } else if (uri.toString().contains("duplicatesandtitlegroups")) {
            NewznabMockRequest mockRequest = NewznabMockRequest.builder().numberOfResults(1).titleBase("oneresult").titleWords(Collections.emptyList()).total(1).build();
            rssRoot = NewznabMockBuilder.generateResponse((NewznabMockRequest)mockRequest);
            ((NewznabXmlItem)rssRoot.getRssChannel().getItems().get(0)).getEnclosure().setLength(Long.valueOf(100000L));
            ((NewznabXmlItem)rssRoot.getRssChannel().getItems().get(0)).getNewznabAttributes().clear();
            ((NewznabXmlItem)rssRoot.getRssChannel().getItems().get(0)).getTorznabAttributes().clear();
            ((NewznabXmlItem)rssRoot.getRssChannel().getItems().get(0)).getNewznabAttributes().add(new NewznabAttribute("grabs", "100"));
            mockRequest = NewznabMockRequest.builder().numberOfResults(1).titleBase("oneresult").titleWords(Collections.emptyList()).total(1).build();
            NewznabXmlRoot rssRoot3 = NewznabMockBuilder.generateResponse((NewznabMockRequest)mockRequest);
            ((NewznabXmlItem)rssRoot3.getRssChannel().getItems().get(0)).getEnclosure().setLength(Long.valueOf(200000L));
            ((NewznabXmlItem)rssRoot3.getRssChannel().getItems().get(0)).getNewznabAttributes().clear();
            ((NewznabXmlItem)rssRoot3.getRssChannel().getItems().get(0)).getTorznabAttributes().clear();
            ((NewznabXmlItem)rssRoot3.getRssChannel().getItems().get(0)).getNewznabAttributes().add(new NewznabAttribute("grabs", "2000"));
            ((NewznabXmlItem)rssRoot3.getRssChannel().getItems().get(0)).setLink("anotherlink");
            rssRoot.getRssChannel().getItems().add((NewznabXmlItem)rssRoot3.getRssChannel().getItems().get(0));
            mockRequest = NewznabMockRequest.builder().numberOfResults(1).titleBase("anotherresult").titleWords(Collections.emptyList()).total(1).build();
            NewznabXmlRoot rssRoot2 = NewznabMockBuilder.generateResponse((NewznabMockRequest)mockRequest);
            rssRoot.getRssChannel().getItems().add((NewznabXmlItem)rssRoot2.getRssChannel().getItems().get(0));
            rssRoot.getRssChannel().getNewznabResponse().setTotal(Integer.valueOf(3));
        } else if (uri.toString().contains("duplicates")) {
            NewznabMockRequest mockRequest = NewznabMockRequest.builder().numberOfResults(10).titleBase("duplicates").titleWords(Collections.emptyList()).total(10).build();
            rssRoot = NewznabMockBuilder.generateResponse((NewznabMockRequest)mockRequest);
            rssRoot.getRssChannel().getNewznabResponse().setTotal(Integer.valueOf(10));
            for (NewznabXmlItem rssItem : rssRoot.getRssChannel().getItems()) {
                rssItem.getEnclosure().setLength(Long.valueOf(100000L));
                rssItem.getNewznabAttributes().clear();
                rssItem.setPubDate(Instant.now());
                rssItem.setDescription("Indexer: " + this.getName() + ", title:" + rssItem.getTitle());
            }
        } else if (uri.toString().contains("tworesults")) {
            rssRoot = NewznabMockBuilder.generateResponse((int)0, (int)2, (String)"results", (boolean)false, Collections.emptyList(), (boolean)false, (int)0);
            rssRoot.getRssChannel().getNewznabResponse().setTotal(Integer.valueOf(2));
        } else {
            rssRoot = NewznabMockBuilder.generateResponse((int)0, (int)100, (String)"results", (boolean)false, Collections.emptyList(), (boolean)false, (int)0);
            rssRoot.getRssChannel().getNewznabResponse().setTotal(Integer.valueOf(100));
        }
        if (uri.toString().contains("punkte")) {
            ((NewznabXmlItem)rssRoot.getRssChannel().getItems().get(0)).setTitle("a a");
            ((NewznabXmlItem)rssRoot.getRssChannel().getItems().get(1)).setTitle("ab");
            ((NewznabXmlItem)rssRoot.getRssChannel().getItems().get(2)).setTitle("a.c");
        }
        return rssRoot;
    }

    protected SearchResultItem createSearchResultItem(NewznabXmlItem item) throws NzbHydraException {
        SearchResultItem resultItem = super.createSearchResultItem(item);
        return resultItem;
    }
}

