/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import com.google.common.base.MoreObjects;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.Objects;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.nzbhydra.indexers.IndexerAccessResult;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.IndexerEntity;
import org.nzbhydra.springnative.ReflectionMarker;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@ReflectionMarker
@Entity
@Table(name="indexerapiaccess")
public final class IndexerApiAccessEntity {
    @Id
    @SequenceGenerator(allocationSize=1, name="INDEXERAPIACCESS_SEQ")
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    protected int id;
    @ManyToOne
    @OnDelete(action=OnDeleteAction.CASCADE)
    private IndexerEntity indexer;
    @Convert(converter=Jsr310JpaConverters.InstantConverter.class)
    private Instant time;
    @Enumerated(value=EnumType.STRING)
    private IndexerAccessResult result;
    @Enumerated(value=EnumType.STRING)
    private IndexerApiAccessType accessType;
    private Long responseTime;
    @Column(length=4000)
    private String error;

    public IndexerApiAccessEntity(IndexerEntity indexerEntity) {
        this.indexer = indexerEntity;
        this.time = Instant.now();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexerApiAccessEntity that = (IndexerApiAccessEntity)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("time", (Object)this.time).add("result", (Object)this.result).add("accessType", (Object)this.accessType).add("responseTime", (Object)this.responseTime).add("error", (Object)this.error).toString();
    }

    public int getId() {
        return this.id;
    }

    public IndexerEntity getIndexer() {
        return this.indexer;
    }

    public Instant getTime() {
        return this.time;
    }

    public IndexerAccessResult getResult() {
        return this.result;
    }

    public IndexerApiAccessType getAccessType() {
        return this.accessType;
    }

    public Long getResponseTime() {
        return this.responseTime;
    }

    public String getError() {
        return this.error;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setIndexer(IndexerEntity indexer) {
        this.indexer = indexer;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public void setResult(IndexerAccessResult result) {
        this.result = result;
    }

    public void setAccessType(IndexerApiAccessType accessType) {
        this.accessType = accessType;
    }

    public void setResponseTime(Long responseTime) {
        this.responseTime = responseTime;
    }

    public void setError(String error) {
        this.error = error;
    }

    public IndexerApiAccessEntity() {
    }
}

