/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.time.Instant;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.IndexerEntity;
import org.nzbhydra.springnative.ReflectionMarker;
import org.springframework.data.jpa.convert.threeten.Jsr310JpaConverters;

@ReflectionMarker
@Entity
@Table(name="indexerapiaccess_short")
public final class IndexerApiAccessEntityShort {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE)
    @SequenceGenerator(allocationSize=1, name="INDEXERAPIACCESS_SHORT_SEQ")
    protected int id;
    @Column(name="INDEXER_ID")
    private int indexerId;
    @Convert(converter=Jsr310JpaConverters.InstantConverter.class)
    private Instant time;
    private boolean successful;
    @Enumerated(value=EnumType.STRING)
    @Column(name="API_ACCESS_TYPE")
    private IndexerApiAccessType apiAccessType;

    public IndexerApiAccessEntityShort(IndexerEntity indexerEntity, boolean successsful, IndexerApiAccessType apiAccessType) {
        this.indexerId = indexerEntity.getId();
        this.time = Instant.now();
        this.successful = successsful;
        this.apiAccessType = apiAccessType;
    }

    public int getId() {
        return this.id;
    }

    public int getIndexerId() {
        return this.indexerId;
    }

    public Instant getTime() {
        return this.time;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public IndexerApiAccessType getApiAccessType() {
        return this.apiAccessType;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setIndexerId(int indexerId) {
        this.indexerId = indexerId;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public void setSuccessful(boolean successful) {
        this.successful = successful;
    }

    public void setApiAccessType(IndexerApiAccessType apiAccessType) {
        this.apiAccessType = apiAccessType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexerApiAccessEntityShort)) {
            return false;
        }
        IndexerApiAccessEntityShort other = (IndexerApiAccessEntityShort)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getIndexerId() != other.getIndexerId()) {
            return false;
        }
        if (this.isSuccessful() != other.isSuccessful()) {
            return false;
        }
        Instant this$time = this.getTime();
        Instant other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        IndexerApiAccessType this$apiAccessType = this.getApiAccessType();
        IndexerApiAccessType other$apiAccessType = other.getApiAccessType();
        return !(this$apiAccessType == null ? other$apiAccessType != null : !this$apiAccessType.equals(other$apiAccessType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getIndexerId();
        result = result * 59 + (this.isSuccessful() ? 79 : 97);
        Instant $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        IndexerApiAccessType $apiAccessType = this.getApiAccessType();
        result = result * 59 + ($apiAccessType == null ? 43 : $apiAccessType.hashCode());
        return result;
    }

    public String toString() {
        return "IndexerApiAccessEntityShort(id=" + this.getId() + ", indexerId=" + this.getIndexerId() + ", time=" + String.valueOf(this.getTime()) + ", successful=" + this.isSuccessful() + ", apiAccessType=" + String.valueOf(this.getApiAccessType()) + ")";
    }

    public IndexerApiAccessEntityShort() {
    }
}

