/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import jakarta.persistence.EntityExistsException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.searching.SearchResultIdCalculator;
import org.nzbhydra.searching.db.SearchResultEntity;
import org.nzbhydra.searching.db.SearchResultRepository;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class IndexerSearchResultPersistor {
    private static final Logger log = LoggerFactory.getLogger(IndexerSearchResultPersistor.class);
    private final SearchResultRepository searchResultRepository;

    public IndexerSearchResultPersistor(SearchResultRepository searchResultRepository) {
        this.searchResultRepository = searchResultRepository;
    }

    @Transactional
    public List<SearchResultItem> persistSearchResults(Indexer<?> indexer, List<SearchResultItem> searchResultItems, IndexerSearchResult indexerSearchResult) {
        ArrayList<SearchResultEntity> searchResultEntities = new ArrayList<SearchResultEntity>();
        Set alreadySavedIds = this.searchResultRepository.findAllIdsByIdIn(searchResultItems.stream().map(SearchResultIdCalculator::calculateSearchResultId).collect(Collectors.toList()));
        for (SearchResultItem item : searchResultItems) {
            long guid = SearchResultIdCalculator.calculateSearchResultId((SearchResultItem)item);
            if (!alreadySavedIds.contains(guid)) {
                SearchResultEntity searchResultEntity = new SearchResultEntity();
                searchResultEntity.setIndexer(indexer.getIndexerEntity());
                searchResultEntity.setTitle(item.getTitle());
                searchResultEntity.setLink(item.getLink());
                searchResultEntity.setDetails(item.getDetails());
                searchResultEntity.setIndexerGuid(item.getIndexerGuid());
                searchResultEntity.setFirstFound(Instant.now());
                searchResultEntity.setDownloadType(item.getDownloadType());
                searchResultEntity.setPubDate(item.getPubDate());
                searchResultEntities.add(searchResultEntity);
            }
            item.setGuid(Long.valueOf(guid));
            item.setSearchResultId(Long.valueOf(guid));
        }
        indexer.debug("Found {} results which were already in the database and {} new ones", new Object[]{alreadySavedIds.size(), searchResultEntities.size()});
        try {
            this.searchResultRepository.saveAll(searchResultEntities);
            indexerSearchResult.setSearchResultEntities(new HashSet(searchResultEntities));
        }
        catch (EntityExistsException e) {
            indexer.error("Unable to save the search results to the database", (Throwable)e);
        }
        return searchResultItems;
    }
}

