/*
 * Decompiled with CFR 0.152.
 */
package org.nzbhydra.indexers;

import com.google.common.base.Joiner;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.internal.Strings;
import org.nzbhydra.config.downloading.DownloadType;
import org.nzbhydra.config.searching.SearchType;
import org.nzbhydra.indexers.Indexer;
import org.nzbhydra.indexers.IndexerApiAccessType;
import org.nzbhydra.indexers.NfoResult;
import org.nzbhydra.indexers.exceptions.IndexerAccessException;
import org.nzbhydra.indexers.exceptions.IndexerSearchAbortedException;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlItem;
import org.nzbhydra.mapping.newznab.xml.NewznabXmlRoot;
import org.nzbhydra.searching.SearchResultAcceptor;
import org.nzbhydra.searching.dtoseventsenums.IndexerSearchResult;
import org.nzbhydra.searching.dtoseventsenums.SearchResultItem;
import org.nzbhydra.searching.searchrequests.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="nzbindex")
@Scope(value="prototype")
public class NzbIndex
extends Indexer<NewznabXmlRoot> {
    private static final Logger logger = LoggerFactory.getLogger(NzbIndex.class);
    private static final Pattern GUID_PATTERN = Pattern.compile(".*/download/(\\d+).*", 32);
    private static final Pattern NFO_PATTERN = Pattern.compile(".*<pre id=\"nfo0\">(.*)</pre>.*", 34);

    protected void completeIndexerSearchResult(NewznabXmlRoot response, IndexerSearchResult indexerSearchResult, SearchResultAcceptor.AcceptorResult acceptorResult, SearchRequest searchRequest, int offset, Integer limit) {
        indexerSearchResult.setTotalResultsKnown(true);
        indexerSearchResult.setTotalResults(acceptorResult.getNumberOfRejectedResults() + indexerSearchResult.getSearchResultItems().size());
        indexerSearchResult.setHasMoreResults(false);
        indexerSearchResult.setOffset(0);
        indexerSearchResult.setPageSize(250);
    }

    protected List<SearchResultItem> getSearchResultItems(NewznabXmlRoot rssRoot, SearchRequest searchRequest) {
        if (rssRoot.getRssChannel().getItems() == null || rssRoot.getRssChannel().getItems().isEmpty()) {
            this.debug("No results found", new Object[0]);
            return Collections.emptyList();
        }
        ArrayList<SearchResultItem> items = new ArrayList<SearchResultItem>();
        for (NewznabXmlItem rssItem : rssRoot.getRssChannel().getItems()) {
            SearchResultItem item = new SearchResultItem();
            item.setPubDate(rssItem.getPubDate());
            String nzbIndexLink = rssItem.getLink();
            item.setTitle(rssItem.getTitle());
            item.setAgePrecise(true);
            if (rssItem.getCategory() != null) {
                item.setGroup(rssItem.getCategory().replace("a.b", "alt.binaries"));
            }
            if (rssItem.getEnclosure() == null || rssItem.getEnclosure().getUrl() == null) {
                logger.error("Unable to parse '{}' result for link - missing URL. Skipping it", (Object)nzbIndexLink);
                continue;
            }
            item.setLink(rssItem.getEnclosure().getUrl());
            item.setSize(rssItem.getEnclosure().getLength());
            Matcher matcher = GUID_PATTERN.matcher(nzbIndexLink);
            boolean found = matcher.find();
            if (!found) {
                logger.error("Unable to parse '{}' result for link - missing GUID. Skipping it", (Object)nzbIndexLink);
                continue;
            }
            item.setIndexerGuid(matcher.group(1));
            item.setCategory(this.categoryProvider.getNotAvailable());
            item.setOriginalCategory("N/A");
            item.setIndexerScore(Integer.valueOf(this.config.getScore()));
            if (item.getDescription() != null) {
                item.setHasNfo(rssItem.getDescription().contains("1 NFO") ? SearchResultItem.HasNfo.YES : SearchResultItem.HasNfo.NO);
            } else {
                item.setHasNfo(SearchResultItem.HasNfo.NO);
            }
            item.setIndexer((Indexer)this);
            item.setDownloadType(DownloadType.NZB);
            items.add(item);
        }
        return items;
    }

    protected UriComponentsBuilder buildSearchUrl(SearchRequest searchRequest, Integer offset, Integer limit) throws IndexerSearchAbortedException {
        UriComponentsBuilder componentsBuilder = this.getBaseUri().path("rss").queryParam("more", new Object[]{"1"}).queryParam("max", new Object[]{250}).queryParam("hidecross", new Object[]{"0"});
        if (searchRequest.getMinsize().isPresent()) {
            componentsBuilder.queryParam("minsize", new Object[]{searchRequest.getMinsize().get()});
        } else if (this.config.getGeneralMinSize().isPresent()) {
            componentsBuilder.queryParam("minsize", new Object[]{this.config.getGeneralMinSize().get()});
        }
        if (searchRequest.getMaxsize().isPresent()) {
            componentsBuilder.queryParam("maxsize", new Object[]{searchRequest.getMaxsize().get()});
        }
        if (searchRequest.getMinage().isPresent()) {
            componentsBuilder.queryParam("minage", new Object[]{searchRequest.getMinage().get()});
        }
        if (searchRequest.getMaxage().isPresent()) {
            componentsBuilder.queryParam("age", new Object[]{searchRequest.getMaxage().get()});
        }
        String query = "";
        if (Strings.isNullOrEmpty((String)(query = this.generateQueryIfApplicable(searchRequest, query)))) {
            throw new IndexerSearchAbortedException("Binsearch cannot search without a query");
        }
        query = this.addRequiredAndforbiddenWordsToQuery(searchRequest, query);
        query = this.cleanupQuery(query);
        componentsBuilder.queryParam("q", new Object[]{query});
        return componentsBuilder;
    }

    private String addRequiredAndforbiddenWordsToQuery(SearchRequest searchRequest, String query) {
        ArrayList requiredWords = new ArrayList(searchRequest.getInternalData().getRequiredWords());
        requiredWords.addAll(this.configProvider.getBaseConfig().getSearching().getRequiredWords());
        requiredWords.addAll(searchRequest.getCategory().getRequiredWords());
        if (!requiredWords.isEmpty()) {
            query = (String)query + (((String)query).isEmpty() ? "" : " ") + Joiner.on((String)" ").join(requiredWords);
        }
        ArrayList forbiddenWords = new ArrayList(searchRequest.getInternalData().getForbiddenWords());
        forbiddenWords.addAll(this.configProvider.getBaseConfig().getSearching().getForbiddenWords());
        forbiddenWords.addAll(searchRequest.getCategory().getForbiddenWords());
        if (!forbiddenWords.isEmpty()) {
            query = (String)query + (((String)query).isEmpty() ? "" : " ") + "-" + Joiner.on((String)" -").join(forbiddenWords);
        }
        return query;
    }

    protected String generateQueryIfApplicable(SearchRequest searchRequest, String query) throws IndexerSearchAbortedException {
        query = super.generateQueryIfApplicable(searchRequest, (String)query);
        if (searchRequest.getSearchType() == SearchType.BOOK) {
            query = (String)query + " ebook | pdf | mobi | epub";
        }
        return query;
    }

    public NfoResult getNfo(String guid) {
        URI nfoUri = this.getBaseUri().pathSegment(new String[]{"nfo", guid}).build().toUri();
        try {
            String html = (String)this.getAndStoreResultToDatabase(nfoUri, String.class, IndexerApiAccessType.NFO);
            Matcher matcher = NFO_PATTERN.matcher(html);
            if (!matcher.find()) {
                return NfoResult.withoutNfo();
            }
            return NfoResult.withNfo((String)matcher.group(1));
        }
        catch (IndexerAccessException e) {
            return NfoResult.unsuccessful((String)e.getMessage());
        }
    }

    protected NewznabXmlRoot getAndStoreResultToDatabase(URI uri, IndexerApiAccessType apiAccessType) throws IndexerAccessException {
        return (NewznabXmlRoot)this.getAndStoreResultToDatabase(uri, NewznabXmlRoot.class, apiAccessType);
    }

    protected Logger getLogger() {
        return logger;
    }

    protected UriComponentsBuilder getBaseUri() {
        return UriComponentsBuilder.fromHttpUrl((String)this.config.getHost());
    }
}

